/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.Iterator;
import java.util.Optional;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.FluidStorageSingleTankMethods;
import me.jddev0.ep.block.entity.base.WorkerFluidMachineBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.fluid.SimpleFluidStorage;
import me.jddev0.ep.inventory.CombinedContainerData;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.inventory.data.BooleanValueContainerData;
import me.jddev0.ep.inventory.data.ComparatorModeValueContainerData;
import me.jddev0.ep.inventory.data.EnergyValueContainerData;
import me.jddev0.ep.inventory.data.IntegerValueContainerData;
import me.jddev0.ep.inventory.data.ProgressValueContainerData;
import me.jddev0.ep.inventory.data.RedstoneModeValueContainerData;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.screen.FluidPumpMenu;
import me.jddev0.ep.util.FluidUtils;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3913;
import net.minecraft.class_5712;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidPumpBlockEntity
extends WorkerFluidMachineBlockEntity<SimpleFluidStorage, class_2338> {
    public static final int NEXT_BLOCK_COOLDOWN = ModConfigs.COMMON_FLUID_PUMP_NEXT_BLOCK_COOLDOWN.getValue();
    public static final int EXTRACTION_DURATION = ModConfigs.COMMON_FLUID_PUMP_EXTRACTION_DURATION.getValue();
    public static final int RANGE = ModConfigs.COMMON_FLUID_PUMP_EXTRACTION_RANGE.getValue();
    public static final int DEPTH = ModConfigs.COMMON_FLUID_PUMP_EXTRACTION_DEPTH.getValue();
    private int xOffset = -1;
    private int yOffset = 0;
    private int zOffset = -1;
    private boolean extractingFluid = false;
    final InputOutputItemHandler itemHandlerSided = new InputOutputItemHandler((class_1263)this.itemHandler, (i, stack) -> true, i -> false);

    public FluidPumpBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(EPBlockEntities.FLUID_PUMP_ENTITY, blockPos, blockState, "fluid_pump", 1, 1, ModConfigs.COMMON_FLUID_PUMP_CAPACITY.getValue(), ModConfigs.COMMON_FLUID_PUMP_TRANSFER_RATE.getValue(), (long)ModConfigs.COMMON_FLUID_PUMP_CONSUMPTION_PER_TICK.getValue(), FluidStorageSingleTankMethods.INSTANCE, FluidUtils.convertMilliBucketsToDroplets(ModConfigs.COMMON_FLUID_PUMP_FLUID_TANK_CAPACITY.getValue() * 1000L), UpgradeModuleModifier.SPEED, UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_CAPACITY, UpgradeModuleModifier.EXTRACTION_RANGE, UpgradeModuleModifier.EXTRACTION_DEPTH);
    }

    @Override
    protected class_1277 initInventoryStorage() {
        return new class_1277(this.slotCount){

            public boolean method_5437(int slot, class_1799 stack) {
                if (slot == 0) {
                    return stack.method_31574(class_1802.field_20412);
                }
                return super.method_5437(slot, stack);
            }

            public void method_5447(int slot, class_1799 stack) {
                if (slot == 0) {
                    class_1799 itemStack = this.method_5438(slot);
                    if (!(FluidPumpBlockEntity.this.field_11863 == null || stack.method_7960() || itemStack.method_7960() || class_1799.method_31577((class_1799)stack, (class_1799)itemStack))) {
                        FluidPumpBlockEntity.this.resetProgress();
                    }
                }
                super.method_5447(slot, stack);
            }

            public void method_5431() {
                super.method_5431();
                FluidPumpBlockEntity.this.method_5431();
            }
        };
    }

    @Override
    protected SimpleFluidStorage initFluidStorage() {
        return new SimpleFluidStorage(this.baseTankCapacity){

            protected void onFinalCommit() {
                FluidPumpBlockEntity.this.method_5431();
                FluidPumpBlockEntity.this.syncFluidToPlayers(32);
            }
        };
    }

    @Override
    protected class_3913 initContainerData() {
        return new CombinedContainerData(new ProgressValueContainerData(() -> this.progress, value -> {
            this.progress = value;
        }), new ProgressValueContainerData(() -> this.maxProgress, value -> {
            this.maxProgress = value;
        }), new EnergyValueContainerData(() -> this.hasWork() ? this.getCurrentWorkData().map(x$0 -> this.getEnergyConsumptionFor(x$0)).orElse(-1L) : -1L, value -> {}), new EnergyValueContainerData(() -> this.energyConsumptionLeft, value -> {}), new BooleanValueContainerData(() -> this.hasEnoughEnergy, value -> {}), new IntegerValueContainerData(() -> this.xOffset, value -> {}), new IntegerValueContainerData(() -> this.yOffset, value -> {}), new IntegerValueContainerData(() -> this.zOffset, value -> {}), new BooleanValueContainerData(() -> this.extractingFluid, value -> {}), new RedstoneModeValueContainerData(() -> this.redstoneMode, value -> {
            this.redstoneMode = value;
        }), new ComparatorModeValueContainerData(() -> this.comparatorMode, value -> {
            this.comparatorMode = value;
        }));
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        this.syncEnergyToPlayer(player);
        this.syncFluidToPlayer(player);
        return new FluidPumpMenu(id, this, inventory, (class_1263)this.itemHandler, this.upgradeModuleInventory, this.data);
    }

    @Override
    protected void method_11007(@NotNull class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10569("target.xOffset", this.xOffset);
        nbt.method_10569("target.yOffset", this.yOffset);
        nbt.method_10569("target.zOffset", this.zOffset);
        nbt.method_10556("recipe.extractingFluid", this.extractingFluid);
    }

    @Override
    public void method_11014(@NotNull class_2487 nbt) {
        super.method_11014(nbt);
        this.xOffset = nbt.method_10550("target.xOffset");
        this.yOffset = nbt.method_10550("target.yOffset");
        this.zOffset = nbt.method_10550("target.zOffset");
        this.extractingFluid = nbt.method_10577("recipe.extractingFluid");
    }

    @Override
    protected void onTickStart() {
        super.onTickStart();
        if (this.yOffset == 0) {
            this.goToNextOffset();
            this.method_5431();
        }
    }

    @Override
    protected boolean hasWork() {
        return this.yOffset != 0 && this.itemHandler.method_5438(0).method_31574(class_1802.field_20412);
    }

    @Override
    protected Optional<class_2338> getCurrentWorkData() {
        return Optional.of(this.field_11867.method_10069(this.xOffset, this.yOffset, this.zOffset));
    }

    @Override
    protected double getWorkDataDependentWorkDuration(class_2338 targetPos) {
        return this.extractingFluid ? (double)EXTRACTION_DURATION : (double)NEXT_BLOCK_COOLDOWN;
    }

    @Override
    protected void onWorkStarted(class_2338 targetPos) {
        class_2680 targetState = this.field_11863.method_8320(targetPos);
        if (!(targetState.method_26204() instanceof class_2263)) {
            return;
        }
        class_3610 targetFluidState = this.field_11863.method_8316(targetPos);
        if (targetFluidState.method_15769()) {
            return;
        }
        try (Transaction transaction = Transaction.openOuter();){
            if (((SimpleFluidStorage)this.fluidStorage).insert((TransferVariant)FluidVariant.of((class_3611)targetFluidState.method_15772()), 81000L, (TransactionContext)transaction) != 81000L) {
                return;
            }
        }
        this.extractingFluid = true;
    }

    @Override
    protected void onWorkCompleted(class_2338 targetPos) {
        class_2263 targetBlock;
        class_1799 bucketItemStack;
        class_2248 class_22482;
        class_2680 targetState = this.field_11863.method_8320(targetPos);
        if (this.extractingFluid && (class_22482 = targetState.method_26204()) instanceof class_2263 && !(bucketItemStack = (targetBlock = (class_2263)class_22482).method_9700((class_1936)this.field_11863, targetPos, targetState)).method_7960()) {
            Iterator iterator;
            this.field_11863.method_33596(null, class_5712.field_28167, targetPos);
            Storage fluidStorage = (Storage)FluidStorage.ITEM.find(bucketItemStack, (Object)ContainerItemContext.withConstant((class_1799)bucketItemStack));
            if (fluidStorage != null && (iterator = fluidStorage.iterator()).hasNext()) {
                FluidVariant fluidVariant;
                StorageView fluidView = (StorageView)iterator.next();
                if (!iterator.hasNext() && !(fluidVariant = (FluidVariant)fluidView.getResource()).isBlank()) {
                    try (Transaction transaction = Transaction.openOuter();){
                        ((SimpleFluidStorage)this.fluidStorage).insert((TransferVariant)fluidVariant, fluidView.getAmount(), (TransactionContext)transaction);
                        transaction.commit();
                    }
                    class_2680 newTargetState = this.field_11863.method_8320(targetPos);
                    if (newTargetState.method_26215() || newTargetState.method_45474()) {
                        this.itemHandler.method_5434(0, 1);
                        this.field_11863.method_8652(targetPos, class_2246.field_10445.method_9564(), 3);
                    }
                }
            }
        }
        this.resetProgress();
        this.goToNextOffset();
    }

    @Override
    protected void resetProgress() {
        super.resetProgress();
        this.extractingFluid = false;
    }

    @Override
    protected void updateUpgradeModules() {
        this.xOffset = -1;
        this.yOffset = 0;
        this.zOffset = -1;
        super.updateUpgradeModules();
    }

    public void goToNextOffset() {
        int range = (int)Math.ceil((double)RANGE * this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.EXTRACTION_RANGE) * this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.RANGE));
        int depth = (int)Math.ceil((double)DEPTH * this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.EXTRACTION_DEPTH));
        if (this.yOffset == 0) {
            this.yOffset = -1;
            this.xOffset = range;
            this.zOffset = 0;
        } else if (this.zOffset >= range - Math.abs(this.xOffset)) {
            if (-this.xOffset >= range) {
                --this.yOffset;
                if (-this.yOffset >= depth || this.method_11016().method_10264() + this.yOffset < this.field_11863.method_31607()) {
                    this.yOffset = -1;
                }
                this.xOffset = range;
                this.zOffset = 0;
                return;
            }
            --this.xOffset;
            this.zOffset = Math.abs(this.xOffset) - range;
        } else {
            ++this.zOffset;
        }
    }
}

