/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import me.jddev0.ep.block.TeleporterBlock;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.MenuInventoryEnergyStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergizedPowerEnergyStorage;
import me.jddev0.ep.energy.EnergizedPowerLimitingEnergyStorage;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.item.EPItems;
import me.jddev0.ep.item.TeleporterMatrixItem;
import me.jddev0.ep.screen.TeleporterMenu;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1301;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2767;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3341;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5575;
import net.minecraft.class_5894;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;

public class TeleporterBlockEntity
extends MenuInventoryEnergyStorageBlockEntity<EnergizedPowerEnergyStorage, class_1277> {
    public static final boolean INTRA_DIMENSIONAL_ENABLED = ModConfigs.COMMON_TELEPORTER_INTRA_DIMENSIONAL_ENABLED.getValue();
    public static final boolean INTER_DIMENSIONAL_ENABLED = ModConfigs.COMMON_TELEPORTER_INTER_DIMENSIONAL_ENABLED.getValue();
    public static final List<@NotNull class_2960> DIMENSION_BLACKLIST = ModConfigs.COMMON_TELEPORTER_DIMENSION_BLACKLIST.getValue();
    public static final List<@NotNull class_2960> INTRA_DIMENSIONAL_BLACKLIST = ModConfigs.COMMON_TELEPORTER_INTRA_DIMENSIONAL_BLACKLIST.getValue();
    public static final List<@NotNull class_2960> INTER_DIMENSIONAL_FROM_BLACKLIST = ModConfigs.COMMON_TELEPORTER_INTER_DIMENSIONAL_FROM_BLACKLIST.getValue();
    public static final List<@NotNull class_2960> INTER_DIMENSIONAL_TO_BLACKLIST = ModConfigs.COMMON_TELEPORTER_INTER_DIMENSIONAL_TO_BLACKLIST.getValue();
    public static final List<@NotNull class_2960> DIMENSION_TYPE_BLACKLIST = ModConfigs.COMMON_TELEPORTER_DIMENSION_TYPE_BLACKLIST.getValue();
    public static final List<@NotNull class_2960> INTRA_DIMENSIONAL_TYPE_BLACKLIST = ModConfigs.COMMON_TELEPORTER_INTRA_DIMENSIONAL_TYPE_BLACKLIST.getValue();
    public static final List<@NotNull class_2960> INTER_DIMENSIONAL_FROM_TYPE_BLACKLIST = ModConfigs.COMMON_TELEPORTER_INTER_DIMENSIONAL_FROM_TYPE_BLACKLIST.getValue();
    public static final List<@NotNull class_2960> INTER_DIMENSIONAL_TO_TYPE_BLACKLIST = ModConfigs.COMMON_TELEPORTER_INTER_DIMENSIONAL_TO_TYPE_BLACKLIST.getValue();
    final InputOutputItemHandler itemHandlerSided;

    public TeleporterBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(EPBlockEntities.TELEPORTER_ENTITY, blockPos, blockState, "teleporter", ModConfigs.COMMON_TELEPORTER_CAPACITY.getValue(), ModConfigs.COMMON_TELEPORTER_TRANSFER_RATE.getValue(), 1);
        this.itemHandlerSided = new InputOutputItemHandler((class_1263)this.itemHandler, (i, stack) -> true, i -> true);
    }

    @Override
    protected EnergizedPowerEnergyStorage initEnergyStorage() {
        return new EnergizedPowerEnergyStorage(this.baseEnergyCapacity, this.baseEnergyCapacity, this.baseEnergyCapacity){

            protected void onFinalCommit() {
                TeleporterBlockEntity.this.setChangedAndUpdateReadyState();
                TeleporterBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Override
    protected EnergizedPowerLimitingEnergyStorage initLimitingEnergyStorage() {
        return new EnergizedPowerLimitingEnergyStorage(this.energyStorage, this.baseEnergyTransferRate, 0L);
    }

    @Override
    protected class_1277 initInventoryStorage() {
        return new class_1277(this.slotCount){

            public int method_5444() {
                return 1;
            }

            public boolean method_5437(int slot, class_1799 stack) {
                if (slot == 0) {
                    return stack.method_31574(EPItems.TELEPORTER_MATRIX);
                }
                return super.method_5437(slot, stack);
            }

            public void method_5431() {
                super.method_5431();
                TeleporterBlockEntity.this.setChangedAndUpdateReadyState();
            }
        };
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        this.syncEnergyToPlayer(player);
        return new TeleporterMenu(id, this, inventory, (class_1263)this.itemHandler);
    }

    public int getRedstoneOutput() {
        return class_1703.method_7618((class_1263)this.itemHandler);
    }

    public void setChangedAndUpdateReadyState() {
        boolean powered;
        boolean oldPowered = this.field_11863.method_8320(this.field_11867).method_28498((class_2769)TeleporterBlock.POWERED) && (Boolean)this.field_11863.method_8320(this.field_11867).method_11654((class_2769)TeleporterBlock.POWERED) != false;
        class_1799 teleporterMatrixItemStack = this.itemHandler.method_5438(0);
        boolean bl = powered = ((EnergizedPowerEnergyStorage)this.energyStorage).getAmount() == ((EnergizedPowerEnergyStorage)this.energyStorage).getCapacity() && teleporterMatrixItemStack.method_31574(EPItems.TELEPORTER_MATRIX) && TeleporterMatrixItem.isLinked(teleporterMatrixItemStack);
        if (oldPowered ^ powered) {
            this.field_11863.method_8652(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)TeleporterBlock.POWERED, (Comparable)Boolean.valueOf(powered)), 3);
        }
        this.method_5431();
    }

    public void onRedstoneTriggered() {
        class_3222 serverPlayer;
        class_1657 class_16572;
        block6: {
            block5: {
                if (Transaction.isOpen()) {
                    return;
                }
                Optional<class_1657> player = this.field_11863.method_18023(class_5575.method_31795(class_1657.class), class_238.method_19316((class_3341)class_3341.method_34390((class_2382)new class_2382(this.field_11867.method_10263() - 2, this.field_11867.method_10264() - 2, this.field_11867.method_10260() - 2), (class_2382)new class_2382(this.field_11867.method_10263() + 2, this.field_11867.method_10264() + 2, this.field_11867.method_10260() + 2))), class_1301.field_6155.and(entity -> entity.method_5707(this.field_11867.method_46558()) <= 4.0)).stream().min(Comparator.comparing(entity -> entity.method_5707(this.field_11867.method_46558())));
                if (player.isEmpty()) {
                    return;
                }
                class_16572 = player.get();
                if (!(class_16572 instanceof class_3222)) break block5;
                serverPlayer = (class_3222)class_16572;
                class_16572 = this.field_11863;
                if (class_16572 instanceof class_3218) break block6;
            }
            return;
        }
        class_3218 serverLevel = (class_3218)class_16572;
        serverLevel.method_8503().method_5382(() -> this.teleportPlayer(serverPlayer));
    }

    public void teleportPlayer(class_3222 player) {
        EnergyStorage energyStorage = (EnergyStorage)EnergyStorage.SIDED.find(player.method_37908(), this.field_11867, null);
        if (energyStorage == null) {
            return;
        }
        TeleporterBlockEntity.teleportPlayer(player, energyStorage, () -> {
            try (Transaction transaction = Transaction.openOuter();){
                ((EnergizedPowerEnergyStorage)this.energyStorage).extract(((EnergizedPowerEnergyStorage)this.energyStorage).getCapacity(), (TransactionContext)transaction);
                transaction.commit();
            }
        }, this.itemHandler.method_5438(0), this.field_11863, this.field_11867);
    }

    public static void teleportPlayer(class_3222 player, EnergyStorage energyStorage, Runnable clearEnergyCallback, class_1799 teleporterMatrixItemStack, class_1937 level, @Nullable class_2338 pos) {
        class_2960 toDimensionId;
        if (player.method_7325()) {
            return;
        }
        if (energyStorage.getAmount() < energyStorage.getCapacity()) {
            player.field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43471((String)"tooltip.energizedpower.teleporter.use.not_enough_energy").method_27692(class_124.field_1061)));
            return;
        }
        if (!teleporterMatrixItemStack.method_31574(EPItems.TELEPORTER_MATRIX)) {
            player.field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43471((String)"tooltip.energizedpower.teleporter.use.no_teleporter_matrix").method_27692(class_124.field_1061)));
            return;
        }
        if (!TeleporterMatrixItem.isLinked(teleporterMatrixItemStack)) {
            player.field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43471((String)"tooltip.energizedpower.teleporter.use.teleporter_matrix_not_bound").method_27692(class_124.field_1061)));
            return;
        }
        class_2338 toPos = TeleporterMatrixItem.getBlockPos(level, teleporterMatrixItemStack);
        if (toPos == null) {
            player.field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43471((String)"tooltip.energizedpower.teleporter.use.teleporter_matrix_invalid_position").method_27692(class_124.field_1061)));
            return;
        }
        class_1937 toDimension = TeleporterMatrixItem.getDimension(level, teleporterMatrixItemStack);
        if (!(toDimension instanceof class_3218)) {
            player.field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43471((String)"tooltip.energizedpower.teleporter.use.teleporter_matrix_invalid_dimension").method_27692(class_124.field_1061)));
            return;
        }
        if (pos != null && pos.equals((Object)toPos) && level.method_27983().equals(toDimension.method_27983())) {
            player.field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43471((String)"tooltip.energizedpower.teleporter.use.teleporter_self_position").method_27692(class_124.field_1061)));
            return;
        }
        class_2960 fromDimensionId = level.method_27983().method_29177();
        boolean intraDimensional = fromDimensionId.equals((Object)(toDimensionId = toDimension.method_27983().method_29177()));
        if (intraDimensional && !INTRA_DIMENSIONAL_ENABLED) {
            player.field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43469((String)"tooltip.energizedpower.teleporter.use.intra_dimensional_disabled", (Object[])new Object[]{fromDimensionId.toString()}).method_27692(class_124.field_1061)));
            return;
        }
        if (!intraDimensional && !INTER_DIMENSIONAL_ENABLED) {
            player.field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43469((String)"tooltip.energizedpower.teleporter.use.inter_dimensional_disabled", (Object[])new Object[]{fromDimensionId.toString()}).method_27692(class_124.field_1061)));
            return;
        }
        if (DIMENSION_BLACKLIST.contains(fromDimensionId)) {
            player.field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43469((String)"tooltip.energizedpower.teleporter.use.blacklist.dimension", (Object[])new Object[]{fromDimensionId.toString()}).method_27692(class_124.field_1061)));
            return;
        }
        if (DIMENSION_BLACKLIST.contains(toDimensionId)) {
            player.field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43469((String)"tooltip.energizedpower.teleporter.use.blacklist.dimension", (Object[])new Object[]{toDimensionId.toString()}).method_27692(class_124.field_1061)));
            return;
        }
        if (intraDimensional && INTRA_DIMENSIONAL_BLACKLIST.contains(fromDimensionId)) {
            player.field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43469((String)"tooltip.energizedpower.teleporter.use.blacklist.intra_dimensional", (Object[])new Object[]{fromDimensionId.toString()}).method_27692(class_124.field_1061)));
            return;
        }
        if (!intraDimensional && INTER_DIMENSIONAL_FROM_BLACKLIST.contains(fromDimensionId)) {
            player.field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43469((String)"tooltip.energizedpower.teleporter.use.blacklist.inter_dimensional_from", (Object[])new Object[]{fromDimensionId.toString()}).method_27692(class_124.field_1061)));
            return;
        }
        if (!intraDimensional && INTER_DIMENSIONAL_TO_BLACKLIST.contains(toDimensionId)) {
            player.field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43469((String)"tooltip.energizedpower.teleporter.use.blacklist.inter_dimensional_to", (Object[])new Object[]{toDimensionId.toString()}).method_27692(class_124.field_1061)));
            return;
        }
        class_2960 fromDimensionTypeId = level.method_44013().method_29177();
        class_2960 toDimensionTypeId = toDimension.method_44013().method_29177();
        if (DIMENSION_TYPE_BLACKLIST.contains(fromDimensionTypeId)) {
            player.field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43469((String)"tooltip.energizedpower.teleporter.use.blacklist.dimension_type", (Object[])new Object[]{fromDimensionTypeId.toString()}).method_27692(class_124.field_1061)));
            return;
        }
        if (DIMENSION_TYPE_BLACKLIST.contains(toDimensionTypeId)) {
            player.field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43469((String)"tooltip.energizedpower.teleporter.use.blacklist.dimension_type", (Object[])new Object[]{toDimensionTypeId.toString()}).method_27692(class_124.field_1061)));
            return;
        }
        if (intraDimensional && INTRA_DIMENSIONAL_TYPE_BLACKLIST.contains(fromDimensionTypeId)) {
            player.field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43469((String)"tooltip.energizedpower.teleporter.use.blacklist.intra_dimensional_type", (Object[])new Object[]{fromDimensionTypeId.toString()}).method_27692(class_124.field_1061)));
            return;
        }
        if (!intraDimensional && INTER_DIMENSIONAL_FROM_TYPE_BLACKLIST.contains(fromDimensionTypeId)) {
            player.field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43469((String)"tooltip.energizedpower.teleporter.use.blacklist.inter_dimensional_from_type", (Object[])new Object[]{fromDimensionTypeId.toString()}).method_27692(class_124.field_1061)));
            return;
        }
        if (!intraDimensional && INTER_DIMENSIONAL_TO_TYPE_BLACKLIST.contains(toDimensionTypeId)) {
            player.field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43469((String)"tooltip.energizedpower.teleporter.use.blacklist.inter_dimensional_to_type", (Object[])new Object[]{toDimensionTypeId.toString()}).method_27692(class_124.field_1061)));
            return;
        }
        class_2586 toBlockEntity = toDimension.method_8321(toPos);
        if (!(toBlockEntity instanceof TeleporterBlockEntity)) {
            player.field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43471((String)"tooltip.energizedpower.teleporter.use.teleporter_matrix_no_teleporter").method_27692(class_124.field_1061)));
            return;
        }
        clearEnergyCallback.run();
        class_243 toPosCenter = toPos.method_46558();
        player.method_48105((class_3218)toDimension, toPosCenter.method_10216(), (double)(toPos.method_10264() + 1), toPosCenter.method_10215(), new HashSet(), 0.0f, 0.0f);
        player.field_13987.method_14364((class_2596)new class_2767(class_6880.method_40223((Object)class_3417.field_14879), class_3419.field_15245, toPosCenter.method_10216(), (double)toPos.method_10264(), toPosCenter.method_10215(), 1.0f, 1.0f, toDimension.method_8409().method_43055()));
    }

    public int getSlotCount() {
        return this.itemHandler.method_5439();
    }

    public class_1799 getStack(int slot) {
        return this.itemHandler.method_5438(slot);
    }
}

