/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.ArrayList;
import me.jddev0.ep.block.UnchargerBlock;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.ConfigurableUpgradableInventoryEnergyStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergizedPowerEnergyStorage;
import me.jddev0.ep.energy.EnergizedPowerLimitingEnergyStorage;
import me.jddev0.ep.inventory.CombinedContainerData;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.inventory.data.ComparatorModeValueContainerData;
import me.jddev0.ep.inventory.data.EnergyValueContainerData;
import me.jddev0.ep.inventory.data.RedstoneModeValueContainerData;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.screen.UnchargerMenu;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2503;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3913;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.EnergyStorageUtil;

public class UnchargerBlockEntity
extends ConfigurableUpgradableInventoryEnergyStorageBlockEntity<EnergizedPowerEnergyStorage, class_1277> {
    final InputOutputItemHandler itemHandlerSided;
    private long energyProductionLeft;

    public UnchargerBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(EPBlockEntities.UNCHARGER_ENTITY, blockPos, blockState, "uncharger", ModConfigs.COMMON_UNCHARGER_CAPACITY.getValue(), ModConfigs.COMMON_UNCHARGER_TRANSFER_RATE.getValue(), 1, UpgradeModuleModifier.ENERGY_CAPACITY);
        this.itemHandlerSided = new InputOutputItemHandler((class_1263)this.itemHandler, (i, stack) -> true, i -> {
            if (i != 0) {
                return false;
            }
            class_1799 itemStack = this.itemHandler.method_5438(i.intValue());
            if (!EnergyStorageUtil.isEnergyStorage((class_1799)itemStack)) {
                return true;
            }
            EnergyStorage limitingEnergyStorage = (EnergyStorage)EnergyStorage.ITEM.find(itemStack, (Object)ContainerItemContext.ofSingleSlot((SingleSlotStorage)((SingleSlotStorage)InventoryStorage.of((class_1263)this.itemHandler, null).getSlots().get((int)i))));
            if (limitingEnergyStorage == null) {
                return true;
            }
            if (!limitingEnergyStorage.supportsExtraction()) {
                return true;
            }
            return limitingEnergyStorage.getAmount() == 0L;
        });
        this.energyProductionLeft = -1L;
    }

    @Override
    protected EnergizedPowerEnergyStorage initEnergyStorage() {
        return new EnergizedPowerEnergyStorage(this.baseEnergyCapacity, this.baseEnergyCapacity, this.baseEnergyCapacity){

            @Override
            public long getCapacity() {
                return Math.max(1L, (long)Math.ceil((double)this.capacity * UnchargerBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CAPACITY)));
            }

            protected void onFinalCommit() {
                UnchargerBlockEntity.this.method_5431();
                UnchargerBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Override
    protected EnergizedPowerLimitingEnergyStorage initLimitingEnergyStorage() {
        return new EnergizedPowerLimitingEnergyStorage(this.energyStorage, 0L, this.baseEnergyTransferRate){

            @Override
            public long getMaxExtract() {
                return Math.max(1L, (long)Math.ceil((double)this.maxExtract * UnchargerBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_TRANSFER_RATE)));
            }
        };
    }

    @Override
    protected class_1277 initInventoryStorage() {
        return new class_1277(this.slotCount){

            public int method_5444() {
                return 1;
            }

            public boolean method_5437(int slot, class_1799 stack) {
                if (slot == 0) {
                    if (!EnergyStorageUtil.isEnergyStorage((class_1799)stack)) {
                        return false;
                    }
                    EnergyStorage limitingEnergyStorage = (EnergyStorage)EnergyStorage.ITEM.find(stack, (Object)ContainerItemContext.withConstant((class_1799)stack));
                    if (limitingEnergyStorage == null) {
                        return false;
                    }
                    return limitingEnergyStorage.supportsExtraction();
                }
                return super.method_5437(slot, stack);
            }

            public void method_5447(int slot, class_1799 stack) {
                if (slot == 0) {
                    class_1799 itemStack = this.method_5438(slot);
                    if (!(stack.method_7960() || itemStack.method_7960() || class_1799.method_7984((class_1799)stack, (class_1799)itemStack) && (class_1799.method_31577((class_1799)stack, (class_1799)itemStack) || EnergyStorageUtil.isEnergyStorage((class_1799)stack) && EnergyStorageUtil.isEnergyStorage((class_1799)itemStack)))) {
                        UnchargerBlockEntity.this.resetProgress();
                    }
                }
                super.method_5447(slot, stack);
            }

            public void method_5431() {
                super.method_5431();
                UnchargerBlockEntity.this.method_5431();
            }
        };
    }

    @Override
    protected class_3913 initContainerData() {
        return new CombinedContainerData(new EnergyValueContainerData(() -> this.hasRecipe() ? this.getEnergyProductionPerTick() : -1L, value -> {}), new EnergyValueContainerData(() -> this.energyProductionLeft, value -> {}), new RedstoneModeValueContainerData(() -> this.redstoneMode, value -> {
            this.redstoneMode = value;
        }), new ComparatorModeValueContainerData(() -> this.comparatorMode, value -> {
            this.comparatorMode = value;
        }));
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        this.syncEnergyToPlayer(player);
        return new UnchargerMenu(id, this, inventory, (class_1263)this.itemHandler, this.upgradeModuleInventory, this.data);
    }

    @Override
    protected void method_11007(@NotNull class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10566("recipe.energy_production_left", (class_2520)class_2503.method_23251((long)this.energyProductionLeft));
    }

    @Override
    public void method_11014(@NotNull class_2487 nbt) {
        super.method_11014(nbt);
        this.energyProductionLeft = nbt.method_10537("recipe.energy_production_left");
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, UnchargerBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        if (blockEntity.redstoneMode.isActive((Boolean)state.method_11654((class_2769)UnchargerBlock.POWERED))) {
            UnchargerBlockEntity.tickRecipe(level, blockPos, state, blockEntity);
        }
        UnchargerBlockEntity.transferEnergy(level, blockPos, state, blockEntity);
    }

    protected final long getEnergyProductionPerTick() {
        class_1799 stack = this.itemHandler.method_5438(0);
        if (!EnergyStorageUtil.isEnergyStorage((class_1799)stack)) {
            return -1L;
        }
        EnergyStorage limitingEnergyStorage = (EnergyStorage)EnergyStorage.ITEM.find(stack, (Object)ContainerItemContext.ofSingleSlot((SingleSlotStorage)((SingleSlotStorage)InventoryStorage.of((class_1263)this.itemHandler, null).getSlots().get(0))));
        if (limitingEnergyStorage == null) {
            return -1L;
        }
        if (!limitingEnergyStorage.supportsExtraction()) {
            return -1L;
        }
        try (Transaction transaction = Transaction.openOuter();){
            long l = limitingEnergyStorage.extract(Math.max(0L, Math.min(this.limitingEnergyStorage.getMaxExtract(), ((EnergizedPowerEnergyStorage)this.energyStorage).getCapacity() - ((EnergizedPowerEnergyStorage)this.energyStorage).getAmount())), (TransactionContext)transaction);
            return l;
        }
    }

    public static void tickRecipe(class_1937 level, class_2338 blockPos, class_2680 state, UnchargerBlockEntity blockEntity) {
        if (blockEntity.hasRecipe()) {
            class_1799 stack = blockEntity.itemHandler.method_5438(0);
            if (!EnergyStorageUtil.isEnergyStorage((class_1799)stack)) {
                return;
            }
            EnergyStorage limitingEnergyStorage = (EnergyStorage)EnergyStorage.ITEM.find(stack, (Object)ContainerItemContext.ofSingleSlot((SingleSlotStorage)((SingleSlotStorage)InventoryStorage.of((class_1263)blockEntity.itemHandler, null).getSlots().get(0))));
            if (limitingEnergyStorage == null) {
                return;
            }
            if (!limitingEnergyStorage.supportsExtraction()) {
                return;
            }
            blockEntity.energyProductionLeft = limitingEnergyStorage.getAmount();
            if (blockEntity.energyProductionLeft < 0L) {
                blockEntity.resetProgress();
                UnchargerBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
                return;
            }
            blockEntity.energyProductionLeft -= EnergyStorageUtil.move((EnergyStorage)limitingEnergyStorage, (EnergyStorage)blockEntity.energyStorage, (long)blockEntity.limitingEnergyStorage.getMaxExtract(), null);
            if (blockEntity.energyProductionLeft <= 0L) {
                blockEntity.resetProgress();
            }
            UnchargerBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
        } else {
            blockEntity.resetProgress();
            UnchargerBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
        }
    }

    private static void transferEnergy(class_1937 level, class_2338 blockPos, class_2680 state, UnchargerBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        ArrayList<EnergyStorage> consumerItems = new ArrayList<EnergyStorage>();
        ArrayList<Long> consumerEnergyValues = new ArrayList<Long>();
        long consumptionSum = 0L;
        for (class_2350 direction : class_2350.values()) {
            EnergyStorage limitingEnergyStorage;
            class_2338 testPos = blockPos.method_10093(direction);
            class_2586 testBlockEntity = level.method_8321(testPos);
            if (testBlockEntity == null || (limitingEnergyStorage = (EnergyStorage)EnergyStorage.SIDED.find(level, testPos, (Object)direction.method_10153())) == null || !limitingEnergyStorage.supportsInsertion()) continue;
            try (Transaction transaction = Transaction.openOuter();){
                long received = limitingEnergyStorage.insert(Math.min(blockEntity.limitingEnergyStorage.getMaxExtract(), ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).getAmount()), (TransactionContext)transaction);
                if (received <= 0L) continue;
                consumptionSum += received;
                consumerItems.add(limitingEnergyStorage);
                consumerEnergyValues.add(received);
            }
        }
        ArrayList<Long> consumerEnergyDistributed = new ArrayList<Long>();
        for (int i = 0; i < consumerItems.size(); ++i) {
            consumerEnergyDistributed.add(0L);
        }
        long consumptionLeft = Math.min(blockEntity.limitingEnergyStorage.getMaxExtract(), Math.min(((EnergizedPowerEnergyStorage)blockEntity.energyStorage).getAmount(), consumptionSum));
        try (Transaction transaction = Transaction.openOuter();){
            ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).extract(consumptionLeft, (TransactionContext)transaction);
            transaction.commit();
        }
        int divisor = consumerItems.size();
        block18: while (consumptionLeft > 0L) {
            long consumptionPerConsumer = consumptionLeft / (long)divisor;
            if (consumptionPerConsumer == 0L) {
                divisor = Math.max(1, divisor - 1);
                consumptionPerConsumer = consumptionLeft / (long)divisor;
            }
            for (int i = 0; i < consumerEnergyValues.size(); ++i) {
                long consumptionDistributed = (Long)consumerEnergyDistributed.get(i);
                long consumptionOfConsumerLeft = (Long)consumerEnergyValues.get(i) - consumptionDistributed;
                long consumptionDistributedNew = Math.min(consumptionOfConsumerLeft, Math.min(consumptionPerConsumer, consumptionLeft));
                consumerEnergyDistributed.set(i, consumptionDistributed + consumptionDistributedNew);
                if ((consumptionLeft -= consumptionDistributedNew) == 0L) break block18;
            }
        }
        for (int i = 0; i < consumerItems.size(); ++i) {
            long energy = (Long)consumerEnergyDistributed.get(i);
            if (energy <= 0L) continue;
            try (Transaction transaction = Transaction.openOuter();){
                ((EnergyStorage)consumerItems.get(i)).insert(energy, (TransactionContext)transaction);
                transaction.commit();
                continue;
            }
        }
    }

    private void resetProgress() {
        this.energyProductionLeft = -1L;
    }

    private boolean hasRecipe() {
        class_1799 stack = this.itemHandler.method_5438(0);
        return EnergyStorageUtil.isEnergyStorage((class_1799)stack);
    }

    @Override
    protected void updateUpgradeModules() {
        this.resetProgress();
        super.updateUpgradeModules();
    }
}

