/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity.base;

import java.util.Optional;
import me.jddev0.ep.block.entity.base.ConfigurableUpgradableInventoryFluidEnergyStorageBlockEntity;
import me.jddev0.ep.block.entity.base.FluidStorageMethods;
import me.jddev0.ep.energy.EnergizedPowerEnergyStorage;
import me.jddev0.ep.energy.EnergizedPowerLimitingEnergyStorage;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1277;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2503;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import org.jetbrains.annotations.NotNull;

public abstract class WorkerFluidMachineBlockEntity<F extends Storage<FluidVariant>, W>
extends ConfigurableUpgradableInventoryFluidEnergyStorageBlockEntity<EnergizedPowerEnergyStorage, class_1277, F> {
    protected final long baseEnergyConsumptionPerTick;
    protected final int baseWorkDuration;
    protected int progress;
    protected int maxProgress;
    protected long energyConsumptionLeft = -1L;
    protected boolean hasEnoughEnergy;

    public WorkerFluidMachineBlockEntity(class_2591<?> type, class_2338 blockPos, class_2680 blockState, String machineName, int slotCount, int baseWorkDuration, long baseEnergyCapacity, long baseEnergyTransferRate, long baseEnergyConsumptionPerTick, FluidStorageMethods<F> fluidStorageMethods, long baseTankCapacity, UpgradeModuleModifier ... upgradeModifierSlots) {
        super(type, blockPos, blockState, machineName, baseEnergyCapacity, baseEnergyTransferRate, slotCount, fluidStorageMethods, baseTankCapacity, upgradeModifierSlots);
        this.baseEnergyConsumptionPerTick = baseEnergyConsumptionPerTick;
        this.baseWorkDuration = baseWorkDuration;
    }

    @Override
    protected EnergizedPowerEnergyStorage initEnergyStorage() {
        return new EnergizedPowerEnergyStorage(this.baseEnergyCapacity, this.baseEnergyCapacity, this.baseEnergyCapacity){

            @Override
            public long getCapacity() {
                return Math.max(1L, (long)Math.ceil((double)this.capacity * WorkerFluidMachineBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CAPACITY)));
            }

            protected void onFinalCommit() {
                WorkerFluidMachineBlockEntity.this.method_5431();
                WorkerFluidMachineBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Override
    protected EnergizedPowerLimitingEnergyStorage initLimitingEnergyStorage() {
        return new EnergizedPowerLimitingEnergyStorage(this.energyStorage, this.baseEnergyTransferRate, 0L){

            @Override
            public long getMaxInsert() {
                return Math.max(1L, (long)Math.ceil((double)this.maxInsert * WorkerFluidMachineBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_TRANSFER_RATE)));
            }
        };
    }

    @Override
    protected void method_11007(@NotNull class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10566("recipe.progress", (class_2520)class_2497.method_23247((int)this.progress));
        nbt.method_10566("recipe.max_progress", (class_2520)class_2497.method_23247((int)this.maxProgress));
        nbt.method_10566("recipe.energy_consumption_left", (class_2520)class_2503.method_23251((long)this.energyConsumptionLeft));
    }

    @Override
    public void method_11014(@NotNull class_2487 nbt) {
        super.method_11014(nbt);
        this.progress = nbt.method_10550("recipe.progress");
        this.maxProgress = nbt.method_10550("recipe.max_progress");
        this.energyConsumptionLeft = nbt.method_10537("recipe.energy_consumption_left");
    }

    public static <F extends Storage<FluidVariant>, W> void tick(class_1937 level, class_2338 blockPos, class_2680 state, WorkerFluidMachineBlockEntity<F, W> blockEntity) {
        if (level.field_9236) {
            return;
        }
        blockEntity.onTickStart();
        if (!blockEntity.redstoneMode.isActive((Boolean)state.method_11654((class_2769)class_2741.field_12484))) {
            return;
        }
        if (blockEntity.hasWork()) {
            Optional<W> workData = blockEntity.getCurrentWorkData();
            if (workData.isEmpty()) {
                blockEntity.onTickEnd();
                return;
            }
            if (blockEntity.maxProgress == 0) {
                blockEntity.onWorkStarted(workData.get());
                blockEntity.maxProgress = blockEntity.getWorkDurationFor(workData.get());
            }
            long energyConsumptionPerTick = blockEntity.getEnergyConsumptionFor(workData.get());
            if (blockEntity.energyConsumptionLeft < 0L) {
                blockEntity.energyConsumptionLeft = energyConsumptionPerTick * (long)blockEntity.maxProgress;
            }
            if (energyConsumptionPerTick <= ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).getAmount()) {
                blockEntity.hasEnoughEnergy = true;
                blockEntity.onHasEnoughEnergy();
                if (blockEntity.progress < 0 || blockEntity.maxProgress < 0 || blockEntity.energyConsumptionLeft < 0L) {
                    blockEntity.resetProgress();
                    WorkerFluidMachineBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
                    blockEntity.onTickEnd();
                    return;
                }
                try (Transaction transaction = Transaction.openOuter();){
                    ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).extract(energyConsumptionPerTick, (TransactionContext)transaction);
                    transaction.commit();
                }
                blockEntity.energyConsumptionLeft -= energyConsumptionPerTick;
                ++blockEntity.progress;
                if (blockEntity.progress >= blockEntity.maxProgress) {
                    blockEntity.onWorkCompleted(workData.get());
                }
                WorkerFluidMachineBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
            } else {
                blockEntity.hasEnoughEnergy = false;
                blockEntity.onHasNotEnoughEnergy();
                WorkerFluidMachineBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
            }
        } else {
            blockEntity.resetProgress();
            blockEntity.onHasNotEnoughEnergy();
            WorkerFluidMachineBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
        }
        blockEntity.onTickEnd();
    }

    protected void onTickStart() {
    }

    protected void onTickEnd() {
    }

    protected void onHasEnoughEnergy() {
    }

    protected void onHasNotEnoughEnergy() {
    }

    protected final int getWorkDurationFor(W workData) {
        return Math.max(1, (int)Math.ceil((double)this.baseWorkDuration * this.getWorkDataDependentWorkDuration(workData) / this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.SPEED)));
    }

    protected final long getEnergyConsumptionFor(W workData) {
        return Math.max(1L, (long)Math.ceil((double)this.baseEnergyConsumptionPerTick * this.getWorkDataDependentEnergyConsumption(workData) * this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CONSUMPTION)));
    }

    protected double getWorkDataDependentWorkDuration(W workData) {
        return 1.0;
    }

    protected double getWorkDataDependentEnergyConsumption(W workData) {
        return 1.0;
    }

    protected abstract boolean hasWork();

    protected abstract Optional<W> getCurrentWorkData();

    protected abstract void onWorkStarted(W var1);

    protected abstract void onWorkCompleted(W var1);

    protected void resetProgress() {
        this.progress = 0;
        this.maxProgress = 0;
        this.energyConsumptionLeft = -1L;
        this.hasEnoughEnergy = false;
    }

    @Override
    protected void updateUpgradeModules() {
        this.resetProgress();
        super.updateUpgradeModules();
    }
}

