/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.datagen.generators;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import me.jddev0.ep.datagen.generators.PageContent;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_124;
import net.minecraft.class_2248;
import net.minecraft.class_2405;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public abstract class PageContentProvider
implements class_2405 {
    private final Map<String, PageContent> data = new TreeMap<String, PageContent>();
    private final FabricDataOutput output;
    private final CompletableFuture<class_7225.class_7874> lookupProvider;

    public PageContentProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> lookupProvider) {
        this.output = output;
        this.lookupProvider = lookupProvider;
    }

    protected abstract void registerPageContent();

    public CompletableFuture<?> method_10319(class_7403 cache) {
        return this.lookupProvider.thenCompose(lookupProvider -> this.run(cache, (class_7225.class_7874)lookupProvider));
    }

    private CompletableFuture<?> run(class_7403 cache, class_7225.class_7874 lookupProvider) {
        this.data.clear();
        this.registerPageContent();
        CompletableFuture[] futures = new CompletableFuture[this.data.size()];
        int i = 0;
        for (Map.Entry<String, PageContent> entry : this.data.entrySet()) {
            futures[i++] = this.savePageContent(cache, entry.getKey(), entry.getValue(), lookupProvider);
        }
        return CompletableFuture.allOf(futures);
    }

    private CompletableFuture<?> savePageContent(class_7403 cache, String pageId, PageContent content, class_7225.class_7874 lookupProvider) {
        Path target = this.output.method_45973(class_7784.class_7490.field_39368, "book_pages").method_44107(class_2960.method_43902((String)this.output.getModId(), (String)pageId));
        JsonObject json = content.toJson().getAsJsonObject();
        return class_2405.method_10320((class_7403)cache, (JsonElement)json, (Path)target);
    }

    public String method_10321() {
        return "Book Pages: " + this.output.getModId();
    }

    protected class_5250 addLinkToComponent(class_5250 component, String link) {
        return component.method_27695(new class_124[]{class_124.field_1078, class_124.field_1073}).method_27696(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11749, link)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"book.energizedpower.tooltip.link"))));
    }

    protected PageContent addSimplePage(String pageId, @Nullable class_2561 content) {
        return this.addPage(pageId, null, content, null, null);
    }

    protected PageContent addSimplePage(String pageId, @Nullable class_2561 content, @Nullable class_2960 image) {
        class_2960[] class_2960Array;
        if (image == null) {
            class_2960Array = null;
        } else {
            class_2960[] class_2960Array2 = new class_2960[1];
            class_2960Array = class_2960Array2;
            class_2960Array2[0] = image;
        }
        return this.addPage(pageId, null, content, class_2960Array, null);
    }

    protected PageContent addSimplePage(String pageId, @Nullable class_2561 content, @Nullable class_2960[] image) {
        return this.addPage(pageId, null, content, image, null);
    }

    protected PageContent addSimplePage(String pageId, @Nullable class_2561 content, class_2248 block) {
        return this.addSimplePage(pageId, content, new class_2248[]{block});
    }

    protected PageContent addSimplePage(String pageId, @Nullable class_2561 content, class_2248[] block) {
        class_2960[] blockIds = new class_2960[block.length];
        for (int i = 0; i < blockIds.length; ++i) {
            blockIds[i] = class_7923.field_41175.method_10221((Object)block[i]);
        }
        return this.addPage(pageId, null, content, null, blockIds);
    }

    protected PageContent addChapterPage(String pageId, @Nullable class_2561 title, @Nullable class_2561 content, class_2248 block) {
        return this.addChapterPage(pageId, title, content, new class_2248[]{block});
    }

    protected PageContent addChapterPage(String pageId, @Nullable class_2561 title, @Nullable class_2561 content, class_2248[] block) {
        class_2960[] blockIds = new class_2960[block.length];
        for (int i = 0; i < blockIds.length; ++i) {
            blockIds[i] = class_7923.field_41175.method_10221((Object)block[i]);
        }
        return this.addPage(pageId, title, content, null, blockIds);
    }

    protected PageContent addChapterPage(String pageId, @Nullable class_2561 title, @Nullable class_2561 content) {
        return this.addChapterPage(pageId, title, content, (class_2960[])null);
    }

    protected PageContent addChapterPage(String pageId, @Nullable class_2561 title, @Nullable class_2561 content, @Nullable class_2960 image) {
        class_2960[] class_2960Array;
        if (image == null) {
            class_2960Array = null;
        } else {
            class_2960[] class_2960Array2 = new class_2960[1];
            class_2960Array = class_2960Array2;
            class_2960Array2[0] = image;
        }
        return this.addPage(pageId, title, content, class_2960Array, null);
    }

    protected PageContent addChapterPage(String pageId, @Nullable class_2561 title, @Nullable class_2561 content, @Nullable class_2960[] image) {
        return this.addPage(pageId, title, content, image, null);
    }

    protected PageContent addPage(String pageId, @Nullable class_2561 title, @Nullable class_2561 content, @Nullable class_2960[] image, @Nullable class_2960[] block) {
        PageContent pageContent = new PageContent(class_2960.method_43902((String)this.output.getModId(), (String)pageId), title, content, image, block);
        this.data.put(pageId, pageContent);
        return pageContent;
    }
}

