/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.datagen.recipe;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.class_161;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_7710;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public record ShapedFinishedRecipe(class_2960 id, String group, class_7710 category, Map<Character, class_1856> key, String[] pattern, class_1792 result, int count, class_161.class_162 advancement, class_2960 advancementId) implements class_2444
{
    public ShapedFinishedRecipe(class_2960 id, String group, class_7710 category, Map<Character, class_1856> key, String[] pattern, class_1799 result, class_161.class_162 advancement, class_2960 advancementId) {
        this(id, group, category, key, pattern, result.method_7909(), result.method_7947(), advancement, advancementId);
    }

    public void method_10416(JsonObject jsonObject) {
        this.verifyData();
        if (!this.group.isEmpty()) {
            jsonObject.addProperty("group", this.group);
        }
        jsonObject.addProperty("category", this.category.method_15434());
        JsonArray patternJson = new JsonArray();
        for (String str : this.pattern) {
            patternJson.add(str);
        }
        jsonObject.add("pattern", (JsonElement)patternJson);
        JsonObject keyJson = new JsonObject();
        for (Map.Entry entry : this.key.entrySet()) {
            keyJson.add(String.valueOf(entry.getKey()), ((class_1856)entry.getValue()).method_8089());
        }
        jsonObject.add("key", (JsonElement)keyJson);
        JsonObject resultJson = new JsonObject();
        resultJson.addProperty("item", class_7923.field_41178.method_10221((Object)this.result).toString());
        if (this.count > 1) {
            resultJson.addProperty("count", (Number)this.count);
        }
        jsonObject.add("result", (JsonElement)resultJson);
    }

    public class_2960 method_10417() {
        return this.id;
    }

    public class_1865<?> method_17800() {
        return class_1865.field_9035;
    }

    @Nullable
    public JsonObject method_10415() {
        return this.advancement.method_698();
    }

    @Nullable
    public class_2960 method_10418() {
        return this.advancementId;
    }

    private void verifyData() {
        if (this.pattern.length == 0) {
            throw new IllegalStateException("No pattern is defined for shaped recipe " + String.valueOf(this.id) + "!");
        }
        HashSet set = Sets.newHashSet(this.key.keySet());
        set.remove(Character.valueOf(' '));
        for (String str : this.pattern) {
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (!this.key.containsKey(Character.valueOf(c)) && c != ' ') {
                    throw new IllegalStateException("Pattern in recipe " + String.valueOf(this.id) + " uses undefined symbol '" + c + "'");
                }
                set.remove(Character.valueOf(c));
            }
        }
        if (!set.isEmpty()) {
            throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + String.valueOf(this.id));
        }
        if (this.pattern.length == 1 && this.pattern[0].length() == 1) {
            throw new IllegalStateException("Shaped recipe " + String.valueOf(this.id) + " only takes in a single item - should it be a shapeless recipe instead?");
        }
    }
}

