/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.fluid;

import me.jddev0.ep.fluid.FluidStack;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.base.SingleFluidStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2487;

public class InfinityFluidStorage
extends SingleFluidStorage {
    public InfinityFluidStorage() {
        this.amount = Long.MAX_VALUE;
    }

    public boolean isEmpty() {
        return this.isResourceBlank();
    }

    public FluidStack getFluid() {
        return new FluidStack((FluidVariant)this.variant, Long.MAX_VALUE);
    }

    public void setFluid(FluidStack fluidStack) {
        this.variant = fluidStack.getFluidVariant();
    }

    protected long getCapacity(FluidVariant variant) {
        return Long.MAX_VALUE;
    }

    public void setFluid(FluidStack fluidStack, TransactionContext transaction) {
        FluidVariant fluidVariant = fluidStack.getFluidVariant();
        this.updateSnapshots(transaction);
        this.variant = fluidVariant;
    }

    public long insert(FluidVariant insertedVariant, long maxAmount, TransactionContext transaction) {
        return maxAmount;
    }

    public long extract(FluidVariant extractedVariant, long maxAmount, TransactionContext transaction) {
        return !extractedVariant.isBlank() && extractedVariant.isOf((Object)((FluidVariant)this.variant).getFluid()) && extractedVariant.nbtMatches(((FluidVariant)this.variant).getNbt()) ? maxAmount : 0L;
    }

    public class_2487 toNBT(class_2487 nbt) {
        return this.getFluid().toNBT(nbt);
    }

    public void fromNBT(class_2487 nbt) {
        FluidStack fluidStack = FluidStack.fromNbt(nbt);
        this.variant = fluidStack.getFluidVariant();
        this.amount = Long.MAX_VALUE;
    }
}

