/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.integration.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.block.entity.FluidTransposerBlockEntity;
import me.jddev0.ep.fluid.FluidStack;
import me.jddev0.ep.recipe.FluidTransposerRecipe;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3611;

public class FluidTransposerEMIRecipe
implements EmiRecipe {
    public static final class_2960 SIMPLIFIED_TEXTURE = EPAPI.id("textures/block/fluid_transposer_front.png");
    public static final EmiStack ITEM = EmiStack.of((class_1935)EPBlocks.FLUID_TRANSPOSER_ITEM);
    public static final EmiRecipeCategory CATEGORY = new EmiRecipeCategory(EPAPI.id("fluid_transposer"), (EmiRenderable)ITEM, (EmiRenderable)new EmiTexture(SIMPLIFIED_TEXTURE, 0, 0, 16, 16, 16, 16, 16, 16));
    private final class_2960 id;
    private final FluidTransposerBlockEntity.Mode mode;
    private final List<EmiIngredient> input;
    private final List<EmiStack> output;

    public FluidTransposerEMIRecipe(FluidTransposerRecipe recipe) {
        this.id = recipe.method_8114();
        this.mode = recipe.getMode();
        FluidStack fluid = recipe.getFluid();
        if (this.mode == FluidTransposerBlockEntity.Mode.EMPTYING) {
            this.input = List.of(EmiIngredient.of((class_1856)recipe.getInput()));
            this.output = List.of(EmiStack.of((class_1799)recipe.getOutputItem()), EmiStack.of((class_3611)fluid.getFluid(), (class_2487)fluid.getFluidVariant().getNbt(), (long)fluid.getDropletsAmount()));
        } else {
            this.input = List.of(EmiIngredient.of((class_1856)recipe.getInput()), EmiStack.of((class_3611)fluid.getFluid(), (class_2487)fluid.getFluidVariant().getNbt(), (long)fluid.getDropletsAmount()));
            this.output = List.of(EmiStack.of((class_1799)recipe.getOutputItem()));
        }
    }

    public EmiRecipeCategory getCategory() {
        return CATEGORY;
    }

    public class_2960 getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.input;
    }

    public List<EmiStack> getOutputs() {
        return this.output;
    }

    public int getDisplayWidth() {
        return 143;
    }

    public int getDisplayHeight() {
        return 26;
    }

    public void addWidgets(WidgetHolder widgets) {
        if (this.mode == FluidTransposerBlockEntity.Mode.EMPTYING) {
            widgets.addTexture(EPAPI.id("textures/gui/recipe/misc_gui.png"), 0, 0, 143, 26, 1, 133);
            widgets.addSlot(this.input.get(0), 0, 4).drawBack(false);
            widgets.addSlot((EmiIngredient)this.output.get(0), 63, 4).drawBack(false).recipeContext((EmiRecipe)this);
            widgets.addSlot((EmiIngredient)this.output.get(1), 89, 4).drawBack(false).recipeContext((EmiRecipe)this);
            widgets.addTexture(new class_2960("minecraft", "textures/item/bucket.png"), 120, 5, 16, 16, 0, 0, 16, 16, 16, 16);
        } else {
            widgets.addTexture(EPAPI.id("textures/gui/recipe/misc_gui.png"), 0, 0, 143, 26, 1, 161);
            widgets.addSlot(this.input.get(0), 0, 4).drawBack(false);
            widgets.addSlot(this.input.get(1), 18, 4).drawBack(false);
            widgets.addSlot((EmiIngredient)this.output.get(0), 89, 4).drawBack(false).recipeContext((EmiRecipe)this);
            widgets.addTexture(new class_2960("minecraft", "textures/item/water_bucket.png"), 120, 5, 16, 16, 0, 0, 16, 16, 16, 16);
        }
        widgets.addTooltipText(List.of(class_2561.method_43471((String)("tooltip.energizedpower.fluid_transposer.mode." + this.mode.method_15434()))), 118, 3, 20, 20);
    }
}

