/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.integration.jei;

import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.block.entity.FluidTransposerBlockEntity;
import me.jddev0.ep.fluid.FluidStack;
import me.jddev0.ep.recipe.FluidTransposerRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_5348;

public class FluidTransposerCategory
implements IRecipeCategory<FluidTransposerRecipe> {
    public static final class_2960 UID = EPAPI.id("fluid_transposer");
    public static final RecipeType<FluidTransposerRecipe> TYPE = new RecipeType(UID, FluidTransposerRecipe.class);
    private final IDrawable backgroundEmptying;
    private final IDrawable backgroundFilling;
    private final IDrawable icon;

    public FluidTransposerCategory(IGuiHelper helper) {
        class_2960 texture = EPAPI.id("textures/gui/recipe/misc_gui.png");
        this.backgroundEmptying = helper.createDrawable(texture, 1, 133, 143, 26);
        this.backgroundFilling = helper.createDrawable(texture, 1, 161, 143, 26);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new class_1799((class_1935)EPBlocks.FLUID_TRANSPOSER_ITEM));
    }

    public RecipeType<FluidTransposerRecipe> getRecipeType() {
        return TYPE;
    }

    public class_2561 getTitle() {
        return class_2561.method_43471((String)"container.energizedpower.fluid_transposer");
    }

    public IDrawable getBackground() {
        return this.backgroundEmptying;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder iRecipeLayout, FluidTransposerRecipe recipe, IFocusGroup iFocusGroup) {
        FluidStack fluid = recipe.getFluid();
        if (recipe.getMode() == FluidTransposerBlockEntity.Mode.EMPTYING) {
            iRecipeLayout.addSlot(RecipeIngredientRole.INPUT, 1, 5).addIngredients(recipe.getInput());
            iRecipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 64, 5).addItemStack(recipe.getOutputItem());
            iRecipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 90, 5).addFluidStack(fluid.getFluid(), fluid.getDropletsAmount(), fluid.getFluidVariant().getNbt());
        } else {
            iRecipeLayout.addSlot(RecipeIngredientRole.INPUT, 1, 5).addIngredients(recipe.getInput());
            iRecipeLayout.addSlot(RecipeIngredientRole.INPUT, 19, 5).addFluidStack(fluid.getFluid(), fluid.getDropletsAmount(), fluid.getFluidVariant().getNbt());
            iRecipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 90, 5).addItemStack(recipe.getOutputItem());
        }
    }

    public void draw(FluidTransposerRecipe recipe, IRecipeSlotsView iRecipeSlotsView, class_332 guiGraphics, double mouseX, double mouseY) {
        if (recipe.getMode() == FluidTransposerBlockEntity.Mode.FILLING) {
            this.backgroundFilling.draw(guiGraphics, 0, 0);
        }
        class_1799 output = new class_1799((class_1935)(recipe.getMode() == FluidTransposerBlockEntity.Mode.EMPTYING ? class_1802.field_8550 : class_1802.field_8705));
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(0.0f, 0.0f, 100.0f);
        guiGraphics.method_51428(output, 120, 5, 835);
        guiGraphics.method_51448().method_22909();
    }

    public void getTooltip(ITooltipBuilder tooltip, FluidTransposerRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        int tooltipX = 119;
        int tooltipY = 4;
        if (mouseX >= (double)(tooltipX - 1) && mouseX < (double)(tooltipX + 20 + 1) && mouseY >= (double)(tooltipY - 1) && mouseY < (double)(tooltipY + 20 + 1)) {
            tooltip.add((class_5348)class_2561.method_43471((String)("tooltip.energizedpower.fluid_transposer.mode." + recipe.getMode().method_15434())));
        }
    }
}

