/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.integration.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.block.entity.PlantGrowthChamberBlockEntity;
import me.jddev0.ep.recipe.OutputItemStackWithPercentages;
import me.jddev0.ep.recipe.PlantGrowthChamberRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotRichTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class PlantGrowthChamberCategory
implements IRecipeCategory<PlantGrowthChamberRecipe> {
    public static final class_2960 UID = EPAPI.id("plant_growth_chamber");
    public static final RecipeType<PlantGrowthChamberRecipe> TYPE = new RecipeType(UID, PlantGrowthChamberRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public PlantGrowthChamberCategory(IGuiHelper helper) {
        class_2960 texture = EPAPI.id("textures/gui/container/plant_growth_chamber.png");
        this.background = helper.createDrawable(texture, 61, 25, 108, 48);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new class_1799((class_1935)EPBlocks.PLANT_GROWTH_CHAMBER_ITEM));
    }

    public RecipeType<PlantGrowthChamberRecipe> getRecipeType() {
        return TYPE;
    }

    public class_2561 getTitle() {
        return class_2561.method_43471((String)"container.energizedpower.plant_growth_chamber");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder iRecipeLayout, PlantGrowthChamberRecipe recipe, IFocusGroup iFocusGroup) {
        iRecipeLayout.addSlot(RecipeIngredientRole.INPUT, 1, 10).addIngredients(recipe.getInput());
        ArrayList outputSlotEntries = new ArrayList(4);
        for (int i = 0; i < 4; ++i) {
            outputSlotEntries.add(new ArrayList());
        }
        class_1799[] outputEntries = recipe.getMaxOutputCounts();
        for (int i = 0; i < outputEntries.length; ++i) {
            ((List)outputSlotEntries.get(i % 4)).add(outputEntries[i]);
        }
        IRecipeSlotRichTooltipCallback callback = (view, tooltip) -> {
            if (view.isEmpty()) {
                return;
            }
            Optional optionalItemStack = view.getDisplayedItemStack();
            if (optionalItemStack.isEmpty()) {
                return;
            }
            tooltip.add((class_5348)class_2561.method_43471((String)"recipes.energizedpower.transfer.output_percentages"));
            OutputItemStackWithPercentages[] outputs = recipe.getOutputs();
            for (int i = 0; i < outputs.length; ++i) {
                if (!class_1799.method_31577((class_1799)((class_1799)optionalItemStack.get()), (class_1799)outputs[i].output())) continue;
                double[] percentages = outputs[i].percentages();
                for (int j = 0; j < percentages.length; ++j) {
                    tooltip.add((class_5348)class_2561.method_43470((String)String.format(Locale.ENGLISH, "%2d \u2022 %.2f %%", j + 1, 100.0 * percentages[j])));
                }
                return;
            }
        };
        ((IRecipeSlotBuilder)iRecipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 73, 1).addItemStacks((List)outputSlotEntries.get(0))).addRichTooltipCallback(callback);
        ((IRecipeSlotBuilder)iRecipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 91, 1).addItemStacks((List)outputSlotEntries.get(1))).addRichTooltipCallback(callback);
        ((IRecipeSlotBuilder)iRecipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 73, 19).addItemStacks((List)outputSlotEntries.get(2))).addRichTooltipCallback(callback);
        ((IRecipeSlotBuilder)iRecipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 91, 19).addItemStacks((List)outputSlotEntries.get(3))).addRichTooltipCallback(callback);
    }

    public void draw(PlantGrowthChamberRecipe recipe, IRecipeSlotsView iRecipeSlotsView, class_332 guiGraphics, double mouseX, double mouseY) {
        class_327 font = class_310.method_1551().field_1772;
        int ticks = (int)((float)recipe.getTicks() * PlantGrowthChamberBlockEntity.RECIPE_DURATION_MULTIPLIER);
        class_5250 component = class_2561.method_43469((String)"recipes.energizedpower.info.ticks", (Object[])new Object[]{ticks});
        int textWidth = font.method_27525((class_5348)component);
        guiGraphics.method_51439(class_310.method_1551().field_1772, (class_2561)component, 108 - textWidth, 40, -1, false);
    }
}

