/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.util.ItemStackUtils;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_5819;

public class PulverizerRecipe
implements class_1860<class_1263> {
    private final class_2960 id;
    private final OutputItemStackWithPercentages output;
    private final OutputItemStackWithPercentages secondaryOutput;
    private final class_1856 input;

    public PulverizerRecipe(class_2960 id, OutputItemStackWithPercentages output, OutputItemStackWithPercentages secondaryOutput, class_1856 input) {
        this.id = id;
        this.output = output;
        this.secondaryOutput = secondaryOutput;
        this.input = input;
    }

    public OutputItemStackWithPercentages getOutput() {
        return this.output;
    }

    public OutputItemStackWithPercentages getSecondaryOutput() {
        return this.secondaryOutput;
    }

    public class_1856 getInput() {
        return this.input;
    }

    public class_1799[] getMaxOutputCounts(boolean advanced) {
        class_1799[] generatedOutputs = new class_1799[]{this.output.output.method_46651(advanced ? this.output.percentagesAdvanced.length : this.output.percentages.length), this.secondaryOutput.output.method_46651(advanced ? this.secondaryOutput.percentagesAdvanced.length : this.secondaryOutput.percentages.length)};
        return generatedOutputs;
    }

    public class_1799[] generateOutputs(class_5819 randomSource, boolean advanced) {
        class_1799[] generatedOutputs = new class_1799[2];
        for (int i = 0; i < 2; ++i) {
            int count = 0;
            OutputItemStackWithPercentages output = i == 0 ? this.output : this.secondaryOutput;
            for (double percentage : advanced ? output.percentagesAdvanced : output.percentages) {
                if (!(randomSource.method_43058() <= percentage)) continue;
                ++count;
            }
            generatedOutputs[i] = output.output.method_46651(count);
        }
        return generatedOutputs;
    }

    public boolean method_8115(class_1263 container, class_1937 level) {
        if (level.method_8608()) {
            return false;
        }
        return this.input.method_8093(container.method_5438(0));
    }

    public class_1799 method_8116(class_1263 container, class_5455 registryManager) {
        return class_1799.field_8037;
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_1799 method_8110(class_5455 registryAccess) {
        return class_1799.field_8037;
    }

    public class_2371<class_1856> method_8117() {
        class_2371 ingredients = class_2371.method_37434((int)1);
        ingredients.add(0, (Object)this.input);
        return ingredients;
    }

    public class_1799 method_17447() {
        return new class_1799((class_1935)EPBlocks.PULVERIZER_ITEM);
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public boolean method_8118() {
        return true;
    }

    public class_1865<?> method_8119() {
        return Serializer.INSTANCE;
    }

    public class_3956<?> method_17716() {
        return Type.INSTANCE;
    }

    public record OutputItemStackWithPercentages(class_1799 output, double[] percentages, double[] percentagesAdvanced) {
        public OutputItemStackWithPercentages(class_1799 output, double percentage, double percentageAdvanced) {
            this(output, new double[]{percentage}, new double[]{percentageAdvanced});
        }

        public OutputItemStackWithPercentages(class_1799 output) {
            this(output, 1.0, 1.0);
        }
    }

    public static final class Serializer
    implements class_1865<PulverizerRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final class_2960 ID = EPAPI.id("pulverizer");

        private Serializer() {
        }

        public PulverizerRecipe read(class_2960 recipeID, JsonObject json) {
            class_1856 input = class_1856.method_52177((JsonElement)json.get("ingredient"));
            OutputItemStackWithPercentages[] outputs = new OutputItemStackWithPercentages[2];
            for (int i = 0; i < 2; ++i) {
                JsonObject outputJson = json.getAsJsonObject(i == 0 ? "output" : "secondaryOutput");
                class_1799 output = ItemStackUtils.fromJson(class_3518.method_15296((JsonObject)outputJson, (String)"output"));
                JsonArray percentagesJson = class_3518.method_15261((JsonObject)outputJson, (String)"percentages");
                double[] percentages = new double[percentagesJson.size()];
                boolean minimumAtLeastOneFlag = false;
                for (int j = 0; j < percentagesJson.size(); ++j) {
                    double value = percentagesJson.get(j).getAsDouble();
                    minimumAtLeastOneFlag |= (int)value >= 1;
                    percentages[j] = value;
                }
                if (i == 0 && !minimumAtLeastOneFlag) {
                    throw new JsonSyntaxException("The primary output must have a minimum count of at least 1 (At least one percentage value must be >= 1.0)");
                }
                JsonArray percentagesAdvancedJson = outputJson.has("percentagesAdvanced") ? class_3518.method_15261((JsonObject)outputJson, (String)"percentagesAdvanced") : percentagesJson;
                double[] percentagesAdvanced = new double[percentagesAdvancedJson.size()];
                minimumAtLeastOneFlag = false;
                for (int j = 0; j < percentagesAdvancedJson.size(); ++j) {
                    double value = percentagesAdvancedJson.get(j).getAsDouble();
                    minimumAtLeastOneFlag |= (int)value >= 1;
                    percentagesAdvanced[j] = value;
                }
                if (i == 0 && !minimumAtLeastOneFlag) {
                    throw new JsonSyntaxException("The primary output must have a minimum count of at least 1 (At least one percentage value must be >= 1.0)");
                }
                outputs[i] = new OutputItemStackWithPercentages(output, percentages, percentagesAdvanced);
                if (json.has("secondaryOutput")) continue;
                outputs[1] = new OutputItemStackWithPercentages(class_1799.field_8037, new double[0], new double[0]);
                break;
            }
            return new PulverizerRecipe(recipeID, outputs[0], outputs[1], input);
        }

        public PulverizerRecipe read(class_2960 recipeID, class_2540 buffer) {
            class_1856 input = class_1856.method_8086((class_2540)buffer);
            OutputItemStackWithPercentages[] outputs = new OutputItemStackWithPercentages[2];
            for (int i = 0; i < 2; ++i) {
                class_1799 output = buffer.method_10819();
                int percentageCount = buffer.readInt();
                double[] percentages = new double[percentageCount];
                for (int j = 0; j < percentageCount; ++j) {
                    percentages[j] = buffer.readDouble();
                }
                int percentageAdvancedCount = buffer.readInt();
                double[] percentagesAdvanced = new double[percentageAdvancedCount];
                for (int j = 0; j < percentageAdvancedCount; ++j) {
                    percentagesAdvanced[j] = buffer.readDouble();
                }
                outputs[i] = new OutputItemStackWithPercentages(output, percentages, percentagesAdvanced);
            }
            return new PulverizerRecipe(recipeID, outputs[0], outputs[1], input);
        }

        public void write(class_2540 buffer, PulverizerRecipe recipe) {
            recipe.input.method_8088(buffer);
            for (int i = 0; i < 2; ++i) {
                OutputItemStackWithPercentages output = i == 0 ? recipe.output : recipe.secondaryOutput;
                buffer.method_10793(output.output);
                buffer.writeInt(output.percentages.length);
                for (double percentage : output.percentages) {
                    buffer.writeDouble(percentage);
                }
                buffer.writeInt(output.percentagesAdvanced.length);
                for (double percentage : output.percentagesAdvanced) {
                    buffer.writeDouble(percentage);
                }
            }
        }
    }

    public static final class Type
    implements class_3956<PulverizerRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "pulverizer";

        private Type() {
        }
    }
}

