/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import me.jddev0.ep.fluid.FluidStack;
import me.jddev0.ep.util.FluidUtils;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3611;
import net.minecraft.class_7923;

public final class FluidStackUtils {
    private FluidStackUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FluidStack fromJson(JsonObject json) {
        try {
            class_2487 nbt;
            class_3611 fluid = (class_3611)class_7923.field_41173.method_10223(new class_2960(class_3518.method_15265((JsonObject)json, (String)"FluidName")));
            long milliBucketsAmount = class_3518.method_22449((JsonObject)json, (String)"Amount");
            long dropletsLeftOverAmount = json.has("LeftoverDropletsAmount") ? class_3518.method_22449((JsonObject)json, (String)"LeftoverDropletsAmount") : 0L;
            long dropletsAmount = FluidUtils.convertMilliBucketsToDroplets(milliBucketsAmount) + dropletsLeftOverAmount;
            if (json.has("Tag")) {
                JsonElement tagJson = json.get("Tag");
                if (tagJson.isJsonObject()) {
                    nbt = class_2522.method_10718((String)tagJson.toString());
                    return new FluidStack(fluid, nbt, dropletsAmount);
                } else {
                    if (!tagJson.isJsonPrimitive() || !tagJson.getAsJsonPrimitive().isString()) throw new JsonSyntaxException("Invalid FluidStack nbt data (Expected json object or string)");
                    nbt = class_2522.method_10718((String)tagJson.getAsString());
                }
                return new FluidStack(fluid, nbt, dropletsAmount);
            } else {
                nbt = null;
            }
            return new FluidStack(fluid, nbt, dropletsAmount);
        }
        catch (CommandSyntaxException e) {
            throw new JsonSyntaxException("Invalid FluidStack json representation", (Throwable)e);
        }
    }

    public static JsonElement toJson(FluidStack fluid) {
        JsonObject fluidJson = new JsonObject();
        fluidJson.addProperty("FluidName", class_7923.field_41173.method_10221((Object)fluid.getFluid()).toString());
        long dropletsAmount = fluid.getDropletsAmount();
        long milliBucketsAmount = FluidUtils.convertDropletsToMilliBuckets(dropletsAmount);
        long dropletsLeftOverAmount = dropletsAmount - FluidUtils.convertMilliBucketsToDroplets(milliBucketsAmount);
        fluidJson.addProperty("Amount", (Number)milliBucketsAmount);
        if (dropletsLeftOverAmount > 0L) {
            fluidJson.addProperty("LeftoverDropletsAmount", (Number)dropletsLeftOverAmount);
        }
        if (fluid.getFluidVariant().hasNbt()) {
            fluidJson.addProperty("Tag", fluid.getFluidVariant().getNbt().toString());
        }
        return fluidJson;
    }
}

