/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7923;

public final class ItemStackUtils {
    private ItemStackUtils() {
    }

    public static List<class_1799> combineItemStacks(List<class_1799> itemStacks) {
        ArrayList<class_1799> combinedItemStacks = new ArrayList<class_1799>();
        for (class_1799 itemStack : itemStacks) {
            boolean inserted = false;
            int amountLeft = itemStack.method_7947();
            for (class_1799 combinedItemStack : combinedItemStacks) {
                if (!class_1799.method_7984((class_1799)itemStack, (class_1799)combinedItemStack) || !class_1799.method_31577((class_1799)itemStack, (class_1799)combinedItemStack) || combinedItemStack.method_7914() <= combinedItemStack.method_7947()) continue;
                int amount = Math.min(amountLeft, combinedItemStack.method_7914() - combinedItemStack.method_7947());
                combinedItemStack.method_7933(amount);
                if ((amountLeft -= amount) != 0) continue;
                inserted = true;
                break;
            }
            if (inserted) continue;
            combinedItemStacks.add(itemStack.method_46651(amountLeft));
        }
        return combinedItemStacks;
    }

    public static class_1799 fromJson(JsonObject json) {
        try {
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(new class_2960(class_3518.method_15265((JsonObject)json, (String)"item")));
            byte count = json.has("count") ? class_3518.method_34929((JsonObject)json, (String)"count") : (byte)1;
            class_1799 itemStack = new class_1799((class_1935)item, (int)count);
            if (json.has("tag")) {
                JsonElement tagJson = json.get("tag");
                if (tagJson.isJsonObject()) {
                    class_2487 nbt = class_2522.method_10718((String)tagJson.toString());
                    itemStack.method_7980(nbt);
                } else if (tagJson.isJsonPrimitive() && tagJson.getAsJsonPrimitive().isString()) {
                    class_2487 nbt = class_2522.method_10718((String)tagJson.getAsString());
                    itemStack.method_7980(nbt);
                } else {
                    throw new JsonSyntaxException("Invalid ItemStack nbt data (Expected json object or string)");
                }
            }
            return itemStack;
        }
        catch (CommandSyntaxException e) {
            throw new JsonSyntaxException("Invalid ItemStack json representation", (Throwable)e);
        }
    }

    public static JsonElement toJson(class_1799 item) {
        JsonObject itemJson = new JsonObject();
        itemJson.addProperty("item", class_7923.field_41178.method_10221((Object)item.method_7909()).toString());
        if (item.method_7947() != 1) {
            itemJson.addProperty("count", (Number)item.method_7947());
        }
        if (item.method_7985()) {
            itemJson.addProperty("tag", item.method_7969().toString());
        }
        return itemJson;
    }
}

