/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.ArrayList;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.ConfigurableUpgradableInventoryEnergyStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergizedPowerEnergyStorage;
import me.jddev0.ep.energy.EnergizedPowerLimitingEnergyStorage;
import me.jddev0.ep.inventory.CombinedContainerData;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.inventory.data.BooleanValueContainerData;
import me.jddev0.ep.inventory.data.ComparatorModeValueContainerData;
import me.jddev0.ep.inventory.data.EnergyValueContainerData;
import me.jddev0.ep.inventory.data.ProgressValueContainerData;
import me.jddev0.ep.inventory.data.RedstoneModeValueContainerData;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.screen.CoalEngineMenu;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3913;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;

public class CoalEngineBlockEntity
extends ConfigurableUpgradableInventoryEnergyStorageBlockEntity<EnergizedPowerEnergyStorage, class_1277> {
    public static final double ENERGY_PRODUCTION_MULTIPLIER = ModConfigs.COMMON_COAL_ENGINE_ENERGY_PRODUCTION_MULTIPLIER.getValue();
    final InputOutputItemHandler itemHandlerSided;
    private int progress;
    private int maxProgress;
    private long energyProductionLeft;
    private boolean hasEnoughCapacityForProduction;
    private int timeoutOffState;

    public CoalEngineBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(EPBlockEntities.COAL_ENGINE_ENTITY, blockPos, blockState, "coal_engine", ModConfigs.COMMON_COAL_ENGINE_CAPACITY.getValue(), ModConfigs.COMMON_COAL_ENGINE_TRANSFER_RATE.getValue(), 1, UpgradeModuleModifier.ENERGY_CAPACITY);
        this.itemHandlerSided = new InputOutputItemHandler((class_1263)this.itemHandler, (i, stack) -> true, i -> {
            if (i != 0) {
                return false;
            }
            class_1799 item = this.itemHandler.method_5438(i.intValue());
            return this.field_11863 != null && this.field_11863.method_61269().method_61755(item) <= 0;
        });
        this.energyProductionLeft = -1L;
    }

    @Override
    protected EnergizedPowerEnergyStorage initEnergyStorage() {
        return new EnergizedPowerEnergyStorage(this.baseEnergyCapacity, this.baseEnergyCapacity, this.baseEnergyCapacity){

            @Override
            public long getCapacity() {
                return Math.max(1L, (long)Math.ceil((double)this.capacity * CoalEngineBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CAPACITY)));
            }

            protected void onFinalCommit() {
                CoalEngineBlockEntity.this.method_5431();
                CoalEngineBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Override
    protected EnergizedPowerLimitingEnergyStorage initLimitingEnergyStorage() {
        return new EnergizedPowerLimitingEnergyStorage(this.energyStorage, 0L, this.baseEnergyTransferRate){

            @Override
            public long getMaxExtract() {
                return Math.max(1L, (long)Math.ceil((double)this.maxExtract * CoalEngineBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_TRANSFER_RATE)));
            }
        };
    }

    @Override
    protected class_1277 initInventoryStorage() {
        return new class_1277(this.slotCount){

            public boolean method_5437(int slot, class_1799 stack) {
                if (slot == 0) {
                    return CoalEngineBlockEntity.this.field_11863.method_61269().method_61755(stack) > 0;
                }
                return super.method_5437(slot, stack);
            }

            public void method_5431() {
                super.method_5431();
                CoalEngineBlockEntity.this.method_5431();
            }
        };
    }

    @Override
    protected class_3913 initContainerData() {
        return new CombinedContainerData(new ProgressValueContainerData(() -> this.progress, value -> {
            this.progress = value;
        }), new ProgressValueContainerData(() -> this.maxProgress, value -> {
            this.maxProgress = value;
        }), new EnergyValueContainerData(() -> this.maxProgress > 0 || CoalEngineBlockEntity.hasRecipe(this) ? this.getEnergyProductionPerTick() : -1L, value -> {}), new EnergyValueContainerData(() -> this.energyProductionLeft, value -> {}), new BooleanValueContainerData(() -> this.hasEnoughCapacityForProduction, value -> {}), new RedstoneModeValueContainerData(() -> this.redstoneMode, value -> {
            this.redstoneMode = value;
        }), new ComparatorModeValueContainerData(() -> this.comparatorMode, value -> {
            this.comparatorMode = value;
        }));
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        this.syncEnergyToPlayer(player);
        return new CoalEngineMenu(id, this, inventory, (class_1263)this.itemHandler, this.upgradeModuleInventory, this.data);
    }

    @Override
    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        view.method_71465("recipe.progress", this.progress);
        view.method_71465("recipe.max_progress", this.maxProgress);
        view.method_71466("recipe.energy_production_left", this.energyProductionLeft);
    }

    @Override
    protected void method_11014(class_11368 view) {
        super.method_11014(view);
        this.progress = view.method_71424("recipe.progress", 0);
        this.maxProgress = view.method_71424("recipe.max_progress", 0);
        this.energyProductionLeft = view.method_71425("recipe.energy_production_left", 0L);
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, CoalEngineBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        if (blockEntity.redstoneMode.isActive((Boolean)state.method_11654((class_2769)class_2741.field_12484))) {
            CoalEngineBlockEntity.tickRecipe(level, blockPos, state, blockEntity);
        }
        CoalEngineBlockEntity.transferEnergy(level, blockPos, state, blockEntity);
    }

    protected final long getEnergyProductionPerTick() {
        long energyProductionPerTick = (long)Math.ceil((double)this.energyProductionLeft / (double)(this.maxProgress - this.progress));
        if (this.progress == this.maxProgress - 1) {
            energyProductionPerTick = this.energyProductionLeft;
        }
        return energyProductionPerTick;
    }

    private static void tickRecipe(class_1937 level, class_2338 blockPos, class_2680 state, CoalEngineBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        if (blockEntity.timeoutOffState > 0) {
            --blockEntity.timeoutOffState;
            if (blockEntity.timeoutOffState == 0 && level.method_8320(blockPos).method_28498((class_2769)class_2741.field_12548) && ((Boolean)level.method_8320(blockPos).method_11654((class_2769)class_2741.field_12548)).booleanValue()) {
                level.method_8652(blockPos, (class_2680)state.method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(false)), 3);
            }
        }
        if (blockEntity.maxProgress > 0 || CoalEngineBlockEntity.hasRecipe(blockEntity)) {
            long energyProductionPerTick;
            class_1799 item = blockEntity.itemHandler.method_5438(0);
            long energyProduction = level.method_61269().method_61755(item);
            energyProduction = (long)((double)energyProduction * ENERGY_PRODUCTION_MULTIPLIER);
            if (blockEntity.progress == 0) {
                blockEntity.energyProductionLeft = energyProduction;
            }
            if (blockEntity.maxProgress == 0) {
                blockEntity.maxProgress = energyProduction / 100L <= blockEntity.limitingEnergyStorage.getMaxExtract() ? 100 : (int)Math.ceil((double)energyProduction / (double)blockEntity.limitingEnergyStorage.getMaxExtract());
            }
            if ((energyProductionPerTick = blockEntity.getEnergyProductionPerTick()) <= ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).getCapacity() - ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).getAmount()) {
                if (blockEntity.progress == 0) {
                    if (!item.getRecipeRemainder().method_7960()) {
                        blockEntity.itemHandler.method_5447(0, item.getRecipeRemainder());
                    } else {
                        blockEntity.itemHandler.method_5434(0, 1);
                    }
                }
                blockEntity.hasEnoughCapacityForProduction = true;
                blockEntity.timeoutOffState = 0;
                if (level.method_8320(blockPos).method_28498((class_2769)class_2741.field_12548) && !((Boolean)level.method_8320(blockPos).method_11654((class_2769)class_2741.field_12548)).booleanValue()) {
                    level.method_8652(blockPos, (class_2680)state.method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(true)), 3);
                }
                if (blockEntity.progress < 0 || blockEntity.maxProgress < 0 || blockEntity.energyProductionLeft < 0L || energyProductionPerTick < 0L) {
                    blockEntity.resetProgress(blockPos, state);
                    CoalEngineBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
                    return;
                }
                try (Transaction transaction = Transaction.openOuter();){
                    ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).insert(energyProductionPerTick, (TransactionContext)transaction);
                    transaction.commit();
                }
                blockEntity.energyProductionLeft -= energyProductionPerTick;
                ++blockEntity.progress;
                if (blockEntity.progress >= blockEntity.maxProgress) {
                    blockEntity.resetProgress(blockPos, state);
                }
                CoalEngineBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
            } else {
                blockEntity.hasEnoughCapacityForProduction = false;
                if (blockEntity.timeoutOffState == 0) {
                    blockEntity.timeoutOffState = ModConfigs.COMMON_OFF_STATE_TIMEOUT.getValue();
                }
                CoalEngineBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
            }
        } else {
            blockEntity.resetProgress(blockPos, state);
            if (blockEntity.timeoutOffState == 0) {
                blockEntity.timeoutOffState = ModConfigs.COMMON_OFF_STATE_TIMEOUT.getValue();
            }
            CoalEngineBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
        }
    }

    private static void transferEnergy(class_1937 level, class_2338 blockPos, class_2680 state, CoalEngineBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        ArrayList<EnergyStorage> consumerItems = new ArrayList<EnergyStorage>();
        ArrayList<Long> consumerEnergyValues = new ArrayList<Long>();
        long consumptionSum = 0L;
        for (class_2350 direction : class_2350.values()) {
            EnergyStorage limitingEnergyStorage;
            class_2338 testPos = blockPos.method_10093(direction);
            class_2586 testBlockEntity = level.method_8321(testPos);
            if (testBlockEntity == null || (limitingEnergyStorage = (EnergyStorage)EnergyStorage.SIDED.find(level, testPos, (Object)direction.method_10153())) == null || !limitingEnergyStorage.supportsInsertion()) continue;
            try (Transaction transaction = Transaction.openOuter();){
                long received = limitingEnergyStorage.insert(Math.min(blockEntity.limitingEnergyStorage.getMaxExtract(), ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).getAmount()), (TransactionContext)transaction);
                if (received <= 0L) continue;
                consumptionSum += received;
                consumerItems.add(limitingEnergyStorage);
                consumerEnergyValues.add(received);
            }
        }
        ArrayList<Long> consumerEnergyDistributed = new ArrayList<Long>();
        for (int i = 0; i < consumerItems.size(); ++i) {
            consumerEnergyDistributed.add(0L);
        }
        long consumptionLeft = Math.min(blockEntity.limitingEnergyStorage.getMaxExtract(), Math.min(((EnergizedPowerEnergyStorage)blockEntity.energyStorage).getAmount(), consumptionSum));
        try (Transaction transaction = Transaction.openOuter();){
            ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).extract(consumptionLeft, (TransactionContext)transaction);
            transaction.commit();
        }
        int divisor = consumerItems.size();
        block18: while (consumptionLeft > 0L) {
            long consumptionPerConsumer = consumptionLeft / (long)divisor;
            if (consumptionPerConsumer == 0L) {
                divisor = Math.max(1, divisor - 1);
                consumptionPerConsumer = consumptionLeft / (long)divisor;
            }
            for (int i = 0; i < consumerEnergyValues.size(); ++i) {
                long consumptionDistributed = (Long)consumerEnergyDistributed.get(i);
                long consumptionOfConsumerLeft = (Long)consumerEnergyValues.get(i) - consumptionDistributed;
                long consumptionDistributedNew = Math.min(consumptionOfConsumerLeft, Math.min(consumptionPerConsumer, consumptionLeft));
                consumerEnergyDistributed.set(i, consumptionDistributed + consumptionDistributedNew);
                if ((consumptionLeft -= consumptionDistributedNew) == 0L) break block18;
            }
        }
        for (int i = 0; i < consumerItems.size(); ++i) {
            long energy = (Long)consumerEnergyDistributed.get(i);
            if (energy <= 0L) continue;
            try (Transaction transaction = Transaction.openOuter();){
                ((EnergyStorage)consumerItems.get(i)).insert(energy, (TransactionContext)transaction);
                transaction.commit();
                continue;
            }
        }
    }

    private void resetProgress(class_2338 blockPos, class_2680 state) {
        this.progress = 0;
        this.maxProgress = 0;
        this.energyProductionLeft = -1L;
        this.hasEnoughCapacityForProduction = false;
    }

    private static boolean hasRecipe(CoalEngineBlockEntity blockEntity) {
        class_1799 item = blockEntity.itemHandler.method_5438(0);
        if (blockEntity.field_11863 == null || blockEntity.field_11863.method_61269().method_61755(item) <= 0) {
            return false;
        }
        return item.getRecipeRemainder().method_7960() || item.method_7947() == 1;
    }
}

