/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.Iterator;
import me.jddev0.ep.block.FluidFillerBlock;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.ConfigurableUpgradableInventoryFluidEnergyStorageBlockEntity;
import me.jddev0.ep.block.entity.base.FluidStorageSingleTankMethods;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergizedPowerEnergyStorage;
import me.jddev0.ep.energy.EnergizedPowerLimitingEnergyStorage;
import me.jddev0.ep.fluid.SimpleFluidStorage;
import me.jddev0.ep.inventory.CombinedContainerData;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.inventory.data.ComparatorModeValueContainerData;
import me.jddev0.ep.inventory.data.FluidValueContainerData;
import me.jddev0.ep.inventory.data.RedstoneModeValueContainerData;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.screen.FluidFillerMenu;
import me.jddev0.ep.util.FluidUtils;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3913;
import org.jetbrains.annotations.Nullable;

public class FluidFillerBlockEntity
extends ConfigurableUpgradableInventoryFluidEnergyStorageBlockEntity<EnergizedPowerEnergyStorage, class_1277, SimpleFluidStorage> {
    public static final long MAX_FLUID_FILLING_PER_TICK = ModConfigs.COMMON_FLUID_FILLER_FLUID_ITEM_TRANSFER_RATE.getValue();
    public static final long ENERGY_USAGE_PER_TICK = ModConfigs.COMMON_FLUID_FILLER_ENERGY_CONSUMPTION_PER_TICK.getValue();
    final InputOutputItemHandler itemHandlerSided;
    private long fluidFillingLeft;
    private long fluidFillingSumPending;
    private boolean forceAllowStackUpdateFlag;

    public FluidFillerBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(EPBlockEntities.FLUID_FILLER_ENTITY, blockPos, blockState, "fluid_filler", ModConfigs.COMMON_FLUID_FILLER_CAPACITY.getValue(), ModConfigs.COMMON_FLUID_FILLER_TRANSFER_RATE.getValue(), 1, FluidStorageSingleTankMethods.INSTANCE, FluidUtils.convertMilliBucketsToDroplets(ModConfigs.COMMON_FLUID_FILLER_FLUID_TANK_CAPACITY.getValue() * 1000L), UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_CAPACITY);
        this.itemHandlerSided = new InputOutputItemHandler((class_1263)this.itemHandler, (i, stack) -> true, i -> {
            if (i != 0) {
                return false;
            }
            class_1799 itemStack = this.itemHandler.method_5438(i.intValue());
            if (ContainerItemContext.withConstant((class_1799)itemStack).find(FluidStorage.ITEM) == null) {
                return true;
            }
            Storage fluidStorage = (Storage)FluidStorage.ITEM.find(itemStack, (Object)ContainerItemContext.ofSingleSlot((SingleSlotStorage)((SingleSlotStorage)InventoryStorage.of((class_1263)this.itemHandler, null).getSlots().get((int)i))));
            if (fluidStorage == null) {
                return true;
            }
            if (!fluidStorage.supportsInsertion()) {
                return true;
            }
            boolean isFluidValid = false;
            if (!((SimpleFluidStorage)this.fluidStorage).isEmpty()) {
                this.forceAllowStackUpdateFlag = true;
                try (Transaction transaction = Transaction.openNested((TransactionContext)Transaction.getCurrentUnsafe());){
                    long inserted = fluidStorage.insert((Object)((FluidVariant)((SimpleFluidStorage)this.fluidStorage).getResource()), Long.MAX_VALUE, (TransactionContext)transaction);
                    isFluidValid = inserted > 0L;
                    transaction.abort();
                }
                finally {
                    this.forceAllowStackUpdateFlag = false;
                }
            }
            for (StorageView fluidView : fluidStorage) {
                FluidVariant fluidVariant = (FluidVariant)fluidView.getResource();
                if (fluidView.getCapacity() <= fluidView.getAmount() || !((SimpleFluidStorage)this.fluidStorage).isEmpty() && (!fluidVariant.isBlank() || !isFluidValid) && !fluidVariant.equals((Object)((SimpleFluidStorage)this.fluidStorage).getResource())) continue;
                return false;
            }
            return true;
        });
        this.fluidFillingLeft = -1L;
        this.fluidFillingSumPending = 0L;
        this.forceAllowStackUpdateFlag = false;
    }

    @Override
    protected EnergizedPowerEnergyStorage initEnergyStorage() {
        return new EnergizedPowerEnergyStorage(this.baseEnergyCapacity, this.baseEnergyCapacity, this.baseEnergyCapacity){

            @Override
            public long getCapacity() {
                return Math.max(1L, (long)Math.ceil((double)this.capacity * FluidFillerBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CAPACITY)));
            }

            protected void onFinalCommit() {
                FluidFillerBlockEntity.this.method_5431();
                FluidFillerBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Override
    protected EnergizedPowerLimitingEnergyStorage initLimitingEnergyStorage() {
        return new EnergizedPowerLimitingEnergyStorage(this.energyStorage, this.baseEnergyTransferRate, 0L){

            @Override
            public long getMaxInsert() {
                return Math.max(1L, (long)Math.ceil((double)this.maxInsert * FluidFillerBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_TRANSFER_RATE)));
            }
        };
    }

    @Override
    protected class_1277 initInventoryStorage() {
        return new class_1277(this.slotCount){

            public int method_5444() {
                return 1;
            }

            public boolean method_5437(int slot, class_1799 stack) {
                if (slot == 0) {
                    return ContainerItemContext.withConstant((class_1799)stack).find(FluidStorage.ITEM) != null;
                }
                return super.method_5437(slot, stack);
            }

            public void method_5447(int slot, class_1799 stack) {
                if (slot == 0) {
                    class_1799 itemStack = this.method_5438(slot);
                    if (!(FluidFillerBlockEntity.this.forceAllowStackUpdateFlag || stack.method_7960() || itemStack.method_7960() || class_1799.method_7984((class_1799)stack, (class_1799)itemStack) && (class_1799.method_31577((class_1799)stack, (class_1799)itemStack) || ContainerItemContext.withConstant((class_1799)stack).find(FluidStorage.ITEM) != null && ContainerItemContext.withConstant((class_1799)itemStack).find(FluidStorage.ITEM) != null))) {
                        FluidFillerBlockEntity.this.resetProgress();
                    }
                }
                super.method_5447(slot, stack);
            }

            public void method_5431() {
                super.method_5431();
                FluidFillerBlockEntity.this.method_5431();
            }
        };
    }

    @Override
    protected SimpleFluidStorage initFluidStorage() {
        return new SimpleFluidStorage(this.baseTankCapacity){

            protected void onFinalCommit() {
                FluidFillerBlockEntity.this.method_5431();
                FluidFillerBlockEntity.this.syncFluidToPlayers(32);
            }
        };
    }

    @Override
    protected class_3913 initContainerData() {
        return new CombinedContainerData(new FluidValueContainerData(() -> this.fluidFillingLeft, value -> {}), new FluidValueContainerData(() -> this.fluidFillingSumPending, value -> {}), new RedstoneModeValueContainerData(() -> this.redstoneMode, value -> {
            this.redstoneMode = value;
        }), new ComparatorModeValueContainerData(() -> this.comparatorMode, value -> {
            this.comparatorMode = value;
        }));
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        this.syncEnergyToPlayer(player);
        this.syncFluidToPlayer(player);
        return new FluidFillerMenu(id, this, inventory, (class_1263)this.itemHandler, this.upgradeModuleInventory, this.data);
    }

    @Override
    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        FluidUtils.writeFluidAmountInMilliBucketsWithLeftover(this.fluidFillingLeft, "recipe.fluid_filling_left", "recipe.fluid_filling_left_leftover_droplets", view);
        FluidUtils.writeFluidAmountInMilliBucketsWithLeftover(this.fluidFillingSumPending, "recipe.fluid_filling_sum_pending", "recipe.fluid_filling_sum_pending_leftover_droplets", view);
    }

    @Override
    protected void method_11014(class_11368 view) {
        super.method_11014(view);
        this.fluidFillingLeft = FluidUtils.readFluidAmountInMilliBucketsWithLeftover("recipe.fluid_filling_left", "recipe.fluid_filling_left_leftover_droplets", view);
        this.fluidFillingSumPending = FluidUtils.readFluidAmountInMilliBucketsWithLeftover("recipe.fluid_filling_sum_pending", "recipe.fluid_filling_sum_pending_leftover_droplets", view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, FluidFillerBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        if (!blockEntity.redstoneMode.isActive((Boolean)state.method_11654((class_2769)FluidFillerBlock.POWERED))) {
            return;
        }
        if (blockEntity.hasRecipe()) {
            Iterator transaction;
            class_1799 itemStack = blockEntity.itemHandler.method_5438(0);
            long fluidFillingSum = 0L;
            long fluidFillingLeftSum = 0L;
            if (((SimpleFluidStorage)blockEntity.fluidStorage).getAmount() - blockEntity.fluidFillingSumPending <= 0L) {
                return;
            }
            long energyConsumptionPerTick = Math.max(1L, (long)Math.ceil((double)ENERGY_USAGE_PER_TICK * blockEntity.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CONSUMPTION)));
            if (((EnergizedPowerEnergyStorage)blockEntity.energyStorage).getAmount() < energyConsumptionPerTick) {
                return;
            }
            if (ContainerItemContext.withConstant((class_1799)itemStack).find(FluidStorage.ITEM) == null) {
                return;
            }
            Storage fluidStorage = (Storage)FluidStorage.ITEM.find(itemStack, (Object)ContainerItemContext.ofSingleSlot((SingleSlotStorage)((SingleSlotStorage)InventoryStorage.of((class_1263)blockEntity.itemHandler, null).getSlots().get(0))));
            if (fluidStorage == null) {
                return;
            }
            boolean isFluidValid = false;
            if (!((SimpleFluidStorage)blockEntity.fluidStorage).isEmpty()) {
                blockEntity.forceAllowStackUpdateFlag = true;
                try {
                    transaction = Transaction.openOuter();
                    try {
                        long inserted = fluidStorage.insert((Object)((FluidVariant)((SimpleFluidStorage)blockEntity.fluidStorage).getResource()), Long.MAX_VALUE, (TransactionContext)transaction);
                        isFluidValid = inserted > 0L;
                        transaction.abort();
                    }
                    finally {
                        if (transaction != null) {
                            transaction.close();
                        }
                    }
                }
                finally {
                    blockEntity.forceAllowStackUpdateFlag = false;
                }
            }
            for (StorageView fluidView : fluidStorage) {
                FluidVariant fluidVariant = (FluidVariant)fluidView.getResource();
                if (fluidView.getCapacity() <= fluidView.getAmount() || !((SimpleFluidStorage)blockEntity.fluidStorage).isEmpty() && (!fluidVariant.isBlank() || !isFluidValid) && !fluidVariant.equals((Object)((SimpleFluidStorage)blockEntity.fluidStorage).getResource())) continue;
                fluidFillingSum += Math.min(((SimpleFluidStorage)blockEntity.fluidStorage).getAmount() - blockEntity.fluidFillingSumPending - fluidFillingSum, Math.min(fluidView.getCapacity() - fluidView.getAmount(), FluidUtils.convertMilliBucketsToDroplets(MAX_FLUID_FILLING_PER_TICK) - fluidFillingSum));
                fluidFillingLeftSum += fluidView.getCapacity() - fluidView.getAmount();
            }
            if (fluidFillingSum == 0L) {
                return;
            }
            blockEntity.fluidFillingLeft = fluidFillingLeftSum;
            blockEntity.fluidFillingSumPending += fluidFillingSum;
            blockEntity.forceAllowStackUpdateFlag = true;
            try {
                transaction = Transaction.openOuter();
                try {
                    ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).extract(energyConsumptionPerTick, (TransactionContext)transaction);
                    long fluidSumFillable = Math.min(((SimpleFluidStorage)blockEntity.fluidStorage).getAmount(), blockEntity.fluidFillingSumPending);
                    FluidVariant fluidVariantToFill = (FluidVariant)((SimpleFluidStorage)blockEntity.fluidStorage).getResource();
                    long fluidSumFilled = fluidStorage.insert((Object)fluidVariantToFill, fluidSumFillable, (TransactionContext)transaction);
                    if (fluidSumFilled > 0L) {
                        ((SimpleFluidStorage)blockEntity.fluidStorage).extract((TransferVariant)fluidVariantToFill, fluidSumFilled, (TransactionContext)transaction);
                        blockEntity.fluidFillingSumPending -= fluidSumFilled;
                        blockEntity.fluidFillingLeft = fluidFillingLeftSum - fluidSumFilled;
                    }
                    transaction.commit();
                }
                finally {
                    if (transaction != null) {
                        transaction.close();
                    }
                }
            }
            finally {
                blockEntity.forceAllowStackUpdateFlag = false;
            }
            if (blockEntity.fluidFillingLeft <= 0L) {
                blockEntity.resetProgress();
            }
            FluidFillerBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
        } else {
            blockEntity.resetProgress();
            FluidFillerBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
        }
    }

    private void resetProgress() {
        this.fluidFillingLeft = -1L;
        this.fluidFillingSumPending = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasRecipe() {
        class_1799 itemStack = this.itemHandler.method_5438(0);
        if (ContainerItemContext.withConstant((class_1799)itemStack).find(FluidStorage.ITEM) != null) {
            Storage fluidStorage = (Storage)FluidStorage.ITEM.find(itemStack, (Object)ContainerItemContext.ofSingleSlot((SingleSlotStorage)((SingleSlotStorage)InventoryStorage.of((class_1263)this.itemHandler, null).getSlots().get(0))));
            if (fluidStorage == null) {
                return false;
            }
            boolean isFluidValid = false;
            if (!((SimpleFluidStorage)this.fluidStorage).isEmpty()) {
                this.forceAllowStackUpdateFlag = true;
                try (Transaction transaction = Transaction.openOuter();){
                    long inserted = fluidStorage.insert((Object)((FluidVariant)((SimpleFluidStorage)this.fluidStorage).getResource()), Long.MAX_VALUE, (TransactionContext)transaction);
                    isFluidValid = inserted > 0L;
                    transaction.abort();
                }
                finally {
                    this.forceAllowStackUpdateFlag = false;
                }
            }
            for (StorageView fluidView : fluidStorage) {
                FluidVariant fluidVariant = (FluidVariant)fluidView.getResource();
                if (fluidView.getCapacity() <= fluidView.getAmount() || !((SimpleFluidStorage)this.fluidStorage).isEmpty() && (!fluidVariant.isBlank() || !isFluidValid) && !fluidVariant.equals((Object)((SimpleFluidStorage)this.fluidStorage).getResource())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void updateUpgradeModules() {
        this.resetProgress();
        super.updateUpgradeModules();
    }
}

