/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import com.mojang.serialization.Codec;
import java.util.Locale;
import java.util.Optional;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.FluidStorageSingleTankMethods;
import me.jddev0.ep.block.entity.base.SimpleRecipeFluidMachineBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.fluid.FluidStack;
import me.jddev0.ep.fluid.SimpleFluidStorage;
import me.jddev0.ep.inventory.CombinedContainerData;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.inventory.data.BooleanValueContainerData;
import me.jddev0.ep.inventory.data.ComparatorModeValueContainerData;
import me.jddev0.ep.inventory.data.EnergyValueContainerData;
import me.jddev0.ep.inventory.data.ProgressValueContainerData;
import me.jddev0.ep.inventory.data.RedstoneModeValueContainerData;
import me.jddev0.ep.inventory.data.ShortValueContainerData;
import me.jddev0.ep.machine.CheckboxUpdate;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.recipe.ContainerRecipeInputWrapper;
import me.jddev0.ep.recipe.EPRecipes;
import me.jddev0.ep.recipe.FluidTransposerRecipe;
import me.jddev0.ep.screen.FluidTransposerMenu;
import me.jddev0.ep.util.FluidUtils;
import me.jddev0.ep.util.InventoryUtils;
import me.jddev0.ep.util.RecipeUtils;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3542;
import net.minecraft.class_3913;
import net.minecraft.class_5699;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.jetbrains.annotations.NotNull;

public class FluidTransposerBlockEntity
extends SimpleRecipeFluidMachineBlockEntity<SimpleFluidStorage, class_9695, FluidTransposerRecipe>
implements CheckboxUpdate {
    public static final long TANK_CAPACITY = FluidUtils.convertMilliBucketsToDroplets(1000L * ModConfigs.COMMON_FLUID_TRANSPOSER_TANK_CAPACITY.getValue());
    final InputOutputItemHandler itemHandlerSided;
    private Mode mode;

    public FluidTransposerBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(EPBlockEntities.FLUID_TRANSPOSER_ENTITY, blockPos, blockState, "fluid_transposer", FluidTransposerMenu::new, 2, EPRecipes.FLUID_TRANSPOSER_TYPE, ModConfigs.COMMON_FLUID_TRANSPOSER_RECIPE_DURATION.getValue(), (long)ModConfigs.COMMON_FLUID_TRANSPOSER_CAPACITY.getValue(), ModConfigs.COMMON_FLUID_TRANSPOSER_TRANSFER_RATE.getValue(), (long)ModConfigs.COMMON_FLUID_TRANSPOSER_ENERGY_CONSUMPTION_PER_TICK.getValue(), FluidStorageSingleTankMethods.INSTANCE, TANK_CAPACITY, UpgradeModuleModifier.SPEED, UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_CAPACITY);
        this.itemHandlerSided = new InputOutputItemHandler((class_1263)this.itemHandler, (i, stack) -> i == 0, i -> i == 1);
        this.mode = Mode.EMPTYING;
    }

    @Override
    protected class_3913 initContainerData() {
        return new CombinedContainerData(new ProgressValueContainerData(() -> this.progress, value -> {
            this.progress = value;
        }), new ProgressValueContainerData(() -> this.maxProgress, value -> {
            this.maxProgress = value;
        }), new EnergyValueContainerData(() -> this.hasWork() ? this.getCurrentWorkData().map(x$0 -> this.getEnergyConsumptionFor(x$0)).orElse(-1L) : -1L, value -> {}), new EnergyValueContainerData(() -> this.energyConsumptionLeft, value -> {}), new BooleanValueContainerData(() -> this.hasEnoughEnergy, value -> {}), new ShortValueContainerData(() -> (short)this.mode.ordinal(), value -> {
            this.mode = Mode.fromIndex(value.shortValue());
        }), new RedstoneModeValueContainerData(() -> this.redstoneMode, value -> {
            this.redstoneMode = value;
        }), new ComparatorModeValueContainerData(() -> this.comparatorMode, value -> {
            this.comparatorMode = value;
        }));
    }

    @Override
    protected class_1277 initInventoryStorage() {
        return new class_1277(this.slotCount){

            public void method_5431() {
                super.method_5431();
                FluidTransposerBlockEntity.this.method_5431();
            }

            public boolean method_5437(int slot, class_1799 stack) {
                return switch (slot) {
                    case 0 -> {
                        class_1937 var4_3 = FluidTransposerBlockEntity.this.field_11863;
                        if (var4_3 instanceof class_3218) {
                            class_3218 serverWorld = (class_3218)var4_3;
                            yield RecipeUtils.isIngredientOfAny(serverWorld, FluidTransposerBlockEntity.this.recipeType, stack);
                        }
                        yield RecipeUtils.isIngredientOfAny(FluidTransposerBlockEntity.this.ingredientsOfRecipes, stack);
                    }
                    case 1 -> false;
                    default -> super.method_5437(slot, stack);
                };
            }

            public void method_5447(int slot, class_1799 stack) {
                if (slot == 0) {
                    class_1799 itemStack = this.method_5438(slot);
                    if (!(FluidTransposerBlockEntity.this.field_11863 == null || stack.method_7960() || itemStack.method_7960() || class_1799.method_31577((class_1799)stack, (class_1799)itemStack))) {
                        FluidTransposerBlockEntity.this.resetProgress();
                    }
                }
                super.method_5447(slot, stack);
            }
        };
    }

    @Override
    protected SimpleFluidStorage initFluidStorage() {
        return new SimpleFluidStorage(this.baseTankCapacity){

            protected void onFinalCommit() {
                FluidTransposerBlockEntity.this.method_5431();
                FluidTransposerBlockEntity.this.syncFluidToPlayers(32);
            }

            private boolean isFluidValid(FluidVariant variant) {
                class_3218 serverWorld;
                if (FluidTransposerBlockEntity.this.field_11863 == null) {
                    return false;
                }
                class_1937 class_19372 = FluidTransposerBlockEntity.this.field_11863;
                return !(class_19372 instanceof class_3218) || RecipeUtils.getAllRecipesFor(serverWorld = (class_3218)class_19372, FluidTransposerBlockEntity.this.recipeType).stream().map(class_8786::comp_1933).map(FluidTransposerRecipe::getFluid).anyMatch(fluidStack -> variant.isOf((Object)fluidStack.getFluid()) && variant.componentsMatch(fluidStack.getFluidVariant().getComponents()));
            }

            protected boolean canInsert(FluidVariant variant) {
                return this.isFluidValid(variant);
            }

            protected boolean canExtract(FluidVariant variant) {
                return this.isFluidValid(variant);
            }
        };
    }

    @Override
    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        view.method_71465("mode", this.mode.ordinal());
    }

    @Override
    protected void method_11014(class_11368 view) {
        super.method_11014(view);
        this.mode = Mode.fromIndex(view.method_71424("mode", 0));
    }

    @Override
    protected Optional<class_8786<FluidTransposerRecipe>> getRecipeFor(class_1277 inventory) {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return Optional.empty();
        }
        class_3218 serverWorld = (class_3218)class_19372;
        return RecipeUtils.getAllRecipesFor(serverWorld, this.recipeType).stream().filter(recipe -> ((FluidTransposerRecipe)recipe.comp_1933()).getMode() == this.mode).filter(recipe -> ((FluidTransposerRecipe)recipe.comp_1933()).method_8115(this.getRecipeInput(inventory), this.field_11863)).filter(recipe -> this.mode == Mode.EMPTYING && ((SimpleFluidStorage)this.fluidStorage).isEmpty() || ((FluidTransposerRecipe)recipe.comp_1933()).getFluid().getFluidVariant().isOf((Object)((SimpleFluidStorage)this.fluidStorage).getFluid().getFluid()) && ((FluidTransposerRecipe)recipe.comp_1933()).getFluid().getFluidVariant().componentsMatch(((SimpleFluidStorage)this.fluidStorage).getFluid().getFluidVariant().getComponents())).findFirst();
    }

    @Override
    protected class_9695 getRecipeInput(class_1277 inventory) {
        return new ContainerRecipeInputWrapper((class_1263)inventory);
    }

    @Override
    protected void craftItem(class_8786<FluidTransposerRecipe> recipe) {
        if (this.field_11863 == null || !this.hasRecipe()) {
            return;
        }
        FluidStack fluid = new FluidStack(((FluidTransposerRecipe)recipe.comp_1933()).getFluid().getFluidVariant().getFluid(), ((FluidTransposerRecipe)recipe.comp_1933()).getFluid().getFluidVariant().getComponents(), ((FluidTransposerRecipe)recipe.comp_1933()).getFluid().getDropletsAmount());
        if (this.mode == Mode.EMPTYING) {
            try (Transaction transaction = Transaction.openOuter();){
                ((SimpleFluidStorage)this.fluidStorage).insert((TransferVariant)fluid.getFluidVariant(), fluid.getDropletsAmount(), (TransactionContext)transaction);
                transaction.commit();
            }
        }
        try (Transaction transaction = Transaction.openOuter();){
            ((SimpleFluidStorage)this.fluidStorage).extract((TransferVariant)fluid.getFluidVariant(), fluid.getDropletsAmount(), (TransactionContext)transaction);
            transaction.commit();
        }
        this.itemHandler.method_5434(0, 1);
        this.itemHandler.method_5447(1, ((FluidTransposerRecipe)recipe.comp_1933()).method_8116(null, (class_7225.class_7874)this.field_11863.method_30349()).method_46651(this.itemHandler.method_5438(1).method_7947() + ((FluidTransposerRecipe)recipe.comp_1933()).method_8116(null, (class_7225.class_7874)this.field_11863.method_30349()).method_7947()));
        this.resetProgress();
    }

    @Override
    protected boolean canCraftRecipe(class_1277 inventory, class_8786<FluidTransposerRecipe> recipe) {
        long fluidAmountInTank = ((SimpleFluidStorage)this.fluidStorage).getFluid().getDropletsAmount();
        long fluidAmountInRecipe = ((FluidTransposerRecipe)recipe.comp_1933()).getFluid().getDropletsAmount();
        return this.field_11863 != null && (this.mode == Mode.EMPTYING ? ((SimpleFluidStorage)this.fluidStorage).getCapacity() - fluidAmountInTank : fluidAmountInTank) >= fluidAmountInRecipe && (this.mode != Mode.EMPTYING || ((SimpleFluidStorage)this.fluidStorage).isEmpty() || ((FluidVariant)((SimpleFluidStorage)this.fluidStorage).getResource()).isOf((Object)((FluidTransposerRecipe)recipe.comp_1933()).getFluid().getFluid()) && ((FluidVariant)((SimpleFluidStorage)this.fluidStorage).getResource()).componentsMatch(((FluidTransposerRecipe)recipe.comp_1933()).getFluid().getFluidVariant().getComponents())) && InventoryUtils.canInsertItemIntoSlot((class_1263)inventory, 1, ((FluidTransposerRecipe)recipe.comp_1933()).method_8116(null, (class_7225.class_7874)this.field_11863.method_30349()));
    }

    public void setMode(boolean isFillingMode) {
        this.mode = isFillingMode ? Mode.FILLING : Mode.EMPTYING;
        this.resetProgress();
        FluidTransposerBlockEntity.method_31663((class_1937)this.field_11863, (class_2338)this.method_11016(), (class_2680)this.method_11010());
    }

    @Override
    public void setCheckbox(int checkboxId, boolean checked) {
        switch (checkboxId) {
            case 0: {
                this.setMode(checked);
            }
        }
    }

    public static enum Mode implements class_3542
    {
        EMPTYING,
        FILLING;

        public static final Codec<Mode> CODEC;

        @NotNull
        public static Mode fromIndex(int index) {
            Mode[] values = Mode.values();
            if (index < 0 || index >= values.length) {
                return EMPTYING;
            }
            return values[index];
        }

        @NotNull
        public String method_15434() {
            return this.name().toLowerCase(Locale.US);
        }

        static {
            CODEC = class_5699.method_39512((Codec)Codec.stringResolver(Enum::name, Mode::valueOf), (Codec)class_5699.method_39511(Enum::ordinal, i -> i >= 0 && i < Mode.values().length ? Mode.values()[i] : null, (int)-1));
        }
    }
}

