/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.ItemConveyorBeltBlock;
import me.jddev0.ep.block.ItemConveyorBeltLoaderBlock;
import me.jddev0.ep.block.entity.ItemConveyorBeltBlockEntity;
import me.jddev0.ep.block.entity.base.MenuInventoryStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.machine.tier.ConveyorBeltTier;
import me.jddev0.ep.screen.ItemConveyorBeltLoaderMenu;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.jetbrains.annotations.Nullable;

public class ItemConveyorBeltLoaderBlockEntity
extends MenuInventoryStorageBlockEntity<class_1277> {
    private final int ticksPerItem;
    final InputOutputItemHandler itemHandlerSided;
    private final ConveyorBeltTier tier;

    public ItemConveyorBeltLoaderBlockEntity(class_2338 blockPos, class_2680 blockState, ConveyorBeltTier tier) {
        class_2591<ItemConveyorBeltLoaderBlockEntity> class_25912 = tier.getItemConveyorBeltLoaderBlockEntityFromTier();
        super(class_25912, blockPos, blockState, switch (tier) {
            default -> throw new MatchException(null, null);
            case ConveyorBeltTier.BASIC -> "item_conveyor_belt_loader";
            case ConveyorBeltTier.FAST -> "fast_item_conveyor_belt_loader";
            case ConveyorBeltTier.EXPRESS -> "express_item_conveyor_belt_loader";
        }, 1);
        this.itemHandlerSided = new InputOutputItemHandler((class_1263)this.itemHandler, (i, stack) -> i == 0, i -> i == 0);
        this.tier = tier;
        this.ticksPerItem = switch (tier) {
            default -> throw new MatchException(null, null);
            case ConveyorBeltTier.BASIC -> ModConfigs.COMMON_BASIC_ITEM_CONVEYOR_BELT_LOADER_TICKS_PER_ITEM.getValue();
            case ConveyorBeltTier.FAST -> ModConfigs.COMMON_FAST_ITEM_CONVEYOR_BELT_LOADER_TICKS_PER_ITEM.getValue();
            case ConveyorBeltTier.EXPRESS -> ModConfigs.COMMON_EXPRESS_ITEM_CONVEYOR_BELT_LOADER_TICKS_PER_ITEM.getValue();
        };
    }

    @Override
    protected class_1277 initInventoryStorage() {
        return new class_1277(this.slotCount){

            public int method_5444() {
                return 1;
            }

            public boolean method_5437(int slot, class_1799 stack) {
                if (slot == 0) {
                    return true;
                }
                return super.method_5437(slot, stack);
            }

            public void method_5431() {
                super.method_5431();
                ItemConveyorBeltLoaderBlockEntity.this.method_5431();
            }
        };
    }

    public ConveyorBeltTier getTier() {
        return this.tier;
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        return new ItemConveyorBeltLoaderMenu(id, this, inventory, (class_1263)this.itemHandler);
    }

    public int getRedstoneOutput() {
        return class_1703.method_7618((class_1263)this.itemHandler);
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, ItemConveyorBeltLoaderBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        if (level.method_8510() % (long)blockEntity.ticksPerItem == 0L && ((Boolean)state.method_11654((class_2769)ItemConveyorBeltLoaderBlock.ENABLED)).booleanValue()) {
            if (!blockEntity.itemHandler.method_5438(0).method_7960()) {
                ItemConveyorBeltLoaderBlockEntity.insertItemStackIntoItemConveyorBelt(level, blockPos, state, blockEntity, blockEntity.itemHandler.method_5438(0).method_7972());
            }
            if (blockEntity.itemHandler.method_5438(0).method_7960()) {
                ItemConveyorBeltLoaderBlockEntity.extractItemStackFromBlockEntity(level, blockPos, state, blockEntity);
            }
        }
    }

    private static void insertItemStackIntoItemConveyorBelt(class_1937 level, class_2338 blockPos, class_2680 state, ItemConveyorBeltLoaderBlockEntity blockEntity, class_1799 itemStackToInsert) {
        class_2350 direction = (class_2350)blockEntity.method_11010().method_11654(ItemConveyorBeltLoaderBlock.FACING);
        class_2338 testPos = blockPos.method_10093(direction);
        class_2680 testBlockState = level.method_8320(testPos);
        if (!(testBlockState.method_26204() instanceof ItemConveyorBeltBlock)) {
            return;
        }
        class_2586 testBlockEntity = level.method_8321(testPos);
        if (!(testBlockEntity instanceof ItemConveyorBeltBlockEntity)) {
            return;
        }
        Storage itemStackStorage = (Storage)ItemStorage.SIDED.find(level, testPos, (Object)direction.method_10153());
        if (itemStackStorage == null || !itemStackStorage.supportsInsertion()) {
            return;
        }
        try (Transaction transaction = Transaction.openOuter();){
            long amount = itemStackStorage.insert((Object)ItemVariant.of((class_1799)itemStackToInsert), 1L, (TransactionContext)transaction);
            if (amount > 0L) {
                blockEntity.itemHandler.method_5447(0, class_1799.field_8037);
            }
            transaction.commit();
        }
    }

    private static void extractItemStackFromBlockEntity(class_1937 level, class_2338 blockPos, class_2680 state, ItemConveyorBeltLoaderBlockEntity blockEntity) {
        class_2350 direction = ((class_2350)blockEntity.method_11010().method_11654(ItemConveyorBeltLoaderBlock.FACING)).method_10153();
        class_2338 testPos = blockPos.method_10093(direction);
        class_2586 testBlockEntity = level.method_8321(testPos);
        if (testBlockEntity == null) {
            return;
        }
        Storage itemStackStorage = (Storage)ItemStorage.SIDED.find(level, testPos, (Object)direction.method_10153());
        if (itemStackStorage == null || !itemStackStorage.supportsExtraction()) {
            return;
        }
        try (Transaction transaction = Transaction.openOuter();){
            for (StorageView itemView : itemStackStorage) {
                ItemVariant itemVariant;
                long amount;
                if (itemView.isResourceBlank() || (amount = itemStackStorage.extract((Object)(itemVariant = (ItemVariant)itemView.getResource()), 1L, (TransactionContext)transaction)) <= 0L) continue;
                blockEntity.itemHandler.method_5447(0, itemVariant.toStack(1));
                break;
            }
            transaction.commit();
        }
    }
}

