/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.ArrayList;
import java.util.List;
import me.jddev0.ep.block.MinecartUnchargerBlock;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.MenuEnergyStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergizedPowerEnergyStorage;
import me.jddev0.ep.energy.EnergizedPowerLimitingEnergyStorage;
import me.jddev0.ep.entity.AbstractMinecartBatteryBox;
import me.jddev0.ep.screen.MinecartUnchargerMenu;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1301;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_5575;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;

public class MinecartUnchargerBlockEntity
extends MenuEnergyStorageBlockEntity<EnergizedPowerEnergyStorage> {
    public static final long MAX_TRANSFER = ModConfigs.COMMON_MINECART_UNCHARGER_TRANSFER_RATE.getValue();
    private boolean hasMinecartOld = true;
    private boolean hasMinecart = false;

    public MinecartUnchargerBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(EPBlockEntities.MINECART_UNCHARGER_ENTITY, blockPos, blockState, "minecart_uncharger", ModConfigs.COMMON_MINECART_UNCHARGER_CAPACITY.getValue(), MAX_TRANSFER);
    }

    @Override
    protected EnergizedPowerEnergyStorage initEnergyStorage() {
        return new EnergizedPowerEnergyStorage(this.baseEnergyCapacity, this.baseEnergyCapacity, this.baseEnergyCapacity){

            protected void onFinalCommit() {
                MinecartUnchargerBlockEntity.this.method_5431();
                MinecartUnchargerBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Override
    protected EnergizedPowerLimitingEnergyStorage initLimitingEnergyStorage() {
        return new EnergizedPowerLimitingEnergyStorage(this.energyStorage, 0L, this.baseEnergyTransferRate);
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        this.syncEnergyToPlayer(player);
        return new MinecartUnchargerMenu(id, this, inventory);
    }

    public int getRedstoneOutput() {
        class_2338 blockPosFacing = this.method_11016().method_10093((class_2350)this.method_11010().method_11654(MinecartUnchargerBlock.FACING));
        List minecarts = this.field_11863.method_18023(class_5575.method_31795(AbstractMinecartBatteryBox.class), new class_238((double)blockPosFacing.method_10263(), (double)blockPosFacing.method_10264(), (double)blockPosFacing.method_10260(), (double)(blockPosFacing.method_10263() + 1), (double)(blockPosFacing.method_10264() + 1), (double)(blockPosFacing.method_10260() + 1)), class_1301.field_6154);
        if (minecarts.isEmpty()) {
            return 0;
        }
        AbstractMinecartBatteryBox minecart = (AbstractMinecartBatteryBox)((Object)minecarts.get(0));
        long minecartEnergy = minecart.getEnergy();
        boolean isEmptyFlag = minecartEnergy == 0L;
        return Math.min(class_3532.method_15375((float)((float)minecartEnergy / (float)minecart.getCapacity() * 14.0f)) + (isEmptyFlag ? 0 : 1), 15);
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, MinecartUnchargerBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        if (blockEntity.hasMinecartOld != blockEntity.hasMinecart) {
            MinecartUnchargerBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
        }
        blockEntity.hasMinecartOld = blockEntity.hasMinecart;
        class_2338 blockPosFacing = blockEntity.method_11016().method_10093((class_2350)blockEntity.method_11010().method_11654(MinecartUnchargerBlock.FACING));
        List minecarts = level.method_18023(class_5575.method_31795(AbstractMinecartBatteryBox.class), new class_238((double)blockPosFacing.method_10263(), (double)blockPosFacing.method_10264(), (double)blockPosFacing.method_10260(), (double)(blockPosFacing.method_10263() + 1), (double)(blockPosFacing.method_10264() + 1), (double)(blockPosFacing.method_10260() + 1)), class_1301.field_6154);
        boolean bl = blockEntity.hasMinecart = !minecarts.isEmpty();
        if (!blockEntity.hasMinecart) {
            return;
        }
        AbstractMinecartBatteryBox minecart = (AbstractMinecartBatteryBox)((Object)minecarts.get(0));
        long transferred = Math.max(0L, Math.min(Math.min(((EnergizedPowerEnergyStorage)blockEntity.energyStorage).getCapacity() - ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).getAmount(), blockEntity.limitingEnergyStorage.getMaxExtract()), Math.min(minecart.getTransferRate(), minecart.getEnergy())));
        minecart.setEnergy(minecart.getEnergy() - transferred);
        try (Transaction transaction = Transaction.openOuter();){
            ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).insert(transferred, (TransactionContext)transaction);
            transaction.commit();
        }
        MinecartUnchargerBlockEntity.transferEnergy(level, blockPos, state, blockEntity);
    }

    private static void transferEnergy(class_1937 level, class_2338 blockPos, class_2680 state, MinecartUnchargerBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        ArrayList<EnergyStorage> consumerItems = new ArrayList<EnergyStorage>();
        ArrayList<Long> consumerEnergyValues = new ArrayList<Long>();
        long consumptionSum = 0L;
        for (class_2350 direction : class_2350.values()) {
            EnergyStorage limitingEnergyStorage;
            class_2338 testPos = blockPos.method_10093(direction);
            class_2586 testBlockEntity = level.method_8321(testPos);
            if (testBlockEntity == null || (limitingEnergyStorage = (EnergyStorage)EnergyStorage.SIDED.find(level, testPos, (Object)direction.method_10153())) == null || !limitingEnergyStorage.supportsInsertion()) continue;
            try (Transaction transaction = Transaction.openOuter();){
                long received = limitingEnergyStorage.insert(Math.min(blockEntity.limitingEnergyStorage.getMaxExtract(), ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).getAmount()), (TransactionContext)transaction);
                if (received <= 0L) continue;
                consumptionSum += received;
                consumerItems.add(limitingEnergyStorage);
                consumerEnergyValues.add(received);
            }
        }
        ArrayList<Long> consumerEnergyDistributed = new ArrayList<Long>();
        for (int i = 0; i < consumerItems.size(); ++i) {
            consumerEnergyDistributed.add(0L);
        }
        long consumptionLeft = Math.min(blockEntity.limitingEnergyStorage.getMaxExtract(), Math.min(((EnergizedPowerEnergyStorage)blockEntity.energyStorage).getAmount(), consumptionSum));
        try (Transaction transaction = Transaction.openOuter();){
            ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).extract(consumptionLeft, (TransactionContext)transaction);
            transaction.commit();
        }
        int divisor = consumerItems.size();
        block18: while (consumptionLeft > 0L) {
            long consumptionPerConsumer = consumptionLeft / (long)divisor;
            if (consumptionPerConsumer == 0L) {
                divisor = Math.max(1, divisor - 1);
                consumptionPerConsumer = consumptionLeft / (long)divisor;
            }
            for (int i = 0; i < consumerEnergyValues.size(); ++i) {
                long consumptionDistributed = (Long)consumerEnergyDistributed.get(i);
                long consumptionOfConsumerLeft = (Long)consumerEnergyValues.get(i) - consumptionDistributed;
                long consumptionDistributedNew = Math.min(consumptionOfConsumerLeft, Math.min(consumptionPerConsumer, consumptionLeft));
                consumerEnergyDistributed.set(i, consumptionDistributed + consumptionDistributedNew);
                if ((consumptionLeft -= consumptionDistributedNew) == 0L) break block18;
            }
        }
        for (int i = 0; i < consumerItems.size(); ++i) {
            long energy = (Long)consumerEnergyDistributed.get(i);
            if (energy <= 0L) continue;
            try (Transaction transaction = Transaction.openOuter();){
                ((EnergyStorage)consumerItems.get(i)).insert(energy, (TransactionContext)transaction);
                transaction.commit();
                continue;
            }
        }
    }
}

