/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity.base;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.jddev0.ep.block.entity.base.UpgradableMenuProvider;
import me.jddev0.ep.block.entity.base.WorkerMachineBlockEntity;
import me.jddev0.ep.inventory.CombinedContainerData;
import me.jddev0.ep.inventory.data.BooleanValueContainerData;
import me.jddev0.ep.inventory.data.ComparatorModeValueContainerData;
import me.jddev0.ep.inventory.data.EnergyValueContainerData;
import me.jddev0.ep.inventory.data.ProgressValueContainerData;
import me.jddev0.ep.inventory.data.RedstoneModeValueContainerData;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.SyncIngredientsS2CPacket;
import me.jddev0.ep.recipe.IngredientPacketUpdate;
import me.jddev0.ep.util.InventoryUtils;
import me.jddev0.ep.util.RecipeUtils;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;

public abstract class SimpleRecipeMachineBlockEntity<C extends class_9695, R extends class_1860<C>>
extends WorkerMachineBlockEntity<class_8786<R>>
implements IngredientPacketUpdate {
    protected final UpgradableMenuProvider menuProvider;
    protected final class_3956<R> recipeType;
    protected List<class_1856> ingredientsOfRecipes = new ArrayList<class_1856>();

    public SimpleRecipeMachineBlockEntity(class_2591<?> type, class_2338 blockPos, class_2680 blockState, String machineName, UpgradableMenuProvider menuProvider, int slotCount, class_3956<R> recipeType, int baseRecipeDuration, long baseEnergyCapacity, long baseEnergyTransferRate, long baseEnergyConsumptionPerTick, UpgradeModuleModifier ... upgradeModifierSlots) {
        super(type, blockPos, blockState, machineName, slotCount, baseRecipeDuration, baseEnergyCapacity, baseEnergyTransferRate, baseEnergyConsumptionPerTick, upgradeModifierSlots);
        this.menuProvider = menuProvider;
        this.recipeType = recipeType;
    }

    @Override
    protected class_1277 initInventoryStorage() {
        return new class_1277(this.slotCount){

            public boolean method_5437(int slot, class_1799 stack) {
                class_3218 serverWorld;
                class_1937 class_19372;
                return slot == 0 && ((class_19372 = SimpleRecipeMachineBlockEntity.this.field_11863) instanceof class_3218 ? RecipeUtils.isIngredientOfAny(serverWorld = (class_3218)class_19372, SimpleRecipeMachineBlockEntity.this.recipeType, stack) : RecipeUtils.isIngredientOfAny(SimpleRecipeMachineBlockEntity.this.ingredientsOfRecipes, stack));
            }

            public void method_5447(int slot, class_1799 stack) {
                if (slot == 0) {
                    class_1799 itemStack = this.method_5438(slot);
                    if (!(stack.method_7960() || itemStack.method_7960() || class_1799.method_31577((class_1799)stack, (class_1799)itemStack))) {
                        SimpleRecipeMachineBlockEntity.this.resetProgress();
                    }
                }
                super.method_5447(slot, stack);
            }

            public void method_5431() {
                super.method_5431();
                SimpleRecipeMachineBlockEntity.this.method_5431();
            }
        };
    }

    @Override
    protected class_3913 initContainerData() {
        return new CombinedContainerData(new ProgressValueContainerData(() -> this.progress, value -> {
            this.progress = value;
        }), new ProgressValueContainerData(() -> this.maxProgress, value -> {
            this.maxProgress = value;
        }), new EnergyValueContainerData(() -> this.hasWork() ? this.getCurrentWorkData().map(this::getEnergyConsumptionFor).orElse(-1L) : -1L, value -> {}), new EnergyValueContainerData(() -> this.energyConsumptionLeft, value -> {}), new BooleanValueContainerData(() -> this.hasEnoughEnergy, value -> {}), new RedstoneModeValueContainerData(() -> this.redstoneMode, value -> {
            this.redstoneMode = value;
        }), new ComparatorModeValueContainerData(() -> this.comparatorMode, value -> {
            this.comparatorMode = value;
        }));
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        this.syncEnergyToPlayer(player);
        this.syncIngredientListToPlayer(player);
        return this.menuProvider.createMenu(id, this, inventory, (class_1263)this.itemHandler, this.upgradeModuleInventory, this.data);
    }

    protected abstract C getRecipeInput(class_1277 var1);

    protected Optional<class_8786<R>> getRecipeFor(class_1277 inventory) {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return Optional.empty();
        }
        class_3218 serverWorld = (class_3218)class_19372;
        return serverWorld.method_64577().method_8132(this.recipeType, this.getRecipeInput(inventory), this.field_11863);
    }

    @Override
    protected final Optional<class_8786<R>> getCurrentWorkData() {
        return this.getRecipeFor(this.itemHandler);
    }

    @Override
    protected final double getWorkDataDependentWorkDuration(class_8786<R> workData) {
        return this.getRecipeDependentRecipeDuration(workData);
    }

    protected double getRecipeDependentRecipeDuration(class_8786<R> recipe) {
        return 1.0;
    }

    @Override
    protected final double getWorkDataDependentEnergyConsumption(class_8786<R> workData) {
        return this.getRecipeDependentEnergyConsumption(workData);
    }

    protected double getRecipeDependentEnergyConsumption(class_8786<R> recipe) {
        return 1.0;
    }

    @Override
    protected final boolean hasWork() {
        return this.hasRecipe();
    }

    protected boolean hasRecipe() {
        if (this.field_11863 == null) {
            return false;
        }
        Optional<class_8786<R>> recipe = this.getRecipeFor(this.itemHandler);
        return recipe.isPresent() && this.canCraftRecipe(this.itemHandler, recipe.get());
    }

    @Override
    protected final void onWorkStarted(class_8786<R> workData) {
        this.onStartCrafting(workData);
    }

    protected void onStartCrafting(class_8786<R> recipe) {
    }

    @Override
    protected final void onWorkCompleted(class_8786<R> workData) {
        this.craftItem(workData);
    }

    protected void craftItem(class_8786<R> recipe) {
        if (this.field_11863 == null || !this.hasRecipe()) {
            return;
        }
        this.itemHandler.method_5434(0, 1);
        this.itemHandler.method_5447(1, recipe.comp_1933().method_8116(this.getRecipeInput(this.itemHandler), (class_7225.class_7874)this.field_11863.method_30349()).method_46651(this.itemHandler.method_5438(1).method_7947() + recipe.comp_1933().method_8116(this.getRecipeInput(this.itemHandler), (class_7225.class_7874)this.field_11863.method_30349()).method_7947()));
        this.resetProgress();
    }

    protected boolean canCraftRecipe(class_1277 inventory, class_8786<R> recipe) {
        return this.field_11863 != null && InventoryUtils.canInsertItemIntoSlot((class_1263)inventory, 1, recipe.comp_1933().method_8116(this.getRecipeInput(this.itemHandler), (class_7225.class_7874)this.field_11863.method_30349()));
    }

    protected void syncIngredientListToPlayer(class_1657 player) {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        ModMessages.sendServerPacketToPlayer((class_3222)player, new SyncIngredientsS2CPacket(this.method_11016(), 0, RecipeUtils.getIngredientsOf(serverWorld, this.recipeType)));
    }

    public List<class_1856> getIngredientsOfRecipes() {
        return new ArrayList<class_1856>(this.ingredientsOfRecipes);
    }

    @Override
    public void setIngredients(int index, List<class_1856> ingredients) {
        if (index == 0) {
            this.ingredientsOfRecipes = ingredients;
        }
    }
}

