/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity.base;

import java.util.Optional;
import me.jddev0.ep.block.entity.base.ConfigurableUpgradableInventoryEnergyStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergizedPowerEnergyStorage;
import me.jddev0.ep.energy.EnergizedPowerLimitingEnergyStorage;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1277;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;

public abstract class WorkerMachineBlockEntity<W>
extends ConfigurableUpgradableInventoryEnergyStorageBlockEntity<EnergizedPowerEnergyStorage, class_1277> {
    protected final long baseEnergyConsumptionPerTick;
    protected final int baseWorkDuration;
    protected int progress;
    protected int maxProgress;
    protected long energyConsumptionLeft = -1L;
    protected boolean hasEnoughEnergy;
    protected int timeoutOffState;

    public WorkerMachineBlockEntity(class_2591<?> type, class_2338 blockPos, class_2680 blockState, String machineName, int slotCount, int baseWorkDuration, long baseEnergyCapacity, long baseEnergyTransferRate, long baseEnergyConsumptionPerTick, UpgradeModuleModifier ... upgradeModifierSlots) {
        super(type, blockPos, blockState, machineName, baseEnergyCapacity, baseEnergyTransferRate, slotCount, upgradeModifierSlots);
        this.baseEnergyConsumptionPerTick = baseEnergyConsumptionPerTick;
        this.baseWorkDuration = baseWorkDuration;
    }

    @Override
    protected EnergizedPowerEnergyStorage initEnergyStorage() {
        return new EnergizedPowerEnergyStorage(this.baseEnergyCapacity, this.baseEnergyCapacity, this.baseEnergyCapacity){

            @Override
            public long getCapacity() {
                return Math.max(1L, (long)Math.ceil((double)this.capacity * WorkerMachineBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CAPACITY)));
            }

            protected void onFinalCommit() {
                WorkerMachineBlockEntity.this.method_5431();
                WorkerMachineBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Override
    protected EnergizedPowerLimitingEnergyStorage initLimitingEnergyStorage() {
        return new EnergizedPowerLimitingEnergyStorage(this.energyStorage, this.baseEnergyTransferRate, 0L){

            @Override
            public long getMaxInsert() {
                return Math.max(1L, (long)Math.ceil((double)this.maxInsert * WorkerMachineBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_TRANSFER_RATE)));
            }
        };
    }

    @Override
    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        view.method_71465("recipe.progress", this.progress);
        view.method_71465("recipe.max_progress", this.maxProgress);
        view.method_71466("recipe.energy_consumption_left", this.energyConsumptionLeft);
    }

    @Override
    protected void method_11014(class_11368 view) {
        super.method_11014(view);
        this.progress = view.method_71424("recipe.progress", 0);
        this.maxProgress = view.method_71424("recipe.max_progress", 0);
        this.energyConsumptionLeft = view.method_71425("recipe.energy_consumption_left", 0L);
    }

    public static <W> void tick(class_1937 level, class_2338 blockPos, class_2680 state, WorkerMachineBlockEntity<W> blockEntity) {
        if (level.method_8608()) {
            return;
        }
        blockEntity.onTickStart();
        if (blockEntity.timeoutOffState > 0) {
            --blockEntity.timeoutOffState;
            if (blockEntity.timeoutOffState == 0) {
                blockEntity.onHasNotEnoughEnergyWithOffTimeout();
            }
        }
        if (!blockEntity.redstoneMode.isActive((Boolean)state.method_11654((class_2769)class_2741.field_12484))) {
            return;
        }
        if (blockEntity.hasWork()) {
            Optional<W> workData = blockEntity.getCurrentWorkData();
            if (workData.isEmpty()) {
                blockEntity.onTickEnd();
                return;
            }
            if (blockEntity.maxProgress == 0) {
                blockEntity.onWorkStarted(workData.get());
                blockEntity.maxProgress = blockEntity.getWorkDurationFor(workData.get());
            }
            long energyConsumptionPerTick = blockEntity.getEnergyConsumptionFor(workData.get());
            if (blockEntity.energyConsumptionLeft < 0L) {
                blockEntity.energyConsumptionLeft = energyConsumptionPerTick * (long)blockEntity.maxProgress;
            }
            if (energyConsumptionPerTick <= ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).getAmount()) {
                blockEntity.hasEnoughEnergy = true;
                blockEntity.timeoutOffState = 0;
                blockEntity.onHasEnoughEnergy();
                if (blockEntity.progress < 0 || blockEntity.maxProgress < 0 || blockEntity.energyConsumptionLeft < 0L) {
                    blockEntity.resetProgress();
                    WorkerMachineBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
                    blockEntity.onTickEnd();
                    return;
                }
                try (Transaction transaction = Transaction.openOuter();){
                    ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).extract(energyConsumptionPerTick, (TransactionContext)transaction);
                    transaction.commit();
                }
                blockEntity.energyConsumptionLeft -= energyConsumptionPerTick;
                ++blockEntity.progress;
                if (blockEntity.progress >= blockEntity.maxProgress) {
                    blockEntity.onWorkCompleted(workData.get());
                }
                WorkerMachineBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
            } else {
                blockEntity.hasEnoughEnergy = false;
                if (blockEntity.timeoutOffState == 0) {
                    blockEntity.timeoutOffState = ModConfigs.COMMON_OFF_STATE_TIMEOUT.getValue();
                }
                blockEntity.onHasNotEnoughEnergy();
                WorkerMachineBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
            }
        } else {
            blockEntity.resetProgress();
            if (blockEntity.timeoutOffState == 0) {
                blockEntity.timeoutOffState = ModConfigs.COMMON_OFF_STATE_TIMEOUT.getValue();
            }
            blockEntity.onHasNotEnoughEnergy();
            WorkerMachineBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
        }
        blockEntity.onTickEnd();
    }

    protected void onTickStart() {
    }

    protected void onTickEnd() {
    }

    protected void onHasEnoughEnergy() {
    }

    protected void onHasNotEnoughEnergy() {
    }

    protected void onHasNotEnoughEnergyWithOffTimeout() {
    }

    protected final int getWorkDurationFor(W workData) {
        return Math.max(1, (int)Math.ceil((double)this.baseWorkDuration * this.getWorkDataDependentWorkDuration(workData) / this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.SPEED)));
    }

    protected final long getEnergyConsumptionFor(W workData) {
        return Math.max(1L, (long)Math.ceil((double)this.baseEnergyConsumptionPerTick * this.getWorkDataDependentEnergyConsumption(workData) * this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CONSUMPTION)));
    }

    protected double getWorkDataDependentWorkDuration(W workData) {
        return 1.0;
    }

    protected double getWorkDataDependentEnergyConsumption(W workData) {
        return 1.0;
    }

    protected abstract boolean hasWork();

    protected abstract Optional<W> getCurrentWorkData();

    protected abstract void onWorkStarted(W var1);

    protected abstract void onWorkCompleted(W var1);

    protected void resetProgress() {
        this.progress = 0;
        this.maxProgress = 0;
        this.energyConsumptionLeft = -1L;
        this.hasEnoughEnergy = false;
    }

    @Override
    protected void updateUpgradeModules() {
        this.resetProgress();
        super.updateUpgradeModules();
    }
}

