/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity.renderer;

import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.FluidTankBlock;
import me.jddev0.ep.block.entity.AbstractFluidTankBlockEntity;
import me.jddev0.ep.block.entity.renderer.state.FluidTankBlockEntityRenderState;
import me.jddev0.ep.fluid.FluidStack;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3611;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_4730;
import net.minecraft.class_5614;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class FluidTankBlockEntityRenderer<F extends Storage<FluidVariant>>
implements class_827<AbstractFluidTankBlockEntity<F>, FluidTankBlockEntityRenderState> {
    private final class_5614.class_5615 context;

    public FluidTankBlockEntityRenderer(class_5614.class_5615 context) {
        this.context = context;
    }

    public FluidTankBlockEntityRenderState createRenderState() {
        return new FluidTankBlockEntityRenderState();
    }

    public void updateRenderState(AbstractFluidTankBlockEntity<F> blockEntity, FluidTankBlockEntityRenderState state, float tickProgress, class_243 cameraPos, @Nullable class_11683.class_11792 crumblingOverlay) {
        super.method_74331(blockEntity, (class_11954)state, tickProgress, cameraPos, crumblingOverlay);
        state.facing = (class_2350)blockEntity.method_11010().method_11654(FluidTankBlock.FACING);
        state.tankCapacity = blockEntity.getTankCapacity(0);
        state.fluidStack = blockEntity.getFluid(0);
    }

    public void render(FluidTankBlockEntityRenderState state, class_4587 poseStack, class_11659 queue, class_12075 cameraRenderState) {
        queue.method_73483(poseStack, class_1921.method_29380(), (matrixEntry, vertexConsumer) -> {
            long capacity = state.tankCapacity;
            FluidStack fluidStack = state.fluidStack;
            if (fluidStack.isEmpty()) {
                return;
            }
            float height = fluidStack.getDropletsAmount() <= 0L || capacity == 0L ? 0.0f : (float)Math.min(fluidStack.getDropletsAmount(), capacity - 1L) * 14.0f / (float)capacity;
            class_2350 facing = state.facing;
            matrixEntry.method_67798((Quaternionfc)facing.method_23224());
            matrixEntry.method_67798((Quaternionfc)new Quaternionf().rotationX(1.5707964f));
            switch (facing) {
                case field_11043: {
                    matrixEntry.method_67796(-1.0f, -1.0f + (16.0f - height - 1.0f) / 16.0f, 0.0625f);
                    break;
                }
                case field_11035: {
                    matrixEntry.method_67796(0.0f, -1.0f + (16.0f - height - 1.0f) / 16.0f, -0.9375f);
                    break;
                }
                case field_11034: {
                    matrixEntry.method_67796(-1.0f, -1.0f + (16.0f - height - 1.0f) / 16.0f, -0.9375f);
                    break;
                }
                case field_11039: {
                    matrixEntry.method_67796(0.0f, -1.0f + (16.0f - height - 1.0f) / 16.0f, 0.0625f);
                    break;
                }
            }
            class_3611 fluid = fluidStack.getFluid();
            class_1058 stillFluidSprite = FluidVariantRendering.getSprite((FluidVariant)fluidStack.getFluidVariant());
            int fluidColorTint = FluidVariantRendering.getColor((FluidVariant)fluidStack.getFluidVariant());
            Matrix4f mat = matrixEntry.method_23761();
            float u0 = stillFluidSprite.method_4594();
            float u1 = stillFluidSprite.method_4577();
            float v0 = stillFluidSprite.method_4593();
            float v1 = stillFluidSprite.method_4575();
            float du = u1 - u0;
            float dv = v1 - v0;
            v0 += 0.0625f * dv;
            float v1Orig = v1 -= 0.0625f * dv;
            vertexConsumer.method_22918(mat, 0.0625f, height * 0.0625f, 0.0f).method_39415(fluidColorTint).method_22913(u0 += 0.0625f * du, v1 -= (14.0f - height) / 16.0f * dv).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(matrixEntry, 0.0f, 0.0f, 0.0f);
            vertexConsumer.method_22918(mat, 0.9375f, height * 0.0625f, 0.0f).method_39415(fluidColorTint).method_22913(u1 -= 0.0625f * du, v1).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(matrixEntry, 0.0f, 0.0f, 0.0f);
            vertexConsumer.method_22918(mat, 0.9375f, 0.0f, 0.0f).method_39415(fluidColorTint).method_22913(u1, v0).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(matrixEntry, 0.0f, 0.0f, 0.0f);
            vertexConsumer.method_22918(mat, 0.0625f, 0.0f, 0.0f).method_39415(fluidColorTint).method_22913(u0, v0).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(matrixEntry, 0.0f, 0.0f, 0.0f);
            class_1058 indicatorBarSprite = class_310.method_1551().method_72703().method_73030(new class_4730(class_1059.field_5275, EPAPI.id("block/fluid_tank_indicator_bar")));
            float translateForMinMaxIndicatorBarHeight = height < 2.0f ? (height - 2.0f) / 16.0f : (height > 12.0f ? (height - 12.0f) / 16.0f : 0.0f);
            matrixEntry.method_67796(0.0f, translateForMinMaxIndicatorBarHeight, 0.0f);
            float ibu0 = indicatorBarSprite.method_4594();
            float ibu1 = indicatorBarSprite.method_4577();
            float ibv0 = indicatorBarSprite.method_4593();
            float ibv1 = indicatorBarSprite.method_4575();
            ibu1 = ibu0 + 0.0625f * (ibu1 - ibu0);
            ibv1 = ibv0 + 0.0625f * (ibv1 - ibv0);
            vertexConsumer.method_22918(mat, 0.375f, 0.015f, -0.05f).method_1336(255, 255, 255, 255).method_22913(ibu0, ibv1).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(matrixEntry, 0.0f, 0.0f, 0.0f);
            vertexConsumer.method_22918(mat, 0.625f, 0.015f, -0.05f).method_1336(255, 255, 255, 255).method_22913(ibu1, ibv1).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(matrixEntry, 0.0f, 0.0f, 0.0f);
            vertexConsumer.method_22918(mat, 0.625f, -0.015f, -0.05f).method_1336(255, 255, 255, 255).method_22913(ibu1, ibv0).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(matrixEntry, 0.0f, 0.0f, 0.0f);
            vertexConsumer.method_22918(mat, 0.375f, -0.015f, -0.05f).method_1336(255, 255, 255, 255).method_22913(ibu0, ibv0).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(matrixEntry, 0.0f, 0.0f, 0.0f);
            matrixEntry.method_67796(0.0f, -translateForMinMaxIndicatorBarHeight, 0.0f);
            v1 = v1Orig;
            matrixEntry.method_67796(0.0f, 1.0f - (16.0f - height - 1.0f) / 16.0f, 0.0f);
            matrixEntry.method_67798((Quaternionfc)new Quaternionf().rotationX(-1.5707964f));
            matrixEntry.method_67796(0.0f, -0.875f, -1.0f + (16.0f - height - 1.0f) / 16.0f);
            vertexConsumer.method_22918(mat, 0.0625f, 0.875f, 0.0f).method_39415(fluidColorTint).method_22913(u0, v1).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(matrixEntry, 0.0f, 0.0f, 0.0f);
            vertexConsumer.method_22918(mat, 0.9375f, 0.875f, 0.0f).method_39415(fluidColorTint).method_22913(u1, v1).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(matrixEntry, 0.0f, 0.0f, 0.0f);
            vertexConsumer.method_22918(mat, 0.9375f, 0.0f, 0.0f).method_39415(fluidColorTint).method_22913(u1, v0).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(matrixEntry, 0.0f, 0.0f, 0.0f);
            vertexConsumer.method_22918(mat, 0.0625f, 0.0f, 0.0f).method_39415(fluidColorTint).method_22913(u0, v0).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(matrixEntry, 0.0f, 0.0f, 0.0f);
        });
    }
}

