/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.component;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public final class InventoryComponent {
    public static final Codec<InventoryComponent> CODEC = class_1799.field_49266.listOf().xmap(InventoryComponent::new, component -> component.stacks);
    public static final class_9139<class_9129, InventoryComponent> PACKET_CODEC = class_1799.field_49268.method_56433(class_9135.method_56363()).method_56432(InventoryComponent::new, component -> component.stacks);
    private final List<class_1799> stacks;

    public InventoryComponent(List<class_1799> stacks) {
        this.stacks = stacks.stream().map(class_1799::method_7972).toList();
    }

    public class_1799 get(int index) {
        return this.stacks.get(index).method_7972();
    }

    public Stream<class_1799> stream() {
        return this.stacks.stream().map(class_1799::method_7972);
    }

    public Iterable<class_1799> iterate() {
        return Lists.transform(this.stacks, class_1799::method_7972);
    }

    public int size() {
        return this.stacks.size();
    }

    public boolean isEmpty() {
        return this.stacks.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InventoryComponent that = (InventoryComponent)o;
        if (this.stacks.size() != that.stacks.size()) {
            return false;
        }
        for (int i = 0; i < this.stacks.size(); ++i) {
            if (class_1799.method_7973((class_1799)this.stacks.get(i), (class_1799)that.stacks.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int i = 0;
        for (class_1799 itemStack : this.stacks) {
            i = i * 31 + class_1799.method_57355((class_1799)itemStack);
        }
        return i;
    }

    public String toString() {
        return "InventoryComponent{stacks=" + String.valueOf(this.stacks) + "}";
    }
}

