/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.item;

import java.util.Locale;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.item.upgrade.UpgradeModuleItem;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

public class SpeedUpgradeModuleItem
extends UpgradeModuleItem {
    private static final UpgradeModuleModifier[] UPGRADE_MODULE_MODIFIERS = new UpgradeModuleModifier[]{UpgradeModuleModifier.SPEED, UpgradeModuleModifier.ENERGY_CONSUMPTION};
    private static final double SPEED_1_EFFECT = ModConfigs.COMMON_UPGRADE_MODULE_SPEED_1_EFFECT.getValue();
    private static final double SPEED_1_ENERGY_CONSUMPTION_EFFECT = ModConfigs.COMMON_UPGRADE_MODULE_SPEED_1_ENERGY_CONSUMPTION_EFFECT.getValue();
    private static final double SPEED_2_EFFECT = ModConfigs.COMMON_UPGRADE_MODULE_SPEED_2_EFFECT.getValue();
    private static final double SPEED_2_ENERGY_CONSUMPTION_EFFECT = ModConfigs.COMMON_UPGRADE_MODULE_SPEED_2_ENERGY_CONSUMPTION_EFFECT.getValue();
    private static final double SPEED_3_EFFECT = ModConfigs.COMMON_UPGRADE_MODULE_SPEED_3_EFFECT.getValue();
    private static final double SPEED_3_ENERGY_CONSUMPTION_EFFECT = ModConfigs.COMMON_UPGRADE_MODULE_SPEED_3_ENERGY_CONSUMPTION_EFFECT.getValue();
    private static final double SPEED_4_EFFECT = ModConfigs.COMMON_UPGRADE_MODULE_SPEED_4_EFFECT.getValue();
    private static final double SPEED_4_ENERGY_CONSUMPTION_EFFECT = ModConfigs.COMMON_UPGRADE_MODULE_SPEED_4_ENERGY_CONSUMPTION_EFFECT.getValue();
    private static final double SPEED_5_EFFECT = ModConfigs.COMMON_UPGRADE_MODULE_SPEED_5_EFFECT.getValue();
    private static final double SPEED_5_ENERGY_CONSUMPTION_EFFECT = ModConfigs.COMMON_UPGRADE_MODULE_SPEED_5_ENERGY_CONSUMPTION_EFFECT.getValue();

    public SpeedUpgradeModuleItem(class_1792.class_1793 props, int tier) {
        super(props, UpgradeModuleModifier.SPEED, tier);
    }

    @Override
    @NotNull
    public @NotNull UpgradeModuleModifier @NotNull [] getUpgradeModuleModifiers() {
        return UPGRADE_MODULE_MODIFIERS;
    }

    @Override
    public double getUpgradeModuleModifierValue(UpgradeModuleModifier modifier) {
        return switch (modifier) {
            case UpgradeModuleModifier.SPEED -> {
                switch (this.tier) {
                    case 1: {
                        yield SPEED_1_EFFECT;
                    }
                    case 2: {
                        yield SPEED_2_EFFECT;
                    }
                    case 3: {
                        yield SPEED_3_EFFECT;
                    }
                    case 4: {
                        yield SPEED_4_EFFECT;
                    }
                    case 5: {
                        yield SPEED_5_EFFECT;
                    }
                }
                yield -1.0;
            }
            case UpgradeModuleModifier.ENERGY_CONSUMPTION -> {
                switch (this.tier) {
                    case 1: {
                        yield SPEED_1_ENERGY_CONSUMPTION_EFFECT;
                    }
                    case 2: {
                        yield SPEED_2_ENERGY_CONSUMPTION_EFFECT;
                    }
                    case 3: {
                        yield SPEED_3_ENERGY_CONSUMPTION_EFFECT;
                    }
                    case 4: {
                        yield SPEED_4_ENERGY_CONSUMPTION_EFFECT;
                    }
                    case 5: {
                        yield SPEED_5_ENERGY_CONSUMPTION_EFFECT;
                    }
                }
                yield -1.0;
            }
            default -> -1.0;
        };
    }

    @Override
    public class_2561 getUpgradeModuleModifierText(UpgradeModuleModifier modifier, double value) {
        return switch (modifier) {
            case UpgradeModuleModifier.SPEED -> class_2561.method_43470((String)String.format(Locale.US, "\u2022 %.2f", value)).method_27692(class_124.field_1060);
            case UpgradeModuleModifier.ENERGY_CONSUMPTION -> class_2561.method_43470((String)String.format(Locale.US, "%+.2f %%", 100.0 * value - 100.0)).method_27692(class_124.field_1061);
            default -> class_2561.method_43473();
        };
    }
}

