/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.loading;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import me.jddev0.ep.screen.EnergizedPowerBookScreen;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_7654;
import net.minecraft.class_8824;
import org.slf4j.Logger;

@Environment(value=EnvType.CLIENT)
public class EnergizedPowerBookReloadListener
extends class_4309<JsonElement>
implements class_3302 {
    private static final Logger LOGGER = LogUtils.getLogger();

    public EnergizedPowerBookReloadListener() {
        super((Codec)new Codec<JsonElement>(){

            public <T> DataResult<Pair<JsonElement, T>> decode(DynamicOps<T> ops, T input) {
                return DataResult.success((Object)Pair.of((Object)((JsonElement)ops.convertTo((DynamicOps)JsonOps.INSTANCE, input)), input));
            }

            public <T> DataResult<T> encode(JsonElement input, DynamicOps<T> ops, T prefix) {
                return DataResult.error(() -> "Not implemented");
            }
        }, class_7654.method_45114((String)"book_pages"));
    }

    protected void apply(Map<class_2960, JsonElement> elements, class_3300 resourceManager, class_3695 profilerFiller) {
        ArrayList<EnergizedPowerBookScreen.PageContent> pages = new ArrayList<EnergizedPowerBookScreen.PageContent>();
        List<Map.Entry> elementEntries = elements.entrySet().stream().sorted(Comparator.comparing(o -> ((class_2960)o.getKey()).method_12832())).toList();
        block4: for (Map.Entry elementEntry : elementEntries) {
            class_2960 pageId = (class_2960)elementEntry.getKey();
            JsonElement element = (JsonElement)elementEntry.getValue();
            try {
                if (!element.isJsonObject()) {
                    LOGGER.error(String.format("Failed to load energized power book page '%s' from data pack '%s': Element must be a JSON Object", pageId.method_12832(), pageId.method_12836()));
                    continue;
                }
                JsonObject object = element.getAsJsonObject();
                if (object.has("remove")) {
                    JsonElement pageToRemoveElement = object.get("remove");
                    if (!pageToRemoveElement.isJsonPrimitive() || !pageToRemoveElement.getAsJsonPrimitive().isString()) {
                        LOGGER.error(String.format("Failed to load energized power book page '%s' from data pack '%s': remove must be a string primitive", pageId.method_12832(), pageId.method_12836()));
                        continue;
                    }
                    class_2960 pageToRemove = class_2960.method_12829((String)pageToRemoveElement.getAsJsonPrimitive().getAsString());
                    if (pageToRemove == null) continue;
                    boolean containsKeyFlag = false;
                    for (int i = pages.size() - 1; i >= 0; --i) {
                        if (!((EnergizedPowerBookScreen.PageContent)pages.get(i)).getPageId().equals((Object)pageToRemove)) continue;
                        containsKeyFlag = true;
                        pages.remove(i);
                        break;
                    }
                    if (containsKeyFlag) continue;
                    LOGGER.error(String.format("Failed to load energized power book page '%s' from data pack '%s': page to be removed was not found", pageId.method_12832(), pageId.method_12836()));
                    continue;
                }
                class_2561 chapterTitleComponent = null;
                if (object.has("title")) {
                    chapterTitleComponent = class_8824.field_46597.stable().decode((DynamicOps)JsonOps.INSTANCE, (Object)object.get("title")).result().map(Pair::getFirst).orElse(null);
                }
                class_2561 contentComponent = null;
                if (object.has("content")) {
                    contentComponent = class_8824.field_46597.stable().decode((DynamicOps)JsonOps.INSTANCE, (Object)object.get("content")).result().map(Pair::getFirst).orElse(null);
                }
                class_2960[] imageResourceLocations = null;
                if (object.has("image")) {
                    JsonElement imageElement = object.get("image");
                    if (imageElement.isJsonPrimitive()) {
                        if (!imageElement.getAsJsonPrimitive().isString()) {
                            LOGGER.error(String.format("Failed to load energized power book page '%s' from data pack '%s': image must be a string primitive or an array of string primitives", pageId.method_12832(), pageId.method_12836()));
                            continue;
                        }
                        imageResourceLocations = new class_2960[]{class_2960.method_12829((String)imageElement.getAsJsonPrimitive().getAsString())};
                    } else if (imageElement.isJsonArray()) {
                        JsonArray imageJsonArray = imageElement.getAsJsonArray();
                        if (imageJsonArray.isEmpty()) {
                            LOGGER.error(String.format("Failed to load energized power book page '%s' from data pack '%s': Image array must contain at least one element", pageId.method_12832(), pageId.method_12836()));
                            continue;
                        }
                        ArrayList<class_2960> imageResourceLocationList = new ArrayList<class_2960>(imageJsonArray.size());
                        for (Iterator imageJsonEle : imageJsonArray) {
                            if (!imageJsonEle.isJsonPrimitive() || !imageJsonEle.getAsJsonPrimitive().isString()) {
                                LOGGER.error(String.format("Failed to load energized power book page '%s' from data pack '%s': image must be a string primitive or an array of string primitives", pageId.method_12832(), pageId.method_12836()));
                                continue block4;
                            }
                            imageResourceLocationList.add(class_2960.method_12829((String)imageJsonEle.getAsJsonPrimitive().getAsString()));
                        }
                        imageResourceLocations = imageResourceLocationList.toArray(new class_2960[0]);
                    } else {
                        LOGGER.error(String.format("Failed to load energized power book page '%s' from data pack '%s': image must be a string primitive or an array of string primitives", pageId.method_12832(), pageId.method_12836()));
                        continue;
                    }
                }
                class_2960[] blockResourceLocations = null;
                if (object.has("block")) {
                    JsonElement blockElement = object.get("block");
                    if (blockElement.isJsonPrimitive()) {
                        if (!blockElement.getAsJsonPrimitive().isString()) {
                            LOGGER.error(String.format("Failed to load energized power book page '%s' from data pack '%s': block must be a string primitive or an array of string primitives", pageId.method_12832(), pageId.method_12836()));
                            continue;
                        }
                        blockResourceLocations = new class_2960[]{class_2960.method_12829((String)blockElement.getAsJsonPrimitive().getAsString())};
                    } else if (blockElement.isJsonArray()) {
                        Iterator imageJsonEle;
                        JsonArray blockJsonArray = blockElement.getAsJsonArray();
                        if (blockJsonArray.isEmpty()) {
                            LOGGER.error(String.format("Failed to load energized power book page '%s' from data pack '%s': Block array must contain at least one element", pageId.method_12832(), pageId.method_12836()));
                            continue;
                        }
                        ArrayList<class_2960> blockResourceLocationsList = new ArrayList<class_2960>(blockJsonArray.size());
                        imageJsonEle = blockJsonArray.iterator();
                        while (imageJsonEle.hasNext()) {
                            JsonElement blockJsonEle = (JsonElement)imageJsonEle.next();
                            if (!blockJsonEle.isJsonPrimitive() || !blockJsonEle.getAsJsonPrimitive().isString()) {
                                LOGGER.error(String.format("Failed to load energized power book page '%s' from data pack '%s': block must be a string primitive or an array of string primitives", pageId.method_12832(), pageId.method_12836()));
                                continue block4;
                            }
                            blockResourceLocationsList.add(class_2960.method_12829((String)blockJsonEle.getAsJsonPrimitive().getAsString()));
                        }
                        blockResourceLocations = blockResourceLocationsList.toArray(new class_2960[0]);
                    } else {
                        LOGGER.error(String.format("Failed to load energized power book page '%s' from data pack '%s': block must be a string primitive or an array of string primitives", pageId.method_12832(), pageId.method_12836()));
                        continue;
                    }
                }
                HashMap<Integer, class_2960> changePageIntToId = null;
                if (object.has("changePageIntToId")) {
                    JsonElement changePageIntToIdElement = object.get("changePageIntToId");
                    if (changePageIntToIdElement.isJsonObject()) {
                        JsonObject changePageIntToIdObject = changePageIntToIdElement.getAsJsonObject();
                        changePageIntToId = new HashMap<Integer, class_2960>();
                        Map changePageIntToIdJsonMap = changePageIntToIdObject.asMap();
                        for (Map.Entry changePageIntToIdEntry : changePageIntToIdJsonMap.entrySet()) {
                            int pageNum;
                            String jsonKey = (String)changePageIntToIdEntry.getKey();
                            JsonElement jsonValue = (JsonElement)changePageIntToIdEntry.getValue();
                            try {
                                pageNum = Integer.parseInt(jsonKey);
                            }
                            catch (NumberFormatException e) {
                                LOGGER.error(String.format("Failed to load energized power book page '%s' from data pack '%s': changePageIntoToId must be a map from int to string", pageId.method_12832(), pageId.method_12836()));
                                continue;
                            }
                            if (jsonValue.isJsonPrimitive() && jsonValue.getAsJsonPrimitive().isString()) {
                                changePageIntToId.put(pageNum, class_2960.method_12829((String)jsonValue.getAsJsonPrimitive().getAsString()));
                                continue;
                            }
                            LOGGER.error(String.format("Failed to load energized power book page '%s' from data pack '%s': changePageIntoToId must be a map from int to string", pageId.method_12832(), pageId.method_12836()));
                        }
                    } else {
                        LOGGER.error(String.format("Failed to load energized power book page '%s' from data pack '%s': changePageIntoToId must be a map from int to string", pageId.method_12832(), pageId.method_12836()));
                        continue;
                    }
                }
                pages.add(new EnergizedPowerBookScreen.PageContent(pageId, chapterTitleComponent, contentComponent, imageResourceLocations, blockResourceLocations, changePageIntToId));
            }
            catch (Exception e) {
                LOGGER.error(String.format("Failed to load energized power book page '%s' from data pack '%s'", pageId.method_12832(), pageId.method_12836()), (Throwable)e);
            }
        }
        EnergizedPowerBookScreen.setPages(pages);
    }
}

