/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.codec.ArrayCodec;
import me.jddev0.ep.codec.CodecFix;
import me.jddev0.ep.recipe.EPRecipes;
import me.jddev0.ep.recipe.EnergizedPowerBaseRecipe;
import me.jddev0.ep.recipe.IngredientWithCount;
import me.jddev0.ep.recipe.OutputItemStackWithPercentages;
import net.minecraft.class_10355;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9695;
import net.minecraft.class_9887;

public class AlloyFurnaceRecipe
implements EnergizedPowerBaseRecipe<class_9695> {
    private final class_1799 output;
    private final OutputItemStackWithPercentages secondaryOutput;
    private final IngredientWithCount[] inputs;
    private final int ticks;

    public AlloyFurnaceRecipe(class_1799 output, OutputItemStackWithPercentages secondaryOutput, IngredientWithCount[] inputs, int ticks) {
        this.output = output;
        this.secondaryOutput = secondaryOutput;
        this.inputs = inputs;
        this.ticks = ticks;
    }

    public class_1799 getOutput() {
        return this.output;
    }

    public OutputItemStackWithPercentages getSecondaryOutput() {
        return this.secondaryOutput;
    }

    public IngredientWithCount[] getInputs() {
        return this.inputs;
    }

    public int getTicks() {
        return this.ticks;
    }

    public class_1799[] getMaxOutputCounts() {
        class_1799[] generatedOutputs = new class_1799[]{this.output.method_46651(this.output.method_7947()), this.secondaryOutput.output().method_46651(this.secondaryOutput.percentages().length)};
        return generatedOutputs;
    }

    public class_1799[] generateOutputs(class_5819 randomSource) {
        class_1799[] generatedOutputs = new class_1799[2];
        generatedOutputs[0] = this.output.method_46651(this.output.method_7947());
        int count = 0;
        for (double percentage : this.secondaryOutput.percentages()) {
            if (!(randomSource.method_43058() <= percentage)) continue;
            ++count;
        }
        generatedOutputs[1] = this.secondaryOutput.output().method_46651(count);
        return generatedOutputs;
    }

    public boolean method_8115(class_9695 container, class_1937 level) {
        if (level.method_8608()) {
            return false;
        }
        boolean[] usedIndices = new boolean[3];
        for (int i = 0; i < 3; ++i) {
            usedIndices[i] = container.method_59984(i).method_7960();
        }
        int len = Math.min(this.inputs.length, 3);
        for (int i = 0; i < len; ++i) {
            IngredientWithCount input = this.inputs[i];
            int indexMinCount = -1;
            int minCount = Integer.MAX_VALUE;
            for (int j = 0; j < 3; ++j) {
                if (usedIndices[j]) continue;
                class_1799 item = container.method_59984(j);
                if (indexMinCount != -1 && item.method_7947() >= minCount || !input.input().method_8093(item) || item.method_7947() < input.count()) continue;
                indexMinCount = j;
                minCount = item.method_7947();
            }
            if (indexMinCount == -1) {
                return false;
            }
            usedIndices[indexMinCount] = true;
        }
        for (boolean usedIndex : usedIndices) {
            if (usedIndex) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_8116(class_9695 container, class_7225.class_7874 registries) {
        return this.output;
    }

    public class_9887 method_61671() {
        return class_9887.field_52597;
    }

    public boolean method_8118() {
        return true;
    }

    public class_10355 method_64668() {
        return EPRecipes.ALLOY_FURNACE_CATEGORY;
    }

    public class_1865<? extends class_1860<class_9695>> method_8119() {
        return Serializer.INSTANCE;
    }

    public class_3956<? extends class_1860<class_9695>> method_17716() {
        return Type.INSTANCE;
    }

    @Override
    public List<class_1856> getIngredients() {
        return Arrays.stream(this.inputs).map(IngredientWithCount::input).toList();
    }

    @Override
    public boolean isIngredient(class_1799 itemStack) {
        return Arrays.stream(this.inputs).map(IngredientWithCount::input).anyMatch(ingredient -> ingredient.method_8093(itemStack));
    }

    @Override
    public boolean isResult(class_1799 itemStack) {
        return class_1799.method_31577((class_1799)this.output, (class_1799)itemStack) || this.secondaryOutput != null && class_1799.method_31577((class_1799)this.secondaryOutput.output(), (class_1799)itemStack);
    }

    public static final class Serializer
    implements class_1865<AlloyFurnaceRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final class_2960 ID = EPAPI.id("alloy_furnace");
        private final MapCodec<AlloyFurnaceRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CodecFix.ITEM_STACK_CODEC.fieldOf("result").forGetter(recipe -> recipe.output), (App)OutputItemStackWithPercentages.CODEC_NONEMPTY.optionalFieldOf("secondaryResult").forGetter(recipe -> Optional.ofNullable(recipe.secondaryOutput.isEmpty() ? null : recipe.secondaryOutput)), (App)new ArrayCodec<IngredientWithCount>(IngredientWithCount.CODEC, IngredientWithCount[]::new).fieldOf("ingredients").forGetter(recipe -> recipe.inputs), (App)class_5699.field_33442.fieldOf("ticks").forGetter(recipe -> recipe.ticks)).apply((Applicative)instance, (output, secondaryOutput, inputs, ticks) -> new AlloyFurnaceRecipe((class_1799)output, secondaryOutput.orElse(OutputItemStackWithPercentages.EMPTY), (IngredientWithCount[])inputs, (int)ticks)));
        private final class_9139<class_9129, AlloyFurnaceRecipe> PACKET_CODEC = class_9139.method_56437(Serializer::write, Serializer::read);

        private Serializer() {
        }

        public MapCodec<AlloyFurnaceRecipe> method_53736() {
            return this.CODEC;
        }

        public class_9139<class_9129, AlloyFurnaceRecipe> method_56104() {
            return this.PACKET_CODEC;
        }

        private static AlloyFurnaceRecipe read(class_9129 buffer) {
            int len = buffer.readInt();
            IngredientWithCount[] inputs = new IngredientWithCount[len];
            for (int i = 0; i < len; ++i) {
                inputs[i] = (IngredientWithCount)IngredientWithCount.STREAM_CODEC.decode((Object)buffer);
            }
            int ticks = buffer.readInt();
            class_1799 output = (class_1799)class_1799.field_49268.decode((Object)buffer);
            OutputItemStackWithPercentages secondaryOutput = (OutputItemStackWithPercentages)OutputItemStackWithPercentages.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
            return new AlloyFurnaceRecipe(output, secondaryOutput, inputs, ticks);
        }

        private static void write(class_9129 buffer, AlloyFurnaceRecipe recipe) {
            buffer.method_53002(recipe.inputs.length);
            for (int i = 0; i < recipe.inputs.length; ++i) {
                IngredientWithCount.STREAM_CODEC.encode((Object)buffer, (Object)recipe.inputs[i]);
            }
            buffer.method_53002(recipe.ticks);
            class_1799.field_49268.encode((Object)buffer, (Object)recipe.output);
            OutputItemStackWithPercentages.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)recipe.secondaryOutput);
        }
    }

    public static final class Type
    implements class_3956<AlloyFurnaceRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "alloy_furnace";

        private Type() {
        }
    }
}

