/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.codec.CodecFix;
import me.jddev0.ep.recipe.EPRecipes;
import me.jddev0.ep.recipe.EnergizedPowerBaseRecipe;
import net.minecraft.class_10355;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9695;
import net.minecraft.class_9887;

public class PulverizerRecipe
implements EnergizedPowerBaseRecipe<class_9695> {
    private final OutputItemStackWithPercentages output;
    private final OutputItemStackWithPercentages secondaryOutput;
    private final class_1856 input;

    public PulverizerRecipe(OutputItemStackWithPercentages output, OutputItemStackWithPercentages secondaryOutput, class_1856 input) {
        this.output = output;
        this.secondaryOutput = secondaryOutput;
        this.input = input;
    }

    public OutputItemStackWithPercentages getOutput() {
        return this.output;
    }

    public OutputItemStackWithPercentages getSecondaryOutput() {
        return this.secondaryOutput;
    }

    public class_1856 getInput() {
        return this.input;
    }

    public class_1799[] getMaxOutputCounts(boolean advanced) {
        class_1799[] generatedOutputs = new class_1799[]{this.output.output.method_46651(advanced ? this.output.percentagesAdvanced.length : this.output.percentages.length), this.secondaryOutput.output.method_46651(advanced ? this.secondaryOutput.percentagesAdvanced.length : this.secondaryOutput.percentages.length)};
        return generatedOutputs;
    }

    public class_1799[] generateOutputs(class_5819 randomSource, boolean advanced) {
        class_1799[] generatedOutputs = new class_1799[2];
        for (int i = 0; i < 2; ++i) {
            int count = 0;
            OutputItemStackWithPercentages output = i == 0 ? this.output : this.secondaryOutput;
            for (double percentage : advanced ? output.percentagesAdvanced : output.percentages) {
                if (!(randomSource.method_43058() <= percentage)) continue;
                ++count;
            }
            generatedOutputs[i] = output.output.method_46651(count);
        }
        return generatedOutputs;
    }

    public boolean method_8115(class_9695 container, class_1937 level) {
        if (level.method_8608()) {
            return false;
        }
        return this.input.method_8093(container.method_59984(0));
    }

    public class_1799 method_8116(class_9695 container, class_7225.class_7874 registries) {
        return class_1799.field_8037;
    }

    public class_9887 method_61671() {
        return class_9887.field_52597;
    }

    public boolean method_8118() {
        return true;
    }

    public class_10355 method_64668() {
        return EPRecipes.PULVERIZER_CATEGORY;
    }

    public class_1865<? extends class_1860<class_9695>> method_8119() {
        return Serializer.INSTANCE;
    }

    public class_3956<? extends class_1860<class_9695>> method_17716() {
        return Type.INSTANCE;
    }

    @Override
    public List<class_1856> getIngredients() {
        return List.of(this.input);
    }

    @Override
    public boolean isIngredient(class_1799 itemStack) {
        return this.input.method_8093(itemStack);
    }

    @Override
    public boolean isResult(class_1799 itemStack) {
        return class_1799.method_31577((class_1799)this.output.output(), (class_1799)itemStack) || this.secondaryOutput != null && class_1799.method_31577((class_1799)this.secondaryOutput.output(), (class_1799)itemStack);
    }

    public record OutputItemStackWithPercentages(class_1799 output, double[] percentages, double[] percentagesAdvanced) {
        public OutputItemStackWithPercentages(class_1799 output, double percentage, double percentageAdvanced) {
            this(output, new double[]{percentage}, new double[]{percentageAdvanced});
        }

        public OutputItemStackWithPercentages(class_1799 output) {
            this(output, 1.0, 1.0);
        }

        private static Codec<double[]> createDoubleArrayCodec(final boolean atLeastOnePercentageValue) {
            return new Codec<double[]>(){
                private static final Codec<List<Double>> DOUBLE_LIST_CODEC = Codec.doubleRange((double)0.0, (double)1.0).listOf();

                public <T> DataResult<Pair<double[], T>> decode(DynamicOps<T> ops, T input) {
                    return DOUBLE_LIST_CODEC.decode(ops, input).flatMap(res -> {
                        boolean errorFlag = atLeastOnePercentageValue && ((List)res.getFirst()).stream().noneMatch(d -> (int)d.doubleValue() >= 1);
                        Pair newRes = Pair.of((Object)((List)res.getFirst()).stream().mapToDouble(Double::doubleValue).toArray(), (Object)res.getSecond());
                        if (errorFlag) {
                            return DataResult.error(() -> "The primary output must have a minimum count of at least 1 (At least one percentage value must be >= 1.0)", (Object)newRes);
                        }
                        return DataResult.success((Object)newRes);
                    });
                }

                public <T> DataResult<T> encode(double[] input, DynamicOps<T> ops, T prefix) {
                    return DOUBLE_LIST_CODEC.encode(Arrays.stream(input).boxed().toList(), ops, prefix);
                }
            };
        }

        public static Codec<OutputItemStackWithPercentages> createCodec(boolean atLeastOnePercentageValue) {
            return RecordCodecBuilder.create(instance -> instance.group((App)CodecFix.ITEM_STACK_CODEC.fieldOf("result").forGetter(output -> output.output), (App)OutputItemStackWithPercentages.createDoubleArrayCodec(atLeastOnePercentageValue).fieldOf("percentages").forGetter(output -> output.percentages), (App)OutputItemStackWithPercentages.createDoubleArrayCodec(atLeastOnePercentageValue).optionalFieldOf("percentagesAdvanced").forGetter(output -> Optional.of(output.percentagesAdvanced))).apply((Applicative)instance, (output, percentages, percentagesAdvanced) -> {
                if (percentagesAdvanced.isPresent()) {
                    return new OutputItemStackWithPercentages((class_1799)output, (double[])percentages, (double[])percentagesAdvanced.get());
                }
                return new OutputItemStackWithPercentages((class_1799)output, (double[])percentages, (double[])percentages);
            }));
        }
    }

    public static final class Serializer
    implements class_1865<PulverizerRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final class_2960 ID = EPAPI.id("pulverizer");
        private final MapCodec<PulverizerRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)OutputItemStackWithPercentages.createCodec(true).fieldOf("result").forGetter(recipe -> recipe.output), (App)OutputItemStackWithPercentages.createCodec(false).optionalFieldOf("secondaryResult").forGetter(recipe -> {
            if (recipe.secondaryOutput.output.method_7960() || recipe.secondaryOutput.percentages.length == 0) {
                return Optional.empty();
            }
            return Optional.of(recipe.secondaryOutput);
        }), (App)class_1856.field_46095.fieldOf("ingredient").forGetter(recipe -> recipe.input)).apply((Applicative)instance, (output, secondaryOutput, input) -> new PulverizerRecipe((OutputItemStackWithPercentages)output, secondaryOutput.orElse(new OutputItemStackWithPercentages(class_1799.field_8037, new double[0], new double[0])), (class_1856)input)));
        private final class_9139<class_9129, PulverizerRecipe> PACKET_CODEC = class_9139.method_56437(Serializer::write, Serializer::read);

        private Serializer() {
        }

        public MapCodec<PulverizerRecipe> method_53736() {
            return this.CODEC;
        }

        public class_9139<class_9129, PulverizerRecipe> method_56104() {
            return this.PACKET_CODEC;
        }

        private static PulverizerRecipe read(class_9129 buffer) {
            class_1856 input = (class_1856)class_1856.field_48355.decode((Object)buffer);
            OutputItemStackWithPercentages[] outputs = new OutputItemStackWithPercentages[2];
            for (int i = 0; i < 2; ++i) {
                class_1799 output = (class_1799)class_1799.field_49268.decode((Object)buffer);
                int percentageCount = buffer.readInt();
                double[] percentages = new double[percentageCount];
                for (int j = 0; j < percentageCount; ++j) {
                    percentages[j] = buffer.readDouble();
                }
                int percentageAdvancedCount = buffer.readInt();
                double[] percentagesAdvanced = new double[percentageAdvancedCount];
                for (int j = 0; j < percentageAdvancedCount; ++j) {
                    percentagesAdvanced[j] = buffer.readDouble();
                }
                outputs[i] = new OutputItemStackWithPercentages(output, percentages, percentagesAdvanced);
            }
            return new PulverizerRecipe(outputs[0], outputs[1], input);
        }

        private static void write(class_9129 buffer, PulverizerRecipe recipe) {
            class_1856.field_48355.encode((Object)buffer, (Object)recipe.input);
            for (int i = 0; i < 2; ++i) {
                OutputItemStackWithPercentages output = i == 0 ? recipe.output : recipe.secondaryOutput;
                class_1799.field_49268.encode((Object)buffer, (Object)output.output);
                buffer.method_53002(output.percentages.length);
                for (double percentage : output.percentages) {
                    buffer.method_52940(percentage);
                }
                buffer.method_53002(output.percentagesAdvanced.length);
                for (double percentage : output.percentagesAdvanced) {
                    buffer.method_52940(percentage);
                }
            }
        }
    }

    public static final class Type
    implements class_3956<PulverizerRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "pulverizer";

        private Type() {
        }
    }
}

