/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen;

import java.util.ArrayList;
import java.util.Optional;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.entity.FluidTransposerBlockEntity;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.SetCheckboxC2SPacket;
import me.jddev0.ep.screen.FluidTransposerMenu;
import me.jddev0.ep.screen.base.ConfigurableUpgradableEnergyStorageContainerScreen;
import me.jddev0.ep.util.FluidUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public class FluidTransposerScreen
extends ConfigurableUpgradableEnergyStorageContainerScreen<FluidTransposerMenu> {
    public FluidTransposerScreen(FluidTransposerMenu menu, class_1661 inventory, class_2561 component) {
        super(menu, inventory, component, "tooltip.energizedpower.recipe.energy_required_to_finish.txt", EPAPI.id("textures/gui/container/fluid_transposer.png"), EPAPI.id("textures/gui/container/upgrade_view/1_speed_1_energy_efficiency_1_energy_capacity.png"));
    }

    @Override
    protected boolean mouseClickedNormalView(double mouseX, double mouseY, int mouseButton) {
        if (super.mouseClickedNormalView(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (mouseButton == 0 && this.method_2378(114, 47, 20, 20, mouseX, mouseY)) {
            ModMessages.sendClientPacketToServer(new SetCheckboxC2SPacket(((FluidTransposerBlockEntity)((FluidTransposerMenu)this.field_2797).getBlockEntity()).method_11016(), 0, ((FluidTransposerMenu)this.field_2797).getMode() == FluidTransposerBlockEntity.Mode.EMPTYING));
            return true;
        }
        return false;
    }

    @Override
    protected void renderBgNormalView(class_332 drawContext, float partialTick, int mouseX, int mouseY) {
        super.renderBgNormalView(drawContext, partialTick, mouseX, mouseY);
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        this.renderFluidMeterContent(drawContext, ((FluidTransposerMenu)this.field_2797).getFluid(), ((FluidTransposerMenu)this.field_2797).getTankCapacity(), x + 152, y + 17, 16, 52);
        this.renderFluidMeterOverlay(drawContext, x, y);
        this.renderButtons(drawContext, x, y, mouseX, mouseY);
        this.renderProgressArrow(drawContext, x, y);
    }

    private void renderFluidMeterOverlay(class_332 drawContext, int x, int y) {
        drawContext.method_25290(class_10799.field_56883, this.MACHINE_SPRITES_TEXTURE, x + 152, y + 17, 16.0f, 0.0f, 16, 52, 256, 256);
    }

    private void renderButtons(class_332 drawContext, int x, int y, int mouseX, int mouseY) {
        if (this.method_2378(114, 47, 20, 20, mouseX, mouseY)) {
            drawContext.method_25290(class_10799.field_56883, this.MACHINE_SPRITES_TEXTURE, x + 114, y + 47, 0.0f, 211.0f, 20, 20, 256, 256);
        }
        class_1799 output = new class_1799((class_1935)(((FluidTransposerMenu)this.field_2797).getMode() == FluidTransposerBlockEntity.Mode.EMPTYING ? class_1802.field_8550 : class_1802.field_8705));
        drawContext.method_51448().pushMatrix();
        drawContext.method_51428(output, x + 116, y + 49, 116 + 49 * this.field_2792);
        drawContext.method_51448().popMatrix();
    }

    private void renderProgressArrow(class_332 drawContext, int x, int y) {
        int arrowPosY = ((FluidTransposerMenu)this.field_2797).getMode() == FluidTransposerBlockEntity.Mode.EMPTYING ? 58 : 72;
        drawContext.method_25290(class_10799.field_56883, this.MACHINE_SPRITES_TEXTURE, x + 114, y + 19, 52.0f, (float)arrowPosY, 20, 14, 256, 256);
        if (((FluidTransposerMenu)this.field_2797).isCraftingActive()) {
            if (((FluidTransposerMenu)this.field_2797).getMode() == FluidTransposerBlockEntity.Mode.EMPTYING) {
                drawContext.method_25290(class_10799.field_56883, this.MACHINE_SPRITES_TEXTURE, x + 114, y + 19, 72.0f, (float)arrowPosY, ((FluidTransposerMenu)this.field_2797).getScaledProgressArrowSize(), 14, 256, 256);
            } else {
                drawContext.method_25290(class_10799.field_56883, this.MACHINE_SPRITES_TEXTURE, x + 134 - ((FluidTransposerMenu)this.field_2797).getScaledProgressArrowSize(), y + 19, (float)(92 - ((FluidTransposerMenu)this.field_2797).getScaledProgressArrowSize()), (float)arrowPosY, ((FluidTransposerMenu)this.field_2797).getScaledProgressArrowSize(), 14, 256, 256);
            }
        }
    }

    @Override
    protected void renderTooltipNormalView(class_332 drawContext, int mouseX, int mouseY) {
        ArrayList<class_5250> components;
        super.renderTooltipNormalView(drawContext, mouseX, mouseY);
        if (this.method_2378(152, 17, 16, 52, mouseX, mouseY)) {
            components = new ArrayList<class_5250>(2);
            boolean fluidEmpty = ((FluidTransposerMenu)this.field_2797).getFluid().isEmpty();
            long fluidAmount = fluidEmpty ? 0L : ((FluidTransposerMenu)this.field_2797).getFluid().getMilliBucketsAmount();
            class_5250 tooltipComponent = class_2561.method_43469((String)"tooltip.energizedpower.fluid_meter.content_amount.txt", (Object[])new Object[]{FluidUtils.getFluidAmountWithPrefix(fluidAmount), FluidUtils.getFluidAmountWithPrefix(FluidUtils.convertDropletsToMilliBuckets(((FluidTransposerMenu)this.field_2797).getTankCapacity()))});
            if (!fluidEmpty) {
                tooltipComponent = class_2561.method_43471((String)((FluidTransposerMenu)this.field_2797).getFluid().getTranslationKey()).method_27693(" ").method_10852((class_2561)tooltipComponent);
            }
            components.add(tooltipComponent);
            drawContext.method_64038(this.field_22793, components, Optional.empty(), mouseX, mouseY);
        }
        if (this.method_2378(114, 47, 20, 20, mouseX, mouseY)) {
            components = new ArrayList(2);
            components.add(class_2561.method_43471((String)("tooltip.energizedpower.fluid_transposer.mode." + ((FluidTransposerMenu)this.field_2797).getMode().method_15434())));
            drawContext.method_64038(this.field_22793, components, Optional.empty(), mouseX, mouseY);
        }
    }
}

