/*
 * Decompiled with CFR 0.152.
 */
package io.github.kingironman2011.orbital_railgun_enhanced.listener;

import io.github.kingironman2011.orbital_railgun_enhanced.config.ServerConfig;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayerAreaListener {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"OrbitalRailgunEnhanced");
    private static final Map<UUID, AreaState> playerStates = new ConcurrentHashMap<UUID, AreaState>();
    private static Consumer<AreaChangeEvent> areaChangeCallback = null;

    public static boolean isPlayerInRange(class_3222 player, double laserX, double laserZ) {
        double rangeSquared;
        double playerZ;
        double dz;
        double soundRange = ServerConfig.INSTANCE.getSoundRange();
        double playerX = player.method_23317();
        double dx = playerX - laserX;
        double distanceSquared = dx * dx + (dz = (playerZ = player.method_23321()) - laserZ) * dz;
        return distanceSquared <= (rangeSquared = soundRange * soundRange);
    }

    public static AreaCheckResult handlePlayerAreaCheck(class_3222 player, double laserX, double laserZ) {
        return PlayerAreaListener.handlePlayerAreaCheck(player, laserX, laserZ, System.currentTimeMillis());
    }

    public static AreaCheckResult handlePlayerAreaCheck(class_3222 player, double laserX, double laserZ, long fireTimestamp) {
        UUID playerId = player.method_5667();
        boolean currentlyInside = PlayerAreaListener.isPlayerInRange(player, laserX, laserZ);
        AreaState previousState = playerStates.get(playerId);
        boolean wasInside = previousState != null && previousState.isInside;
        boolean isNewLocation = previousState == null || previousState.lastLaserX != laserX || previousState.lastLaserZ != laserZ;
        long timestamp = isNewLocation ? fireTimestamp : previousState.fireTimestamp;
        playerStates.put(playerId, new AreaState(currentlyInside, laserX, laserZ, timestamp));
        AreaCheckResult result = new AreaCheckResult();
        result.isInside = currentlyInside;
        result.wasInside = wasInside;
        result.isNewLocation = isNewLocation;
        result.fireTimestamp = timestamp;
        if (ServerConfig.INSTANCE.isDebugMode()) {
            if (isNewLocation) {
                LOGGER.debug("[AREA] New laser location: ({}, {}) for player {} at time {}", new Object[]{laserX, laserZ, player.method_5477().getString(), timestamp});
            }
            if (!wasInside && currentlyInside) {
                long elapsedMs = System.currentTimeMillis() - timestamp;
                LOGGER.debug("[AREA] Player {} entered sound range at ({}, {}) - elapsed: {}ms", new Object[]{player.method_5477().getString(), laserX, laserZ, elapsedMs});
            } else if (wasInside && !currentlyInside) {
                LOGGER.debug("[AREA] Player {} left sound range at ({}, {})", new Object[]{player.method_5477().getString(), laserX, laserZ});
            }
        }
        return result;
    }

    public static void clearPlayerState(UUID playerId) {
        playerStates.remove(playerId);
    }

    public static void setAreaChangeCallback(Consumer<AreaChangeEvent> callback) {
        areaChangeCallback = callback;
    }

    public static void checkPlayerPosition(class_3222 player) {
        UUID playerId = player.method_5667();
        AreaState state = playerStates.get(playerId);
        if (state == null) {
            return;
        }
        boolean currentlyInside = PlayerAreaListener.isPlayerInRange(player, state.lastLaserX, state.lastLaserZ);
        if (state.isInside != currentlyInside) {
            if (ServerConfig.INSTANCE.isDebugMode()) {
                LOGGER.debug("[AREA] Player {} position changed relative to laser at ({}, {})", new Object[]{player.method_5477().getString(), state.lastLaserX, state.lastLaserZ});
            }
            AreaCheckResult result = PlayerAreaListener.handlePlayerAreaCheck(player, state.lastLaserX, state.lastLaserZ);
            if (areaChangeCallback != null && result.hasStateChanged()) {
                areaChangeCallback.accept(new AreaChangeEvent(player, result, state.lastLaserX, state.lastLaserZ));
            }
        }
    }

    public static class AreaCheckResult {
        public boolean isInside;
        public boolean wasInside;
        public boolean isNewLocation;
        public long fireTimestamp;

        public boolean hasEntered() {
            return this.isInside && !this.wasInside;
        }

        public boolean hasLeft() {
            return !this.isInside && this.wasInside;
        }

        public boolean hasStateChanged() {
            return this.hasEntered() || this.hasLeft();
        }
    }

    private static class AreaState {
        boolean isInside;
        double lastLaserX;
        double lastLaserZ;
        long fireTimestamp;

        AreaState(boolean isInside, double laserX, double laserZ, long fireTimestamp) {
            this.isInside = isInside;
            this.lastLaserX = laserX;
            this.lastLaserZ = laserZ;
            this.fireTimestamp = fireTimestamp;
        }
    }

    public record AreaChangeEvent(class_3222 player, AreaCheckResult result, double laserX, double laserZ) {
    }
}

