/*
 * Decompiled with CFR 0.152.
 */
package io.github.kingironman2011.orbital_railgun_enhanced.registry;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.github.kingironman2011.orbital_railgun_enhanced.OrbitalRailgun;
import io.github.kingironman2011.orbital_railgun_enhanced.config.ServerConfig;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;

public class CommandRegistry {
    private static int showHelp(CommandContext<class_2168> context) {
        ServerConfig config = ServerConfig.INSTANCE;
        if (config.isDebugMode()) {
            OrbitalRailgun.LOGGER.info("Displaying help to player: {}", (Object)((class_2168)context.getSource()).method_9214());
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.orbital_railgun_enhanced.help"), false);
        return 1;
    }

    public static void registerCommands() {
        ServerConfig.INSTANCE.loadConfig();
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"ore").requires(source -> source.method_9259(2))).executes(CommandRegistry::showHelp)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"debug").executes(CommandRegistry::showDebugMode)).then(class_2170.method_9244((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(context -> CommandRegistry.toggleDebugMode((CommandContext<class_2168>)context, BoolArgumentType.getBool((CommandContext)context, (String)"enabled")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"radius").executes(CommandRegistry::showRadiusValue)).then(class_2170.method_9244((String)"value", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(context -> CommandRegistry.setRadiusValue((CommandContext<class_2168>)context, DoubleArgumentType.getDouble((CommandContext)context, (String)"value")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"strikeDamage").executes(CommandRegistry::showStrikeDamage)).then(class_2170.method_9244((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(context -> CommandRegistry.setStrikeDamage((CommandContext<class_2168>)context, FloatArgumentType.getFloat((CommandContext)context, (String)"value")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"cooldown").executes(CommandRegistry::showCooldown)).then(class_2170.method_9244((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> CommandRegistry.setCooldown((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"ticks")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"maxStrikes").executes(CommandRegistry::showMaxStrikes)).then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> CommandRegistry.setMaxStrikes((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"value")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"particles").executes(CommandRegistry::showParticles)).then(class_2170.method_9244((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(context -> CommandRegistry.setParticles((CommandContext<class_2168>)context, BoolArgumentType.getBool((CommandContext)context, (String)"enabled")))))).then(class_2170.method_9247((String)"reload").executes(CommandRegistry::reloadConfig))).then(class_2170.method_9247((String)"help").executes(CommandRegistry::showHelp)));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"orbitalrailgun").requires(source -> source.method_9259(2))).executes(CommandRegistry::showHelp)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"debug").executes(CommandRegistry::showDebugMode)).then(class_2170.method_9244((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(context -> CommandRegistry.toggleDebugMode((CommandContext<class_2168>)context, BoolArgumentType.getBool((CommandContext)context, (String)"enabled")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"radius").executes(CommandRegistry::showRadiusValue)).then(class_2170.method_9244((String)"value", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(context -> CommandRegistry.setRadiusValue((CommandContext<class_2168>)context, DoubleArgumentType.getDouble((CommandContext)context, (String)"value")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"strikeDamage").executes(CommandRegistry::showStrikeDamage)).then(class_2170.method_9244((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(context -> CommandRegistry.setStrikeDamage((CommandContext<class_2168>)context, FloatArgumentType.getFloat((CommandContext)context, (String)"value")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"cooldown").executes(CommandRegistry::showCooldown)).then(class_2170.method_9244((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> CommandRegistry.setCooldown((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"ticks")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"maxStrikes").executes(CommandRegistry::showMaxStrikes)).then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> CommandRegistry.setMaxStrikes((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"value")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"particles").executes(CommandRegistry::showParticles)).then(class_2170.method_9244((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(context -> CommandRegistry.setParticles((CommandContext<class_2168>)context, BoolArgumentType.getBool((CommandContext)context, (String)"enabled")))))).then(class_2170.method_9247((String)"reload").executes(CommandRegistry::reloadConfig))).then(class_2170.method_9247((String)"help").executes(CommandRegistry::showHelp)));
        });
        OrbitalRailgun.LOGGER.info("Registered commands: /ore and /orbitalrailgun");
    }

    private static int toggleDebugMode(CommandContext<class_2168> context, boolean enabled) {
        ServerConfig.INSTANCE.setDebugMode(enabled);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.orbital_railgun_enhanced.debug.set", (Object[])new Object[]{enabled}), true);
        if (enabled) {
            OrbitalRailgun.LOGGER.info("Debug mode enabled by {}", (Object)((class_2168)context.getSource()).method_9214());
        } else {
            OrbitalRailgun.LOGGER.info("Debug mode disabled by {}", (Object)((class_2168)context.getSource()).method_9214());
        }
        return 1;
    }

    private static int setRadiusValue(CommandContext<class_2168> context, double radius) {
        ServerConfig.INSTANCE.setSoundRange(radius);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.orbital_railgun_enhanced.radius.set", (Object[])new Object[]{radius}), true);
        if (ServerConfig.INSTANCE.isDebugMode()) {
            OrbitalRailgun.LOGGER.info("Sound radius set to {} by {}", (Object)radius, (Object)((class_2168)context.getSource()).method_9214());
        }
        return 1;
    }

    private static int setStrikeDamage(CommandContext<class_2168> context, float damage) {
        ServerConfig.INSTANCE.setStrikeDamage(damage);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.orbital_railgun_enhanced.strikeDamage.set", (Object[])new Object[]{Float.valueOf(damage)}), true);
        if (ServerConfig.INSTANCE.isDebugMode()) {
            OrbitalRailgun.LOGGER.info("Strike damage set to {} by {}", (Object)Float.valueOf(damage), (Object)((class_2168)context.getSource()).method_9214());
        }
        return 1;
    }

    private static int setCooldown(CommandContext<class_2168> context, int ticks) {
        ServerConfig.INSTANCE.setCooldownTicks(ticks);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.orbital_railgun_enhanced.cooldown.set", (Object[])new Object[]{ticks}), true);
        if (ServerConfig.INSTANCE.isDebugMode()) {
            OrbitalRailgun.LOGGER.info("Cooldown set to {} ticks by {}", (Object)ticks, (Object)((class_2168)context.getSource()).method_9214());
        }
        return 1;
    }

    private static int setMaxStrikes(CommandContext<class_2168> context, int maxStrikes) {
        ServerConfig.INSTANCE.setMaxActiveStrikes(maxStrikes);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.orbital_railgun_enhanced.maxStrikes.set", (Object[])new Object[]{maxStrikes}), true);
        if (ServerConfig.INSTANCE.isDebugMode()) {
            OrbitalRailgun.LOGGER.info("Max active strikes set to {} by {}", (Object)maxStrikes, (Object)((class_2168)context.getSource()).method_9214());
        }
        return 1;
    }

    private static int setParticles(CommandContext<class_2168> context, boolean enabled) {
        ServerConfig.INSTANCE.setEnableParticles(enabled);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.orbital_railgun_enhanced.particles.set", (Object[])new Object[]{enabled}), true);
        if (ServerConfig.INSTANCE.isDebugMode()) {
            OrbitalRailgun.LOGGER.info("Particles {} by {}", (Object)(enabled ? "enabled" : "disabled"), (Object)((class_2168)context.getSource()).method_9214());
        }
        return 1;
    }

    private static int reloadConfig(CommandContext<class_2168> context) {
        ServerConfig.INSTANCE.loadConfig();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.orbital_railgun_enhanced.config.reloaded"), true);
        OrbitalRailgun.LOGGER.info("Server configuration reloaded by {}", (Object)((class_2168)context.getSource()).method_9214());
        return 1;
    }

    private static int showDebugMode(CommandContext<class_2168> context) {
        boolean debugMode = ServerConfig.INSTANCE.isDebugMode();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.orbital_railgun_enhanced.debug.current", (Object[])new Object[]{debugMode}), false);
        return 1;
    }

    private static int showRadiusValue(CommandContext<class_2168> context) {
        double radius = ServerConfig.INSTANCE.getSoundRange();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.orbital_railgun_enhanced.radius.current", (Object[])new Object[]{radius}), false);
        return 1;
    }

    private static int showStrikeDamage(CommandContext<class_2168> context) {
        float damage = ServerConfig.INSTANCE.getStrikeDamage();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.orbital_railgun_enhanced.strikeDamage.current", (Object[])new Object[]{Float.valueOf(damage)}), false);
        return 1;
    }

    private static int showCooldown(CommandContext<class_2168> context) {
        int ticks = ServerConfig.INSTANCE.getCooldownTicks();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.orbital_railgun_enhanced.cooldown.current", (Object[])new Object[]{ticks}), false);
        return 1;
    }

    private static int showMaxStrikes(CommandContext<class_2168> context) {
        int maxStrikes = ServerConfig.INSTANCE.getMaxActiveStrikes();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.orbital_railgun_enhanced.maxStrikes.current", (Object[])new Object[]{maxStrikes}), false);
        return 1;
    }

    private static int showParticles(CommandContext<class_2168> context) {
        boolean enabled = ServerConfig.INSTANCE.isEnableParticles();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.orbital_railgun_enhanced.particles.current", (Object[])new Object[]{enabled}), false);
        return 1;
    }
}

