/*
 * Decompiled with CFR 0.152.
 */
package io.github.kingironman2011.orbital_railgun_enhanced.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.github.kingironman2011.orbital_railgun_enhanced.OrbitalRailgun;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class ServerConfig {
    private static final File CONFIG_FILE = new File("config/orbital-railgun-enhanced-server-config.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final ServerConfig INSTANCE = new ServerConfig();
    private boolean debugMode = false;
    private double soundRange = 500.0;
    private float strikeDamage = 20.0f;
    private int cooldownTicks = 100;
    private int maxActiveStrikes = 10;
    private boolean enableParticles = true;

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public double getSoundRange() {
        return this.soundRange;
    }

    public float getStrikeDamage() {
        return this.strikeDamage;
    }

    public int getCooldownTicks() {
        return this.cooldownTicks;
    }

    public int getMaxActiveStrikes() {
        return this.maxActiveStrikes;
    }

    public boolean isEnableParticles() {
        return this.enableParticles;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
        this.saveConfig();
        if (debugMode) {
            OrbitalRailgun.LOGGER.info("Debug mode enabled");
        } else {
            OrbitalRailgun.LOGGER.info("Debug mode disabled");
        }
    }

    public void setSoundRange(double soundRange) {
        this.soundRange = soundRange;
        this.saveConfig();
        if (this.isDebugMode()) {
            OrbitalRailgun.LOGGER.info("Sound range set to: {}", (Object)soundRange);
        }
    }

    public void setStrikeDamage(float strikeDamage) {
        this.strikeDamage = strikeDamage;
        this.saveConfig();
        if (this.isDebugMode()) {
            OrbitalRailgun.LOGGER.info("Strike damage set to: {}", (Object)Float.valueOf(strikeDamage));
        }
    }

    public void setCooldownTicks(int cooldownTicks) {
        this.cooldownTicks = cooldownTicks;
        this.saveConfig();
        if (this.isDebugMode()) {
            OrbitalRailgun.LOGGER.info("Cooldown ticks set to: {}", (Object)cooldownTicks);
        }
    }

    public void setMaxActiveStrikes(int maxActiveStrikes) {
        this.maxActiveStrikes = maxActiveStrikes;
        this.saveConfig();
        if (this.isDebugMode()) {
            OrbitalRailgun.LOGGER.info("Max active strikes set to: {}", (Object)maxActiveStrikes);
        }
    }

    public void setEnableParticles(boolean enableParticles) {
        this.enableParticles = enableParticles;
        this.saveConfig();
        if (this.isDebugMode()) {
            OrbitalRailgun.LOGGER.info("Particles enabled: {}", (Object)enableParticles);
        }
    }

    public void loadConfig() {
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                ServerConfig config = (ServerConfig)GSON.fromJson((Reader)reader, ServerConfig.class);
                if (config != null) {
                    this.debugMode = config.debugMode;
                    this.soundRange = config.soundRange;
                    this.strikeDamage = config.strikeDamage;
                    this.cooldownTicks = config.cooldownTicks;
                    this.maxActiveStrikes = config.maxActiveStrikes;
                    this.enableParticles = config.enableParticles;
                    OrbitalRailgun.LOGGER.info("Server configuration loaded from: {}", (Object)CONFIG_FILE.getAbsolutePath());
                } else {
                    OrbitalRailgun.LOGGER.warn("Config file parsed to null, using defaults: {}", (Object)CONFIG_FILE.getAbsolutePath());
                }
            }
            catch (IOException e) {
                OrbitalRailgun.LOGGER.error("Failed to load config: {}", (Object)e.getMessage());
            }
        } else {
            OrbitalRailgun.LOGGER.info("Config file not found, creating default configuration: {}", (Object)CONFIG_FILE.getAbsolutePath());
            this.saveConfig();
        }
    }

    private void saveConfig() {
        try {
            boolean created;
            File parentDir = CONFIG_FILE.getParentFile();
            if (!(parentDir == null || parentDir.exists() || (created = parentDir.mkdirs()) || parentDir.exists())) {
                OrbitalRailgun.LOGGER.warn("Could not create config directory: {}", (Object)parentDir.getAbsolutePath());
            }
            try (FileWriter writer = new FileWriter(CONFIG_FILE);){
                GSON.toJson((Object)this, (Appendable)writer);
                OrbitalRailgun.LOGGER.info("Server configuration saved to: {}", (Object)CONFIG_FILE.getAbsolutePath());
            }
        }
        catch (IOException e) {
            OrbitalRailgun.LOGGER.error("Failed to save config: {}", (Object)e.getMessage());
        }
    }
}

