/*
 * Decompiled with CFR 0.152.
 */
package io.github.kingironman2011.orbital_railgun_enhanced.util;

import io.github.kingironman2011.orbital_railgun_enhanced.config.ServerConfig;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3545;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import net.minecraft.server.MinecraftServer;
import org.joml.Vector2i;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrbitalRailgunStrikeManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"OrbitalRailgunEnhanced");
    public static ConcurrentHashMap<class_3545<class_2338, List<class_1297>>, class_3545<Integer, class_5321<class_1937>>> activeStrikes = new ConcurrentHashMap();
    private static final class_5321<class_8110> STRIKE_DAMAGE = class_5321.method_29179((class_5321)class_7924.field_42534, (class_2960)class_2960.method_43902((String)"orbital_railgun_enhanced", (String)"strike"));
    private static final int RADIUS = 24;
    private static final int RADIUS_SQUARED = 576;
    private static final Boolean[][] mask = new Boolean[49][49];

    public static void tick(MinecraftServer server) {
        activeStrikes.forEach((keyPair1, keyPair2) -> {
            float age = server.method_3780() - (Integer)keyPair2.method_15442();
            class_2338 blockPos = (class_2338)keyPair1.method_15442();
            List entities = (List)keyPair1.method_15441();
            class_5321 dimension = (class_5321)keyPair2.method_15441();
            if (age >= 700.0f) {
                activeStrikes.remove(keyPair1);
                class_3218 world = server.method_3847(dimension);
                if (ServerConfig.INSTANCE.isDebugMode()) {
                    LOGGER.debug("[STRIKE] Strike at {} reached impact age (700 ticks), executing damage", (Object)blockPos);
                }
                float strikeDamage = ServerConfig.INSTANCE.getStrikeDamage();
                entities.forEach(entity -> {
                    if (entity.method_37908().method_27983() == dimension && entity.method_19538().method_1020(blockPos.method_46558()).method_1027() <= 576.0) {
                        entity.method_5643(new class_1282((class_6880)world.method_30349().method_30530(class_7924.field_42534).method_40264(STRIKE_DAMAGE).get()), strikeDamage);
                        if (ServerConfig.INSTANCE.isDebugMode()) {
                            LOGGER.debug("[STRIKE] Damaged entity {} for {} damage", (Object)entity.method_5477().getString(), (Object)Float.valueOf(strikeDamage));
                        }
                    }
                });
                if (ServerConfig.INSTANCE.isDebugMode()) {
                    LOGGER.debug("[STRIKE] Exploding blocks at {}", (Object)blockPos);
                }
                OrbitalRailgunStrikeManager.explode(blockPos, (class_1937)world);
                if (ServerConfig.INSTANCE.isDebugMode()) {
                    LOGGER.info("[STRIKE] Strike at {} completed", (Object)blockPos);
                }
            } else if (age >= 400.0f) {
                if (ServerConfig.INSTANCE.isDebugMode() && age == 400.0f) {
                    LOGGER.debug("[STRIKE] Started pull effect for strike at {}", (Object)blockPos);
                }
                entities.forEach(entity -> {
                    class_1657 player;
                    if (entity instanceof class_1657 && (player = (class_1657)entity).method_7325()) {
                        return;
                    }
                    if (entity.method_37908().method_27983() == dimension) {
                        class_243 dir = blockPos.method_46558().method_1020(entity.method_19538());
                        double mag = Math.min(1.0 / Math.abs(dir.method_1033() - 20.0) * 4.0 * ((double)age - 400.0) / 300.0, 5.0);
                        dir = dir.method_1029();
                        entity.method_45319(dir.method_1021(mag));
                        entity.field_6037 = true;
                    }
                });
            }
        });
    }

    private static void explode(class_2338 origin, class_1937 world) {
        int blocksDestroyed = 0;
        for (int y = world.method_31607(); y <= world.method_31605(); ++y) {
            for (int x = -24; x <= 24; ++x) {
                for (int z = -24; z <= 24; ++z) {
                    if (!mask[x + 24][z + 24].booleanValue()) continue;
                    world.method_8501(new class_2338(origin.method_10263() + x, y, origin.method_10260() + z), class_2246.field_10124.method_9564());
                    ++blocksDestroyed;
                }
            }
        }
        if (ServerConfig.INSTANCE.isDebugMode()) {
            LOGGER.debug("[STRIKE] Destroyed {} blocks in explosion", (Object)blocksDestroyed);
        }
    }

    public static void initialize() {
        LOGGER.info("Initializing strike manager...");
        for (int x = -24; x <= 24; ++x) {
            for (int z = -24; z <= 24; ++z) {
                OrbitalRailgunStrikeManager.mask[x + 24][z + 24] = Vector2i.lengthSquared((int)x, (int)z) <= 576L;
            }
        }
        if (ServerConfig.INSTANCE.isDebugMode()) {
            LOGGER.debug("[STRIKE] Generated explosion mask with radius {}", (Object)24);
        }
    }
}

