/*
 * Decompiled with CFR 0.152.
 */
package io.github.kingironman2011.orbital_railgun_enhanced;

import io.github.kingironman2011.orbital_railgun_enhanced.config.ServerConfig;
import io.github.kingironman2011.orbital_railgun_enhanced.item.OrbitalRailgunItem;
import io.github.kingironman2011.orbital_railgun_enhanced.item.OrbitalRailgunItems;
import io.github.kingironman2011.orbital_railgun_enhanced.listener.PlayerAreaListener;
import io.github.kingironman2011.orbital_railgun_enhanced.logger.SoundLogger;
import io.github.kingironman2011.orbital_railgun_enhanced.registry.CommandRegistry;
import io.github.kingironman2011.orbital_railgun_enhanced.registry.SoundsRegistry;
import io.github.kingironman2011.orbital_railgun_enhanced.util.OrbitalRailgunStrikeManager;
import io.netty.buffer.Unpooled;
import java.util.List;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrbitalRailgun
implements ModInitializer {
    public static final String MOD_ID = "orbital_railgun_enhanced";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"orbital_railgun_enhanced");
    public static final class_2960 PLAY_SOUND_PACKET_ID = new class_2960("orbital_railgun_enhanced", "play_sound");
    public static final class_2960 STOP_AREA_SOUND_PACKET_ID = new class_2960("orbital_railgun_enhanced", "stop_area_sound");
    public static final class_2960 STOP_ANIMATION_PACKET_ID = new class_2960("orbital_railgun_enhanced", "stop_animation");
    public static final class_2960 SHOOT_PACKET_ID = class_2960.method_43902((String)"orbital_railgun_enhanced", (String)"shoot_packet");
    public static final class_2960 CLIENT_SYNC_PACKET_ID = class_2960.method_43902((String)"orbital_railgun_enhanced", (String)"client_sync_packet");
    public static final long RAILGUN_SOUND_DURATION_MS = 52992L;

    public void onInitialize() {
        LOGGER.info("Initializing Orbital Railgun Enhanced...");
        ServerConfig.INSTANCE.loadConfig();
        if (ServerConfig.INSTANCE.isDebugMode()) {
            LOGGER.info("[DEBUG] Debug mode is enabled");
        }
        SoundsRegistry.initialize();
        LOGGER.info("Sounds registry initialized");
        CommandRegistry.registerCommands();
        LOGGER.info("Commands registered: /ore and /orbitalrailgun");
        OrbitalRailgunItems.initialize();
        LOGGER.info("Items registered");
        OrbitalRailgunStrikeManager.initialize();
        LOGGER.info("Strike manager initialized");
        PlayerAreaListener.setAreaChangeCallback(event -> OrbitalRailgun.handleAreaStateChange(event.player(), event.result(), event.laserX(), event.laserZ()));
        if (ServerConfig.INSTANCE.isDebugMode()) {
            LOGGER.info("Registered player area change callback");
        }
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            PlayerAreaListener.clearPlayerState(handler.method_32311().method_5667());
            if (ServerConfig.INSTANCE.isDebugMode()) {
                LOGGER.info("[NETWORK] Cleared area state for disconnected player: {}", (Object)handler.method_32311().method_5477().getString());
            }
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PLAY_SOUND_PACKET_ID, (server, player, handler, buf, responseSender) -> {
            class_2960 soundId = buf.method_10810();
            class_3414 sound = (class_3414)class_7923.field_41172.method_10223(soundId);
            class_2338 blockPos = buf.method_10811();
            float volumeShoot = buf.readFloat();
            float pitchShoot = buf.readFloat();
            long fireTimestamp = System.currentTimeMillis();
            server.execute(() -> {
                if (sound == null) {
                    LOGGER.warn("[NETWORK] Received unknown sound id: {}", (Object)soundId.toString());
                    return;
                }
                double range = ServerConfig.INSTANCE.getSoundRange();
                double rangeSquared = range * range;
                double laserX = (double)blockPos.method_10263() + 0.5;
                double laserZ = (double)blockPos.method_10260() + 0.5;
                if (ServerConfig.INSTANCE.isDebugMode()) {
                    LOGGER.info("[NETWORK] Received PLAY_SOUND_PACKET from player: {}", (Object)player.method_5477().getString());
                    LOGGER.info("[NETWORK] Playing sound {} at BlockPos: {} with range: {} at time {}", new Object[]{soundId, blockPos, range, fireTimestamp});
                }
                server.method_3760().method_14571().forEach(nearbyPlayer -> {
                    double distanceSquared = nearbyPlayer.method_5649((double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.5, (double)blockPos.method_10260() + 0.5);
                    PlayerAreaListener.AreaCheckResult result = PlayerAreaListener.handlePlayerAreaCheck(nearbyPlayer, laserX, laserZ, fireTimestamp);
                    if (distanceSquared <= rangeSquared) {
                        if (result.isInside) {
                            nearbyPlayer.method_17356(sound, class_3419.field_15248, volumeShoot, pitchShoot);
                            SoundLogger.logSoundEvent(soundId.toString(), blockPos, range);
                            SoundLogger.logSoundPlayed(nearbyPlayer.method_5477().getString(), soundId.toString(), volumeShoot, pitchShoot);
                            if (ServerConfig.INSTANCE.isDebugMode()) {
                                LOGGER.info("[SOUND] Playing sound to player {} (distance: {})", (Object)nearbyPlayer.method_5477().getString(), (Object)Math.sqrt(distanceSquared));
                            }
                        }
                        OrbitalRailgun.handleAreaStateChange(nearbyPlayer, result, laserX, laserZ);
                    } else if (result.hasLeft()) {
                        OrbitalRailgun.handleAreaStateChange(nearbyPlayer, result, laserX, laserZ);
                    }
                });
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SHOOT_PACKET_ID, (server, player, handler, buf, responseSender) -> {
            OrbitalRailgunItem orbitalRailgun = (OrbitalRailgunItem)buf.method_10819().method_7909();
            class_2338 blockPos = buf.method_10811();
            if (ServerConfig.INSTANCE.isDebugMode()) {
                LOGGER.info("========================================");
                LOGGER.info("[NETWORK] SHOOT_PACKET received from player: {}", (Object)player.method_5477().getString());
                LOGGER.info("[STRIKE] Impact location: {}", (Object)blockPos);
            }
            server.execute(() -> {
                double laserX = (double)blockPos.method_10263() + 0.5;
                double laserZ = (double)blockPos.method_10260() + 0.5;
                orbitalRailgun.shoot((class_1657)player);
                if (ServerConfig.INSTANCE.isDebugMode()) {
                    LOGGER.info("[STRIKE] Orbital railgun fired at ({}, {})", (Object)laserX, (Object)laserZ);
                }
                double range = ServerConfig.INSTANCE.getSoundRange();
                List nearby = player.method_37908().method_8335(null, class_238.method_30048((class_243)blockPos.method_46558(), (double)range, (double)range, (double)range));
                OrbitalRailgunStrikeManager.activeStrikes.put((class_3545<class_2338, List<class_1297>>)new class_3545((Object)blockPos, (Object)nearby), (class_3545<Integer, class_5321<class_1937>>)new class_3545((Object)server.method_3780(), (Object)player.method_37908().method_27983()));
                if (ServerConfig.INSTANCE.isDebugMode()) {
                    LOGGER.info("[STRIKE] Registered strike with {} nearby entities within range {}", (Object)nearby.size(), (Object)range);
                }
                nearby.forEach(entity -> {
                    if (entity instanceof class_3222) {
                        class_3222 serverPlayer = (class_3222)entity;
                        if (PlayerAreaListener.isPlayerInRange(serverPlayer, laserX, laserZ)) {
                            ServerPlayNetworking.send((class_3222)serverPlayer, (class_2960)CLIENT_SYNC_PACKET_ID, (class_2540)PacketByteBufs.create().method_10807(blockPos));
                            if (ServerConfig.INSTANCE.isDebugMode()) {
                                LOGGER.debug("[NETWORK] Sent CLIENT_SYNC_PACKET to {} (within range {})", (Object)serverPlayer.method_5477().getString(), (Object)range);
                            }
                        } else if (ServerConfig.INSTANCE.isDebugMode()) {
                            LOGGER.debug("[NETWORK] Skipped CLIENT_SYNC_PACKET for {} (outside range {})", (Object)serverPlayer.method_5477().getString(), (Object)range);
                        }
                    }
                });
                int totalPlayers = server.method_3760().method_14571().size();
                if (ServerConfig.INSTANCE.isDebugMode()) {
                    LOGGER.info("[STRIKE] Checking {} players on server for range", (Object)totalPlayers);
                }
                server.method_3760().method_14571().forEach(serverPlayer -> {
                    PlayerAreaListener.AreaCheckResult result = PlayerAreaListener.handlePlayerAreaCheck(serverPlayer, laserX, laserZ);
                    OrbitalRailgun.handleAreaStateChange(serverPlayer, result, laserX, laserZ);
                });
                if (ServerConfig.INSTANCE.isDebugMode()) {
                    LOGGER.info("========================================");
                }
            });
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            if (server.method_3780() % 20 == 0) {
                server.method_3760().method_14571().forEach(PlayerAreaListener::checkPlayerPosition);
            }
        });
        ServerTickEvents.END_SERVER_TICK.register(OrbitalRailgunStrikeManager::tick);
        LOGGER.info("Orbital Railgun Enhanced initialization complete!");
    }

    private static void handleAreaStateChange(class_3222 player, PlayerAreaListener.AreaCheckResult result, double laserX, double laserZ) {
        if (result.hasEntered()) {
            long currentTime = System.currentTimeMillis();
            long elapsedMs = currentTime - result.fireTimestamp;
            if (ServerConfig.INSTANCE.isDebugMode()) {
                LOGGER.info("[AREA] Player {} entered sound range at ({}, {}) - elapsed: {}ms, duration: {}ms", new Object[]{player.method_5477().getString(), laserX, laserZ, elapsedMs, 52992L});
            }
            SoundLogger.logPlayerEnterRange(player.method_5477().getString(), Math.sqrt(player.method_5649(laserX, player.method_23318(), laserZ)));
            if (elapsedMs < 52992L) {
                OrbitalRailgun.playRailgunSoundToPlayer(player, laserX, laserZ, elapsedMs);
            } else if (ServerConfig.INSTANCE.isDebugMode()) {
                LOGGER.info("[AREA] Sound already ended ({}ms > {}ms) - not playing for player {}", new Object[]{elapsedMs, 52992L, player.method_5477().getString()});
            }
        } else if (result.hasLeft()) {
            if (ServerConfig.INSTANCE.isDebugMode()) {
                LOGGER.info("[AREA] Player {} left sound range at ({}, {}) - stopping sounds and animation", new Object[]{player.method_5477().getString(), laserX, laserZ});
            }
            SoundLogger.logPlayerExitRange(player.method_5477().getString());
            OrbitalRailgun.stopAreaSoundsForPlayer(player);
            OrbitalRailgun.stopAnimationForPlayer(player);
        } else if (result.isInside && ServerConfig.INSTANCE.isDebugMode()) {
            LOGGER.debug("[AREA] Player {} remains in sound range at ({}, {})", new Object[]{player.method_5477().getString(), laserX, laserZ});
        }
    }

    private static void playRailgunSoundToPlayer(class_3222 player, double laserX, double laserZ, long elapsedMs) {
        class_3414 shootSound = SoundsRegistry.RAILGUN_SHOOT;
        if (shootSound != null) {
            player.method_17356(shootSound, class_3419.field_15248, 1.0f, 1.0f);
            SoundLogger.logSoundPlayed(player.method_5477().getString(), SoundsRegistry.RAILGUN_SHOOT_ID.toString(), 1.0f, 1.0f);
            if (ServerConfig.INSTANCE.isDebugMode()) {
                LOGGER.info("[SOUND] Playing railgun shoot sound to player {} at ({}, {}) with {}ms offset", new Object[]{player.method_5477().getString(), laserX, laserZ, elapsedMs});
            }
        } else {
            LOGGER.warn("[SOUND] Railgun shoot sound not found in registry");
        }
    }

    private static void stopAreaSoundsForPlayer(class_3222 player) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10812(SoundsRegistry.RAILGUN_SHOOT_ID);
        ServerPlayNetworking.send((class_3222)player, (class_2960)STOP_AREA_SOUND_PACKET_ID, (class_2540)buf);
        SoundLogger.logSoundStopped(player.method_5477().getString(), SoundsRegistry.RAILGUN_SHOOT_ID.toString());
        if (ServerConfig.INSTANCE.isDebugMode()) {
            LOGGER.info("[NETWORK] Sent stop sound packet to player {}", (Object)player.method_5477().getString());
        }
    }

    private static void stopAnimationForPlayer(class_3222 player) {
        class_2540 buf = PacketByteBufs.create();
        ServerPlayNetworking.send((class_3222)player, (class_2960)STOP_ANIMATION_PACKET_ID, (class_2540)buf);
        if (ServerConfig.INSTANCE.isDebugMode()) {
            LOGGER.info("[NETWORK] Sent stop animation packet to player {}", (Object)player.method_5477().getString());
        }
    }
}

