/*
 * Decompiled with CFR 0.152.
 */
package io.github.kingironman2011.orbital_railgun_enhanced.logger;

import io.github.kingironman2011.orbital_railgun_enhanced.config.ServerConfig;
import net.minecraft.class_2338;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoundLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"OrbitalRailgunEnhanced");

    public static void logSoundEvent(String soundName, class_2338 location, double range) {
        if (ServerConfig.INSTANCE.isDebugMode()) {
            LOGGER.info("[SOUND] Event: {} | Location: {} | Range: {}", new Object[]{soundName, location, range});
        }
    }

    public static void logPlayerEnterRange(String playerName, double distance) {
        if (ServerConfig.INSTANCE.isDebugMode()) {
            LOGGER.info("[SOUND] Player {} entered sound range (distance: {})", (Object)playerName, (Object)distance);
        }
    }

    public static void logPlayerExitRange(String playerName) {
        if (ServerConfig.INSTANCE.isDebugMode()) {
            LOGGER.info("[SOUND] Player {} exited sound range", (Object)playerName);
        }
    }

    public static void logSoundPlayed(String playerName, String soundId, float volume, float pitch) {
        if (ServerConfig.INSTANCE.isDebugMode()) {
            LOGGER.info("[SOUND] Playing to {}: {} (volume: {}, pitch: {})", new Object[]{playerName, soundId, Float.valueOf(volume), Float.valueOf(pitch)});
        }
    }

    public static void logSoundStopped(String playerName, String soundId) {
        if (ServerConfig.INSTANCE.isDebugMode()) {
            LOGGER.info("[SOUND] Stopping for {}: {}", (Object)playerName, (Object)soundId);
        }
    }
}

