/*
 * Decompiled with CFR 0.152.
 */
package io.github.kingironman2011.orbital_railgun_enhanced.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.github.kingironman2011.orbital_railgun_enhanced.OrbitalRailgun;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class ServerConfig {
    private static final File CONFIG_FILE = new File("config/orbital-railgun-sounds-server-config.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final ServerConfig INSTANCE = new ServerConfig();
    private boolean debugMode = false;
    private double soundRange = 500.0;

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public double getSoundRange() {
        return this.soundRange;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
        this.saveConfig();
    }

    public void setSoundRange(double soundRange) {
        this.soundRange = soundRange;
        this.saveConfig();
    }

    public void loadConfig() {
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                ServerConfig config = (ServerConfig)GSON.fromJson((Reader)reader, ServerConfig.class);
                if (config != null) {
                    this.debugMode = config.debugMode;
                    this.soundRange = config.soundRange;
                } else {
                    OrbitalRailgun.LOGGER.warn("Config file parsed to null, using defaults: {}", (Object)CONFIG_FILE.getAbsolutePath());
                }
            }
            catch (IOException e) {
                OrbitalRailgun.LOGGER.error("Failed to load config: {}", (Object)e.getMessage());
            }
        } else {
            this.saveConfig();
        }
    }

    private void saveConfig() {
        try {
            boolean created;
            File parentDir = CONFIG_FILE.getParentFile();
            if (!(parentDir == null || parentDir.exists() || (created = parentDir.mkdirs()) || parentDir.exists())) {
                OrbitalRailgun.LOGGER.warn("Could not create config directory: {}", (Object)parentDir.getAbsolutePath());
            }
            try (FileWriter writer = new FileWriter(CONFIG_FILE);){
                GSON.toJson((Object)this, (Appendable)writer);
            }
        }
        catch (IOException e) {
            OrbitalRailgun.LOGGER.error("Failed to save config: {}", (Object)e.getMessage());
        }
    }
}

