/*
 * Decompiled with CFR 0.152.
 */
package g_mungus.zps.block.cableNetwork;

import g_mungus.zps.block.cableNetwork.core.CableNetworkComponent;
import g_mungus.zps.block.cableNetwork.core.Channels;
import g_mungus.zps.block.cableNetwork.core.NetworkNode;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class DenseCableBend
extends Block
implements CableNetworkComponent {
    public static final DirectionProperty DIRECTION_A = DirectionProperty.m_156003_((String)"facing_a");
    public static final DirectionProperty DIRECTION_B = DirectionProperty.m_156003_((String)"facing_b");
    public static final IntegerProperty CONNECTIONS = IntegerProperty.m_61631_((String)"connections", (int)0, (int)2);

    public DenseCableBend(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)DIRECTION_A, (Comparable)Direction.UP)).m_61124_((Property)DIRECTION_B, (Comparable)Direction.NORTH)).m_61124_((Property)CONNECTIONS, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DIRECTION_A, DIRECTION_B, CONNECTIONS});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        if (context.m_43723_() == null) {
            return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)DIRECTION_A, (Comparable)Direction.UP)).m_61124_((Property)DIRECTION_B, (Comparable)Direction.NORTH)).m_61124_((Property)CONNECTIONS, (Comparable)Integer.valueOf(0));
        }
        float pitch = context.m_43723_().m_146909_();
        float yaw = context.m_43723_().m_146908_();
        if (context.m_43723_().m_6144_()) {
            yaw += 180.0f;
        }
        yaw = (yaw + 360.0f) % 360.0f;
        pitch = (pitch + 360.0f) % 360.0f;
        Direction[] directions = this.getDirectionsFromPitchYaw(pitch, yaw);
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)DIRECTION_A, (Comparable)directions[0])).m_61124_((Property)DIRECTION_B, (Comparable)directions[1]);
    }

    private Direction[] getDirectionsFromPitchYaw(float pitch, float yaw) {
        Direction secondary;
        Direction primary;
        float normalizedPitch = (pitch + 90.0f) % 360.0f;
        Object verticalDir = normalizedPitch < 45.0f || normalizedPitch >= 315.0f ? Direction.UP : (normalizedPitch >= 135.0f && normalizedPitch < 225.0f ? Direction.DOWN : null);
        if (verticalDir != null) {
            Direction horizontalDir = yaw >= 315.0f || yaw < 45.0f ? Direction.SOUTH : (yaw >= 45.0f && yaw < 135.0f ? Direction.WEST : (yaw >= 135.0f && yaw < 225.0f ? Direction.NORTH : Direction.EAST));
            return new Direction[]{verticalDir.m_122424_(), horizontalDir.m_122424_()};
        }
        if (yaw >= 0.0f && yaw < 90.0f) {
            primary = Direction.NORTH;
            secondary = Direction.EAST;
        } else if (yaw >= 90.0f && yaw < 180.0f) {
            primary = Direction.EAST;
            secondary = Direction.SOUTH;
        } else if (yaw >= 180.0f && yaw < 270.0f) {
            primary = Direction.SOUTH;
            secondary = Direction.WEST;
        } else {
            primary = Direction.WEST;
            secondary = Direction.NORTH;
        }
        return new Direction[]{primary, secondary};
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!level.f_46443_) {
            this.updateConnections(state, level, pos);
        }
    }

    private void updateConnections(BlockState state, Level level, BlockPos pos) {
        BlockState newState = this.getNewBlockState(state, level, pos);
        if (!state.equals(newState)) {
            level.m_7731_(pos, newState, 3);
            this.updateNetwork(pos, level);
        }
    }

    private BlockState getNewBlockState(BlockState state, Level level, BlockPos pos) {
        return (BlockState)state.m_61124_((Property)CONNECTIONS, (Comparable)Integer.valueOf(this.getConnectedNodes(new NetworkNode(pos, 1, false), level, List.of()).size()));
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public int getTotalChannelCount() {
        return 4;
    }

    @Override
    public int getChannelCountForConnection(BlockPos self, BlockPos from, Level level) {
        BlockState state = level.m_8055_(self);
        if (this.isConnectingSide(self, from, state)) {
            return 4;
        }
        return 0;
    }

    @Override
    public List<BlockPos> getConnectingNeighbors(NetworkNode self, Level level) {
        BlockState state = level.m_8055_(self.pos());
        Direction first = (Direction)state.m_61143_((Property)DIRECTION_A);
        Direction second = (Direction)state.m_61143_((Property)DIRECTION_B);
        return List.of(self.pos().m_121955_(first.m_122436_()), self.pos().m_121955_(second.m_122436_()));
    }

    @Override
    public int getNewChannel(BlockPos self, NetworkNode input, Level level) {
        return Channels.toQuad(input.channel());
    }

    private boolean isConnectingSide(BlockPos a, BlockPos b, BlockState state) {
        Direction first = (Direction)state.m_61143_((Property)DIRECTION_A);
        Direction second = (Direction)state.m_61143_((Property)DIRECTION_B);
        BlockPos delta = b.m_121996_((Vec3i)a);
        Direction connection = Direction.m_122378_((int)delta.m_123341_(), (int)delta.m_123342_(), (int)delta.m_123343_());
        return first.equals((Object)connection) || second.equals((Object)connection);
    }
}

