/*
 * Decompiled with CFR 0.152.
 */
package g_mungus.zps.block.cableNetwork;

import g_mungus.zps.block.cableNetwork.core.CableNetworkComponent;
import g_mungus.zps.block.cableNetwork.core.Channels;
import g_mungus.zps.block.cableNetwork.core.NetworkNode;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class DenseCablesBlock
extends Block
implements CableNetworkComponent {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61365_;
    public static final IntegerProperty CONNECTIONS = IntegerProperty.m_61631_((String)"connections", (int)0, (int)2);

    public DenseCablesBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(AXIS, (Comparable)Direction.Axis.X)).m_61124_((Property)CONNECTIONS, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AXIS, CONNECTIONS});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction.Axis axis = context.m_7820_().m_122434_();
        return (BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)axis);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!level.f_46443_) {
            this.updateConnections(state, level, pos);
        }
    }

    private void updateConnections(BlockState state, Level level, BlockPos pos) {
        BlockState newState = this.getNewBlockState(state, level, pos);
        if (!state.equals(newState)) {
            level.m_7731_(pos, newState, 3);
            this.updateNetwork(pos, level);
        }
    }

    private BlockState getNewBlockState(BlockState state, Level level, BlockPos pos) {
        return (BlockState)state.m_61124_((Property)CONNECTIONS, (Comparable)Integer.valueOf(this.getConnectedNodes(new NetworkNode(pos, 1, false), level, List.of()).size()));
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public int getTotalChannelCount() {
        return 4;
    }

    @Override
    public int getChannelCountForConnection(BlockPos self, BlockPos from, Level level) {
        BlockState state = level.m_8055_(self);
        if (this.isConnectingSide(self, from, state)) {
            return 4;
        }
        return 0;
    }

    @Override
    public List<BlockPos> getConnectingNeighbors(NetworkNode self, Level level) {
        BlockState state = level.m_8055_(self.pos());
        Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS);
        return List.of(self.pos().m_121955_(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis).m_122436_()), self.pos().m_121955_(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)axis).m_122436_()));
    }

    @Override
    public int getNewChannel(BlockPos self, NetworkNode input, Level level) {
        return Channels.toQuad(input.channel());
    }

    private boolean isConnectingSide(BlockPos a, BlockPos b, BlockState state) {
        Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS);
        BlockPos delta = a.m_121996_((Vec3i)b);
        Direction connection = Direction.m_122378_((int)delta.m_123341_(), (int)delta.m_123342_(), (int)delta.m_123343_());
        if (connection != null) {
            return connection.m_122434_() == axis;
        }
        return false;
    }
}

