/*
 * Decompiled with CFR 0.152.
 */
package g_mungus.zps.block.cableNetwork;

import g_mungus.zps.block.cableNetwork.core.CableNetworkComponent;
import g_mungus.zps.block.cableNetwork.core.NetworkNode;
import g_mungus.zps.blockentity.ModBlockEntities;
import g_mungus.zps.blockentity.OctoControllerBlockEntity;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OctoControllerBlock
extends BaseEntityBlock
implements CableNetworkComponent {
    public static final DirectionProperty FACING = DirectionProperty.m_61546_((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static BooleanProperty BACK = BooleanProperty.m_61465_((String)"back");
    public static BooleanProperty DOWN = BooleanProperty.m_61465_((String)"down");

    public OctoControllerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)BACK, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, BACK, DOWN});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction facing = context.m_8125_().m_122424_();
        if (context.m_43723_() != null && context.m_43723_().m_6144_()) {
            facing = facing.m_122424_();
        }
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)ModBlockEntities.OCTO_CONTROLLER.get()).m_155264_(pos, state);
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult arg6) {
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof OctoControllerBlockEntity) {
            ((OctoControllerBlockEntity)blockEntity).startRiding(player, false, pos, state, (ServerLevel)level);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    @Override
    public boolean isTerminal() {
        return true;
    }

    @Override
    public int getTotalChannelCount() {
        return 8;
    }

    @Override
    public int getChannelCountForConnection(BlockPos self, BlockPos from, Level level) {
        BlockState state = level.m_8055_(self);
        BlockPos behind = self.m_121955_(((Direction)state.m_61143_((Property)FACING)).m_122424_().m_122436_());
        if (from.equals((Object)behind) || from.equals((Object)self.m_7495_())) {
            return 4;
        }
        return 0;
    }

    @Override
    public List<BlockPos> getConnectingNeighbors(NetworkNode self, Level level) {
        if (self.channel() >= 9) {
            BlockState state = level.m_8055_(self.pos());
            return List.of(self.pos().m_121955_(((Direction)state.m_61143_((Property)FACING)).m_122424_().m_122436_()));
        }
        if (self.channel() >= 5) {
            return List.of(self.pos().m_7495_());
        }
        return List.of();
    }

    @Override
    public int getNewChannel(BlockPos self, NetworkNode input, Level level) {
        if (input.pos().equals((Object)self.m_7495_())) {
            return input.channel() + 4;
        }
        return input.channel() + 8;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!level.f_46443_) {
            this.updateConnections(state, level, pos);
        }
    }

    private void updateConnections(BlockState state, Level level, BlockPos pos) {
        BlockState newState = this.getNewBlockState(state, level, pos);
        if (!state.equals(newState)) {
            level.m_7731_(pos, newState, 3);
            this.updateNetwork(pos, level);
        }
    }

    @NotNull
    public BlockState getNewBlockState(BlockState state, Level level, BlockPos pos) {
        Direction backDirection = ((Direction)state.m_61143_((Property)FACING)).m_122424_();
        boolean back = this.canConnect(pos, pos.m_121955_(backDirection.m_122436_()), level);
        boolean down = this.canConnect(pos, pos.m_121955_(Direction.DOWN.m_122436_()), level);
        return (BlockState)((BlockState)state.m_61124_((Property)BACK, (Comparable)Boolean.valueOf(back))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(down));
    }
}

