/*
 * Decompiled with CFR 0.152.
 */
package g_mungus.zps.block.cableNetwork.core;

import g_mungus.zps.block.cableNetwork.core.Channels;
import g_mungus.zps.block.cableNetwork.core.NetworkNode;
import g_mungus.zps.blockentity.NetworkTerminal;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public interface CableNetworkComponent {
    default public void updateNetwork(BlockPos pos, Level level) {
        for (int initialChannel = Channels.getInitialChannel(this.getTotalChannelCount()); initialChannel <= Channels.getFinalChannel(this.getTotalChannelCount()); ++initialChannel) {
            ArrayDeque<NetworkNode> toCheck = new ArrayDeque<NetworkNode>();
            ArrayList<NetworkNode> checked = new ArrayList<NetworkNode>();
            ArrayList<NetworkNode> terminals = new ArrayList<NetworkNode>();
            toCheck.add(new NetworkNode(pos, initialChannel, this.isTerminal()));
            while (!toCheck.isEmpty()) {
                BlockState blockState;
                Block block;
                NetworkNode current = (NetworkNode)toCheck.poll();
                if (checked.contains(current)) continue;
                checked.add(current);
                if (current.terminal()) {
                    terminals.add(current);
                }
                if (!((block = (blockState = level.m_8055_(current.pos())).m_60734_()) instanceof CableNetworkComponent)) continue;
                CableNetworkComponent component = (CableNetworkComponent)block;
                toCheck.addAll(component.getConnectedNodes(current, level, checked));
            }
            terminals.forEach(terminalNode -> {
                BlockEntity blockEntity = level.m_7702_(terminalNode.pos());
                if (blockEntity instanceof NetworkTerminal) {
                    NetworkTerminal terminal = (NetworkTerminal)blockEntity;
                    terminal.defineTerminals(terminals, terminalNode.channel());
                }
            });
        }
    }

    public boolean isTerminal();

    public int getTotalChannelCount();

    public int getChannelCountForConnection(BlockPos var1, BlockPos var2, Level var3);

    default public List<NetworkNode> getConnectedNodes(NetworkNode self, Level level, List<NetworkNode> exclude) {
        ArrayList<NetworkNode> output = new ArrayList<NetworkNode>();
        List<BlockPos> neighbors = this.getConnectingNeighbors(self, level);
        neighbors.forEach(neighbor -> {
            NetworkNode node;
            CableNetworkComponent component = this.getConnectedComponent(self.pos(), (BlockPos)neighbor, level);
            if (component != null && !exclude.contains(node = component.getNode((BlockPos)neighbor, self, level))) {
                output.add(node);
            }
        });
        return output;
    }

    public List<BlockPos> getConnectingNeighbors(NetworkNode var1, Level var2);

    @Nullable
    default public CableNetworkComponent getConnectedComponent(BlockPos self, BlockPos from, Level level) {
        Block blockProspect = level.m_8055_(from).m_60734_();
        if (blockProspect instanceof CableNetworkComponent) {
            CableNetworkComponent component = (CableNetworkComponent)blockProspect;
            if (this.getChannelCountForConnection(self, from, level) == component.getChannelCountForConnection(from, self, level) && this.getChannelCountForConnection(self, from, level) > 0) {
                return component;
            }
        }
        return null;
    }

    default public boolean canConnect(BlockPos self, BlockPos from, Level level) {
        return this.getConnectedComponent(self, from, level) != null;
    }

    default public NetworkNode getNode(BlockPos self, NetworkNode input, Level level) {
        int channel = this.getNewChannel(self, input, level);
        return new NetworkNode(self, channel, this.isTerminal());
    }

    public int getNewChannel(BlockPos var1, NetworkNode var2, Level var3);
}

