/*
 * Decompiled with CFR 0.152.
 */
package g_mungus.zps.blockentity;

import g_mungus.zps.block.cableNetwork.core.NetworkNode;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class NetworkTerminal
extends BlockEntity {
    private final Map<Integer, List<NetworkNode>> terminals = new ConcurrentHashMap<Integer, List<NetworkNode>>();

    public NetworkTerminal(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void defineTerminals(List<NetworkNode> terminals, int channel) {
        this.terminals.put(channel, terminals.stream().map(node -> new NetworkNode(node.pos().m_121996_((Vec3i)this.f_58858_), node.channel(), node.terminal())).toList());
    }

    public List<NetworkNode> getTerminals(int channel) {
        List<NetworkNode> nodes = this.terminals.get(channel);
        if (nodes != null) {
            return nodes.stream().map(node -> new NetworkNode(node.pos().m_121955_((Vec3i)this.f_58858_), node.channel(), node.terminal())).toList();
        }
        return List.of();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.terminals.clear();
        if (tag.m_128425_("Terminals", 9)) {
            ListTag terminalsList = tag.m_128437_("Terminals", 10);
            for (int i = 0; i < terminalsList.size(); ++i) {
                CompoundTag terminalTag = terminalsList.m_128728_(i);
                int channel = terminalTag.m_128451_("Channel");
                ListTag nodesList = terminalTag.m_128437_("Nodes", 10);
                List<NetworkNode> nodes = nodesList.stream().map(nodeTag -> {
                    CompoundTag nodeCompound = (CompoundTag)nodeTag;
                    BlockPos pos = new BlockPos(nodeCompound.m_128451_("X"), nodeCompound.m_128451_("Y"), nodeCompound.m_128451_("Z"));
                    int nodeChannel = nodeCompound.m_128451_("Channel");
                    boolean isTerminal = nodeCompound.m_128471_("IsTerminal");
                    return new NetworkNode(pos, nodeChannel, isTerminal);
                }).toList();
                this.terminals.put(channel, nodes);
            }
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ListTag terminalsList = new ListTag();
        this.terminals.forEach((channel, nodes) -> {
            CompoundTag terminalTag = new CompoundTag();
            terminalTag.m_128405_("Channel", channel.intValue());
            ListTag nodesList = new ListTag();
            nodes.forEach(node -> {
                CompoundTag nodeTag = new CompoundTag();
                nodeTag.m_128405_("X", node.pos().m_123341_());
                nodeTag.m_128405_("Y", node.pos().m_123342_());
                nodeTag.m_128405_("Z", node.pos().m_123343_());
                nodeTag.m_128405_("Channel", node.channel());
                nodeTag.m_128379_("IsTerminal", node.terminal());
                nodesList.add((Object)nodeTag);
            });
            terminalTag.m_128365_("Nodes", (Tag)nodesList);
            terminalsList.add((Object)terminalTag);
        });
        tag.m_128365_("Terminals", (Tag)terminalsList);
    }
}

