/*
 * Decompiled with CFR 0.152.
 */
package g_mungus.zps.block.cableNetwork;

import g_mungus.zps.block.ModBlocks;
import g_mungus.zps.block.cableNetwork.core.CableNetworkComponent;
import g_mungus.zps.block.cableNetwork.core.Channels;
import g_mungus.zps.block.cableNetwork.core.NetworkNode;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DenseCableSeparatorBlock
extends Block
implements CableNetworkComponent {
    public static final DirectionProperty FACING = DirectionProperty.m_156003_((String)"facing");
    public static final IntegerProperty ROTATION = IntegerProperty.m_61631_((String)"rotation", (int)0, (int)3);
    public static final BooleanProperty NORTH = BooleanProperty.m_61465_((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.m_61465_((String)"south");
    public static final BooleanProperty EAST = BooleanProperty.m_61465_((String)"east");
    public static final BooleanProperty WEST = BooleanProperty.m_61465_((String)"west");
    public static final BooleanProperty UP = BooleanProperty.m_61465_((String)"up");
    public static final BooleanProperty DOWN = BooleanProperty.m_61465_((String)"down");

    public DenseCableSeparatorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(0))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
        builder.m_61104_(new Property[]{ROTATION});
        builder.m_61104_(new Property[]{NORTH, SOUTH, EAST, WEST, UP, DOWN});
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult arg6) {
        if (player.m_21120_(hand).m_41619_() && player.m_6144_()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(((Integer)state.m_61143_((Property)ROTATION) + 1) % 4)), 2);
            Block block = state.m_60734_();
            if (block instanceof DenseCableSeparatorBlock) {
                ((DenseCableSeparatorBlock)block).updateNetwork(pos, level);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction facing = context.m_7820_();
        if (context.m_43723_() != null && context.m_43723_().m_6144_()) {
            facing = facing.m_122424_();
        }
        return this.getNewBlockState((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing), context.m_43725_(), context.m_8083_());
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!level.f_46443_) {
            this.updateConnections(state, level, pos);
        }
    }

    private void updateConnections(BlockState state, Level level, BlockPos pos) {
        BlockState newState = this.getNewBlockState(state, level, pos);
        if (!state.equals(newState)) {
            level.m_7731_(pos, newState, 3);
            this.updateNetwork(pos, level);
        }
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public int getTotalChannelCount() {
        return 4;
    }

    @Override
    public int getChannelCountForConnection(BlockPos self, BlockPos from, Level level) {
        BlockState state = level.m_8055_(self);
        if (state.m_61138_((Property)FACING)) {
            if (from.equals((Object)self.m_121955_(((Direction)state.m_61143_((Property)FACING)).m_122436_()))) {
                return 4;
            }
            if (from.equals((Object)self.m_121955_(((Direction)state.m_61143_((Property)FACING)).m_122424_().m_122436_()))) {
                return 0;
            }
            return 1;
        }
        return 0;
    }

    @Override
    public List<BlockPos> getConnectingNeighbors(NetworkNode self, Level level) {
        BlockState state = level.m_8055_(self.pos());
        return List.of(self.pos().m_121955_(((Direction)state.m_61143_((Property)FACING)).m_122436_()), this.getNeighborPosForChannel(self.channel(), self.pos(), state));
    }

    @Override
    public int getNewChannel(BlockPos self, NetworkNode input, Level level) {
        BlockState state = level.m_8055_(self);
        if (input.channel() == 0 || !DenseCableSeparatorBlock.isOnSameAxis(self, input.pos(), (Direction)state.m_61143_((Property)FACING))) {
            return this.getChannelForNeighborPos(self, input.pos(), state);
        }
        return Channels.toQuad(input.channel());
    }

    @NotNull
    public BlockState getNewBlockState(BlockState state, Level level, BlockPos pos) {
        boolean north = this.canConnect(pos, pos.m_121955_(Direction.NORTH.m_122436_()), level);
        boolean south = this.canConnect(pos, pos.m_121955_(Direction.SOUTH.m_122436_()), level);
        boolean east = this.canConnect(pos, pos.m_121955_(Direction.EAST.m_122436_()), level);
        boolean west = this.canConnect(pos, pos.m_121955_(Direction.WEST.m_122436_()), level);
        boolean up = this.canConnect(pos, pos.m_121955_(Direction.UP.m_122436_()), level);
        boolean down = this.canConnect(pos, pos.m_121955_(Direction.DOWN.m_122436_()), level);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(north))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(south))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(east))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(west))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(up))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(down));
    }

    public BlockPos getNeighborPosForChannel(int channel, BlockPos self, BlockState state) {
        if (!state.m_60713_((Block)ModBlocks.DENSE_CABLE_SEPARATOR.get())) {
            return self;
        }
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        int rotation = (Integer)state.m_61143_((Property)ROTATION);
        Vec3i c0 = !facing.m_122434_().equals((Object)Direction.Axis.Y) ? Direction.UP.m_122436_() : (facing.equals((Object)Direction.UP) ? Direction.SOUTH.m_122436_() : Direction.NORTH.m_122436_());
        int index = (8 + channel - rotation - 1) % 4;
        Vec3i selected = switch (index) {
            default -> c0;
            case 1 -> facing.m_122436_().m_7724_(c0).m_142393_(-1);
            case 2 -> c0.m_142393_(-1);
            case 3 -> facing.m_122436_().m_7724_(c0);
        };
        return self.m_121955_(selected);
    }

    public int getChannelForNeighborPos(BlockPos self, BlockPos neighbor, BlockState state) {
        if (!state.m_60713_((Block)ModBlocks.DENSE_CABLE_SEPARATOR.get())) {
            return -1;
        }
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        int rotation = (Integer)state.m_61143_((Property)ROTATION);
        Vec3i c0 = !facing.m_122434_().equals((Object)Direction.Axis.Y) ? Direction.UP.m_122436_() : (facing.equals((Object)Direction.UP) ? Direction.SOUTH.m_122436_() : Direction.NORTH.m_122436_());
        BlockPos offset = neighbor.m_121996_((Vec3i)self);
        if (offset.equals((Object)c0)) {
            return 1 + rotation % 4;
        }
        if (offset.equals((Object)facing.m_122436_().m_7724_(c0).m_142393_(-1))) {
            return 1 + (rotation + 1) % 4;
        }
        if (offset.equals((Object)c0.m_142393_(-1))) {
            return 1 + (rotation + 2) % 4;
        }
        if (offset.equals((Object)facing.m_122436_().m_7724_(c0))) {
            return 1 + (rotation + 3) % 4;
        }
        return -1;
    }

    private static boolean isOnSameAxis(BlockPos pos1, BlockPos pos2, Direction direction) {
        int dx = pos2.m_123341_() - pos1.m_123341_();
        int dy = pos2.m_123342_() - pos1.m_123342_();
        int dz = pos2.m_123343_() - pos1.m_123343_();
        return switch (direction.m_122434_()) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> {
                if (dy == 0 && dz == 0 && dx != 0) {
                    yield true;
                }
                yield false;
            }
            case Direction.Axis.Y -> {
                if (dx == 0 && dz == 0 && dy != 0) {
                    yield true;
                }
                yield false;
            }
            case Direction.Axis.Z -> dx == 0 && dy == 0 && dz != 0;
        };
    }
}

