/*
 * Decompiled with CFR 0.152.
 */
package g_mungus.zps.blockentity;

import g_mungus.zps.block.ModBlocks;
import g_mungus.zps.block.cableNetwork.StepdownTransformerBlock;
import g_mungus.zps.block.cableNetwork.TransformerBlock;
import g_mungus.zps.block.cableNetwork.core.NetworkNode;
import g_mungus.zps.blockentity.ModBlockEntities;
import g_mungus.zps.blockentity.NetworkTerminal;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StepUpTransformerBlockEntity
extends NetworkTerminal {
    private final EnergyStorage energyHandler = new EnergyStorage(5000, 1000, 1000);
    private final LazyOptional<IEnergyStorage> energy = LazyOptional.of(() -> this.energyHandler);

    public StepUpTransformerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.STEPUP_TRANSFORMER.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, StepUpTransformerBlockEntity blockEntity) {
        if (level.m_5776_()) {
            return;
        }
        Direction facing = (Direction)state.m_61143_((Property)TransformerBlock.FACING);
        BlockPos targetPos = pos.m_121945_(facing);
        BlockEntity targetEntity = level.m_7702_(targetPos);
        int canStore = Math.min(1000, blockEntity.energyHandler.getMaxEnergyStored() - blockEntity.energyHandler.getEnergyStored());
        if (targetEntity != null) {
            targetEntity.getCapability(ForgeCapabilities.ENERGY, facing.m_122424_()).ifPresent(storage -> {
                int energyToExtract;
                int energyExtracted;
                if (storage.canExtract() && (energyExtracted = storage.extractEnergy(energyToExtract = Math.min(storage.getEnergyStored(), canStore), false)) > 0) {
                    blockEntity.energyHandler.receiveEnergy(energyExtracted, false);
                }
            });
        }
        List<NetworkNode> terminals = blockEntity.getTerminals(0);
        AtomicInteger receivingTerminalCount = new AtomicInteger(0);
        terminals.forEach(node -> {
            BlockState state1 = level.m_8055_(node.pos());
            if (state1.m_60713_((Block)ModBlocks.STEPDOWN_TRANSFORMER.get())) {
                Direction dir = (Direction)state1.m_61143_((Property)StepdownTransformerBlock.FACING);
                BlockPos targetPos2 = node.pos().m_121945_(dir);
                BlockEntity targetEntity2 = level.m_7702_(targetPos2);
                if (targetEntity2 != null) {
                    targetEntity2.getCapability(ForgeCapabilities.ENERGY, dir.m_122424_()).ifPresent(storage -> {
                        if (storage.canReceive() && storage.getMaxEnergyStored() > storage.getEnergyStored()) {
                            receivingTerminalCount.incrementAndGet();
                        }
                    });
                }
            } else if (state1.m_60713_((Block)ModBlocks.REDSTONE_CONVERTER.get()) && blockEntity.energyHandler.getEnergyStored() > 0) {
                level.m_46961_(node.pos(), false);
                Vec3 center = node.pos().m_252807_();
                level.m_254849_(null, center.f_82479_, center.f_82480_, center.f_82481_, 2.0f, Level.ExplosionInteraction.BLOCK);
            }
        });
        if (receivingTerminalCount.get() > 0) {
            int availableEnergy = blockEntity.energyHandler.getEnergyStored();
            int energyPerTransformer = Math.min(availableEnergy, 1000) / receivingTerminalCount.get();
            terminals.forEach(node -> {
                BlockState state1 = level.m_8055_(node.pos());
                if (state1.m_60713_((Block)ModBlocks.STEPDOWN_TRANSFORMER.get())) {
                    Direction dir = (Direction)state1.m_61143_((Property)StepdownTransformerBlock.FACING);
                    BlockPos targetPos2 = node.pos().m_121945_(dir);
                    BlockEntity targetEntity2 = level.m_7702_(targetPos2);
                    if (targetEntity2 != null) {
                        targetEntity2.getCapability(ForgeCapabilities.ENERGY, dir.m_122424_()).ifPresent(storage -> {
                            int energySent;
                            if (storage.canReceive() && (energySent = blockEntity.energyHandler.extractEnergy(energyPerTransformer, false)) > 0) {
                                storage.receiveEnergy(energySent, false);
                            }
                        });
                    }
                }
            });
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.energyHandler.deserializeNBT(tag.m_128423_("Energy"));
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Energy", this.energyHandler.serializeNBT());
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY && side != null && side == this.m_58900_().m_61143_((Property)TransformerBlock.FACING)) {
            return this.energy.cast();
        }
        return super.getCapability(cap, side);
    }
}

