/*
 * Decompiled with CFR 0.152.
 */
package g_mungus.zps.block.cableNetwork;

import g_mungus.zps.block.cableNetwork.core.CableNetworkComponent;
import g_mungus.zps.block.cableNetwork.core.NetworkNode;
import g_mungus.zps.util.Utils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CableBlock
extends Block
implements CableNetworkComponent {
    public static BooleanProperty NORTH = BooleanProperty.create((String)"north");
    public static BooleanProperty SOUTH = BooleanProperty.create((String)"south");
    public static BooleanProperty EAST = BooleanProperty.create((String)"east");
    public static BooleanProperty WEST = BooleanProperty.create((String)"west");
    public static BooleanProperty UP = BooleanProperty.create((String)"up");
    public static BooleanProperty DOWN = BooleanProperty.create((String)"down");
    private static final VoxelShape CORE = Block.box((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    private static final VoxelShape NORTH_SHAPE = Block.box((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)6.0);
    private static final VoxelShape SOUTH_SHAPE = Block.box((double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0, (double)16.0);
    private static final VoxelShape EAST_SHAPE = Block.box((double)10.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
    private static final VoxelShape WEST_SHAPE = Block.box((double)0.0, (double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0);
    private static final VoxelShape UP_SHAPE = Block.box((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape DOWN_SHAPE = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0);

    public CableBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH, SOUTH, EAST, WEST, UP, DOWN});
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape shape = CORE;
        if (((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)NORTH_SHAPE);
        }
        if (((Boolean)state.getValue((Property)SOUTH)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)SOUTH_SHAPE);
        }
        if (((Boolean)state.getValue((Property)EAST)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)EAST_SHAPE);
        }
        if (((Boolean)state.getValue((Property)WEST)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)WEST_SHAPE);
        }
        if (((Boolean)state.getValue((Property)UP)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)UP_SHAPE);
        }
        if (((Boolean)state.getValue((Property)DOWN)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)DOWN_SHAPE);
        }
        return shape;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext arg) {
        BlockState blockState = this.defaultBlockState();
        return this.getNewBlockState(blockState, arg.getLevel(), arg.getClickedPos());
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!level.isClientSide) {
            this.updateConnections(state, level, pos);
        }
    }

    private void updateConnections(BlockState state, Level level, BlockPos pos) {
        BlockState newState = this.getNewBlockState(state, level, pos);
        if (!state.equals(newState)) {
            level.setBlock(pos, newState, 3);
            this.updateNetwork(pos, level);
        }
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public int getTotalChannelCount() {
        return 1;
    }

    @Override
    public int getChannelCountForConnection(BlockPos self, BlockPos from, Level level) {
        return 1;
    }

    @Override
    public List<BlockPos> getConnectingNeighbors(NetworkNode self, Level level) {
        return Utils.getNeighbors(self.pos());
    }

    @Override
    public int getNewChannel(BlockPos self, NetworkNode input, Level level) {
        return 0;
    }

    @NotNull
    public BlockState getNewBlockState(BlockState state, Level level, BlockPos pos) {
        boolean north = this.canConnect(pos, pos.offset(Direction.NORTH.getNormal()), level);
        boolean south = this.canConnect(pos, pos.offset(Direction.SOUTH.getNormal()), level);
        boolean east = this.canConnect(pos, pos.offset(Direction.EAST.getNormal()), level);
        boolean west = this.canConnect(pos, pos.offset(Direction.WEST.getNormal()), level);
        boolean up = this.canConnect(pos, pos.offset(Direction.UP.getNormal()), level);
        boolean down = this.canConnect(pos, pos.offset(Direction.DOWN.getNormal()), level);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)Boolean.valueOf(north))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(south))).setValue((Property)EAST, (Comparable)Boolean.valueOf(east))).setValue((Property)WEST, (Comparable)Boolean.valueOf(west))).setValue((Property)UP, (Comparable)Boolean.valueOf(up))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(down));
    }
}

