/*
 * Decompiled with CFR 0.152.
 */
package g_mungus.zps.block.cableNetwork;

import g_mungus.zps.block.cableNetwork.core.CableNetworkComponent;
import g_mungus.zps.block.cableNetwork.core.Channels;
import g_mungus.zps.block.cableNetwork.core.NetworkNode;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class DenseCableBend
extends Block
implements CableNetworkComponent {
    public static final DirectionProperty DIRECTION_A = DirectionProperty.create((String)"facing_a");
    public static final DirectionProperty DIRECTION_B = DirectionProperty.create((String)"facing_b");
    public static final IntegerProperty CONNECTIONS = IntegerProperty.create((String)"connections", (int)0, (int)2);

    public DenseCableBend(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DIRECTION_A, (Comparable)Direction.UP)).setValue((Property)DIRECTION_B, (Comparable)Direction.NORTH)).setValue((Property)CONNECTIONS, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{DIRECTION_A, DIRECTION_B, CONNECTIONS});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (context.getPlayer() == null) {
            return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)DIRECTION_A, (Comparable)Direction.UP)).setValue((Property)DIRECTION_B, (Comparable)Direction.NORTH)).setValue((Property)CONNECTIONS, (Comparable)Integer.valueOf(0));
        }
        float pitch = context.getPlayer().getXRot();
        float yaw = context.getPlayer().getYRot();
        if (context.getPlayer().isShiftKeyDown()) {
            yaw += 180.0f;
        }
        yaw = (yaw + 360.0f) % 360.0f;
        pitch = (pitch + 360.0f) % 360.0f;
        Direction[] directions = this.getDirectionsFromPitchYaw(pitch, yaw);
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)DIRECTION_A, (Comparable)directions[0])).setValue((Property)DIRECTION_B, (Comparable)directions[1]);
    }

    private Direction[] getDirectionsFromPitchYaw(float pitch, float yaw) {
        Direction secondary;
        Direction primary;
        float normalizedPitch = (pitch + 90.0f) % 360.0f;
        Object verticalDir = normalizedPitch < 45.0f || normalizedPitch >= 315.0f ? Direction.UP : (normalizedPitch >= 135.0f && normalizedPitch < 225.0f ? Direction.DOWN : null);
        if (verticalDir != null) {
            Direction horizontalDir = yaw >= 315.0f || yaw < 45.0f ? Direction.SOUTH : (yaw >= 45.0f && yaw < 135.0f ? Direction.WEST : (yaw >= 135.0f && yaw < 225.0f ? Direction.NORTH : Direction.EAST));
            return new Direction[]{verticalDir.getOpposite(), horizontalDir.getOpposite()};
        }
        if (yaw >= 0.0f && yaw < 90.0f) {
            primary = Direction.NORTH;
            secondary = Direction.EAST;
        } else if (yaw >= 90.0f && yaw < 180.0f) {
            primary = Direction.EAST;
            secondary = Direction.SOUTH;
        } else if (yaw >= 180.0f && yaw < 270.0f) {
            primary = Direction.SOUTH;
            secondary = Direction.WEST;
        } else {
            primary = Direction.WEST;
            secondary = Direction.NORTH;
        }
        return new Direction[]{primary, secondary};
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!level.isClientSide) {
            this.updateConnections(state, level, pos);
        }
    }

    private void updateConnections(BlockState state, Level level, BlockPos pos) {
        BlockState newState = this.getNewBlockState(state, level, pos);
        if (!state.equals(newState)) {
            level.setBlock(pos, newState, 3);
            this.updateNetwork(pos, level);
        }
    }

    private BlockState getNewBlockState(BlockState state, Level level, BlockPos pos) {
        return (BlockState)state.setValue((Property)CONNECTIONS, (Comparable)Integer.valueOf(this.getConnectedNodes(new NetworkNode(pos, 1, false), level, List.of()).size()));
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public int getTotalChannelCount() {
        return 4;
    }

    @Override
    public int getChannelCountForConnection(BlockPos self, BlockPos from, Level level) {
        BlockState state = level.getBlockState(self);
        if (this.isConnectingSide(self, from, state)) {
            return 4;
        }
        return 0;
    }

    @Override
    public List<BlockPos> getConnectingNeighbors(NetworkNode self, Level level) {
        BlockState state = level.getBlockState(self.pos());
        Direction first = (Direction)state.getValue((Property)DIRECTION_A);
        Direction second = (Direction)state.getValue((Property)DIRECTION_B);
        return List.of(self.pos().offset(first.getNormal()), self.pos().offset(second.getNormal()));
    }

    @Override
    public int getNewChannel(BlockPos self, NetworkNode input, Level level) {
        return Channels.toQuad(input.channel());
    }

    private boolean isConnectingSide(BlockPos a, BlockPos b, BlockState state) {
        Direction first = (Direction)state.getValue((Property)DIRECTION_A);
        Direction second = (Direction)state.getValue((Property)DIRECTION_B);
        BlockPos delta = b.subtract((Vec3i)a);
        Direction connection = Direction.fromDelta((int)delta.getX(), (int)delta.getY(), (int)delta.getZ());
        return first.equals((Object)connection) || second.equals((Object)connection);
    }
}

