/*
 * Decompiled with CFR 0.152.
 */
package g_mungus.zps.block.cableNetwork;

import g_mungus.zps.block.ModBlocks;
import g_mungus.zps.block.cableNetwork.TransformerBlock;
import g_mungus.zps.blockentity.ModBlockEntities;
import g_mungus.zps.blockentity.RedstoneConverterBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedstoneConverterBlock
extends TransformerBlock {
    public RedstoneConverterBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)ModBlockEntities.REDSTONE_CONVERTER.get()).create(pos, state);
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return state.is((Block)ModBlocks.REDSTONE_CONVERTER.get()) && ((Direction)state.getValue((Property)TransformerBlock.FACING)).getOpposite() == direction;
    }

    public int getDirectSignal(@NotNull BlockState state, BlockGetter level, @NotNull BlockPos pos, @NotNull Direction direction) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof RedstoneConverterBlockEntity && direction.equals((Object)((Direction)state.getValue((Property)TransformerBlock.FACING)).getOpposite())) {
            return ((RedstoneConverterBlockEntity)blockEntity).getCurrentSignal();
        }
        return 0;
    }

    public int getSignal(@NotNull BlockState state, BlockGetter level, @NotNull BlockPos pos, @NotNull Direction direction) {
        return this.getDirectSignal(state, level, pos, direction);
    }

    @Override
    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, level, pos, block, fromPos, isMoving);
        Direction facing = (Direction)state.getValue((Property)TransformerBlock.FACING);
        BlockPos sourcePos = pos.offset(facing.getNormal());
        int power = level.getDirectSignal(sourcePos, facing);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof RedstoneConverterBlockEntity) {
            ((RedstoneConverterBlockEntity)blockEntity).supplySignal(power);
        }
    }
}

