/*
 * Decompiled with CFR 0.152.
 */
package g_mungus.zps.blockentity;

import g_mungus.zps.blockentity.NetworkTerminal;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;

public abstract class RideableNetworkTerminal<T extends Entity>
extends NetworkTerminal {
    protected final List<T> seats = new ArrayList<T>();

    public RideableNetworkTerminal(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public boolean startRiding(Player player, boolean force, BlockPos blockPos, BlockState state, ServerLevel level) {
        for (Entity seat : this.seats) {
            if (seat.isVehicle()) continue;
            seat.kill();
        }
        this.seats.clear();
        T seat = this.spawnSeat(blockPos, state, level);
        boolean ride = player.startRiding(seat, force);
        if (ride) {
            this.seats.add(seat);
        }
        return ride;
    }

    abstract EntityType<T> getSeatEntity();

    abstract void registerSeatEntity(T var1, Vec3i var2);

    public T spawnSeat(BlockPos blockPos, BlockState state, ServerLevel level) {
        double height = 0.5;
        BlockPos newPos = blockPos.relative((Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING));
        Entity entity = this.getSeatEntity().create((Level)level);
        if (entity != null) {
            this.registerSeatEntity(entity, (Vec3i)blockPos.subtract((Vec3i)newPos));
            Vector3d seatEntityPos = new Vector3d((double)newPos.getX() + 0.5, (double)newPos.getY() - 0.5 + height, (double)newPos.getZ() + 0.5);
            entity.moveTo(seatEntityPos.x(), seatEntityPos.y(), seatEntityPos.z());
            entity.lookAt(EntityAnchorArgument.Anchor.EYES, Vec3.atLowerCornerOf((Vec3i)((Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING)).getNormal().offset((Vec3i)entity.getOnPos())));
            this.seats.add(entity);
            level.addFreshEntityWithPassengers(entity);
        }
        return (T)entity;
    }
}

