/*
 * Decompiled with CFR 0.152.
 */
package g_mungus.zps.blockentity;

import g_mungus.zps.block.ModBlocks;
import g_mungus.zps.block.cableNetwork.StepdownTransformerBlock;
import g_mungus.zps.block.cableNetwork.TransformerBlock;
import g_mungus.zps.block.cableNetwork.core.NetworkNode;
import g_mungus.zps.blockentity.ModBlockEntities;
import g_mungus.zps.blockentity.NetworkTerminal;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class StepUpTransformerBlockEntity
extends NetworkTerminal {
    private final EnergyStorage energyHandler = new EnergyStorage(5000, 1000, 1000);
    private BlockCapabilityCache<IEnergyStorage, @Nullable Direction> inputEnergyCache;
    private BlockCapabilityCache<IEnergyStorage, @Nullable Direction> outputEnergyCache;

    public StepUpTransformerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.STEPUP_TRANSFORMER.get(), pos, state);
    }

    public void onLoad() {
        super.onLoad();
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Direction facing = (Direction)this.getBlockState().getValue((Property)TransformerBlock.FACING);
            BlockPos inputPos = this.getBlockPos().relative(facing);
            BlockPos outputPos = this.getBlockPos().relative(facing.getOpposite());
            this.inputEnergyCache = BlockCapabilityCache.create((BlockCapability)Capabilities.EnergyStorage.BLOCK, (ServerLevel)serverLevel, (BlockPos)inputPos, (Object)facing.getOpposite(), () -> !this.isRemoved(), () -> {});
            this.outputEnergyCache = BlockCapabilityCache.create((BlockCapability)Capabilities.EnergyStorage.BLOCK, (ServerLevel)serverLevel, (BlockPos)outputPos, (Object)facing, () -> !this.isRemoved(), () -> {});
        }
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains("Energy", 3)) {
            this.energyHandler.deserializeNBT(provider, tag.get("Energy"));
        }
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put("Energy", this.energyHandler.serializeNBT(provider));
    }

    public static void tick(Level level, BlockPos pos, BlockState state, StepUpTransformerBlockEntity blockEntity) {
        IEnergyStorage inputStorage;
        if (level.isClientSide()) {
            return;
        }
        IEnergyStorage iEnergyStorage = inputStorage = blockEntity.inputEnergyCache != null ? (IEnergyStorage)blockEntity.inputEnergyCache.getCapability() : null;
        if (inputStorage != null && inputStorage.canExtract()) {
            int canStore = Math.min(1000, blockEntity.energyHandler.getMaxEnergyStored() - blockEntity.energyHandler.getEnergyStored());
            int energyToExtract = Math.min(inputStorage.getEnergyStored(), canStore);
            int energyExtracted = inputStorage.extractEnergy(energyToExtract, false);
            if (energyExtracted > 0) {
                blockEntity.energyHandler.receiveEnergy(energyExtracted, false);
            }
        }
        List<NetworkNode> terminals = blockEntity.getTerminals(0);
        AtomicInteger receivingTerminalCount = new AtomicInteger(0);
        terminals.forEach(node -> {
            BlockState state1 = level.getBlockState(node.pos());
            if (state1.is((Block)ModBlocks.STEPDOWN_TRANSFORMER.get())) {
                IEnergyStorage storage;
                Direction dir = (Direction)state1.getValue((Property)StepdownTransformerBlock.FACING);
                BlockPos targetPos = node.pos().relative(dir);
                BlockEntity targetEntity = level.getBlockEntity(targetPos);
                if (targetEntity != null && (storage = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, targetPos, (Object)dir.getOpposite())) != null && storage.canReceive() && storage.getMaxEnergyStored() > storage.getEnergyStored()) {
                    receivingTerminalCount.incrementAndGet();
                }
            } else if (state1.is((Block)ModBlocks.REDSTONE_CONVERTER.get()) && blockEntity.energyHandler.getEnergyStored() > 0) {
                level.destroyBlock(node.pos(), false);
                Vec3 center = node.pos().getCenter();
                level.explode(null, center.x, center.y, center.z, 2.0f, Level.ExplosionInteraction.BLOCK);
            }
        });
        if (receivingTerminalCount.get() > 0) {
            int availableEnergy = blockEntity.energyHandler.getEnergyStored();
            int energyPerTransformer = Math.min(availableEnergy, 1000) / receivingTerminalCount.get();
            terminals.forEach(node -> {
                BlockState state1 = level.getBlockState(node.pos());
                if (state1.is((Block)ModBlocks.STEPDOWN_TRANSFORMER.get())) {
                    int energySent;
                    IEnergyStorage storage;
                    Direction dir = (Direction)state1.getValue((Property)StepdownTransformerBlock.FACING);
                    BlockPos targetPos = node.pos().relative(dir);
                    BlockEntity targetEntity = level.getBlockEntity(targetPos);
                    if (targetEntity != null && (storage = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, targetPos, (Object)dir.getOpposite())) != null && storage.canReceive() && (energySent = storage.receiveEnergy(energyPerTransformer, false)) > 0) {
                        blockEntity.energyHandler.extractEnergy(energySent, false);
                    }
                }
            });
        }
    }

    public void setRemoved() {
        super.setRemoved();
        if (this.inputEnergyCache != null) {
            this.inputEnergyCache = null;
        }
        if (this.outputEnergyCache != null) {
            this.outputEnergyCache = null;
        }
    }
}

