/*
 * Decompiled with CFR 0.152.
 */
package g_mungus.zps.entity;

import g_mungus.zps.block.cableNetwork.OctoControllerBlock;
import g_mungus.zps.blockentity.OctoControllerBlockEntity;
import g_mungus.zps.client.ModKeybinds;
import g_mungus.zps.networking.OctovariantControlPacket;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class OctoMountingEntity
extends Entity {
    public OctoControllerBlockEntity blockEntity = null;
    public boolean isController = false;
    public Vec3i offset = Vec3i.ZERO;

    public OctoMountingEntity(@NotNull EntityType<OctoMountingEntity> type, @NotNull Level level) {
        super(type, level);
        this.blocksBuilding = false;
        this.noPhysics = true;
    }

    public void tick() {
        this.baseTick();
        if (this.level().isClientSide) {
            this.sendControlPacket();
            return;
        }
        if (!this.verifyControllerBlock()) {
            this.cleanupAndDiscard();
        }
    }

    private boolean verifyControllerBlock() {
        if (this.isNextToControllerBlock(this.offset)) {
            this.ensureBlockEntityLinked();
            return !this.getPassengers().isEmpty();
        }
        if (this.searchAdjacentForController()) {
            return !this.getPassengers().isEmpty();
        }
        return false;
    }

    private boolean isNextToControllerBlock(Vec3i testOffset) {
        BlockState state = this.level().getBlockState(this.blockPosition().offset(testOffset));
        return state.getBlock() instanceof OctoControllerBlock && ((Direction)state.getValue((Property)OctoControllerBlock.FACING)).getOpposite().getNormal().subtract(testOffset).distManhattan(Vec3i.ZERO) == 0;
    }

    private boolean searchAdjacentForController() {
        Vec3i[] adjacentOffsets;
        for (Vec3i testOffset : adjacentOffsets = new Vec3i[]{new Vec3i(1, 0, 0), new Vec3i(-1, 0, 0), new Vec3i(0, 0, 1), new Vec3i(0, 0, -1)}) {
            if (!this.isNextToControllerBlock(testOffset)) continue;
            this.offset = testOffset;
            this.ensureBlockEntityLinked();
            return true;
        }
        return false;
    }

    private void ensureBlockEntityLinked() {
        BlockEntity blockEntity;
        if (this.blockEntity == null && (blockEntity = this.level().getBlockEntity(this.blockPosition().offset(this.offset))) instanceof OctoControllerBlockEntity) {
            OctoControllerBlockEntity newBlockEntity;
            this.blockEntity = newBlockEntity = (OctoControllerBlockEntity)blockEntity;
            this.isController = true;
        }
    }

    private void cleanupAndDiscard() {
        if (this.blockEntity != null) {
            this.blockEntity.setA(0);
            this.blockEntity.setB(0);
            this.blockEntity.setC(0);
            this.blockEntity.setD(0);
            this.blockEntity.setE(0);
            this.blockEntity.setF(0);
            this.blockEntity.setG(0);
            this.blockEntity.setH(0);
        }
        this.discard();
    }

    protected void readAdditionalSaveData(CompoundTag arg) {
    }

    protected void addAdditionalSaveData(CompoundTag arg) {
    }

    protected void defineSynchedData(SynchedEntityData.Builder arg) {
    }

    private void sendControlPacket() {
        if (!this.level().isClientSide) {
            return;
        }
        int a = ModKeybinds.KEY_A.isDown() ? 15 : 0;
        int b = ModKeybinds.KEY_B.isDown() ? 15 : 0;
        int c = ModKeybinds.KEY_C.isDown() ? 15 : 0;
        int d = ModKeybinds.KEY_D.isDown() ? 15 : 0;
        int e = ModKeybinds.KEY_E.isDown() ? 15 : 0;
        int f = ModKeybinds.KEY_F.isDown() ? 15 : 0;
        int g = ModKeybinds.KEY_G.isDown() ? 15 : 0;
        int h = ModKeybinds.KEY_H.isDown() ? 15 : 0;
        PacketDistributor.sendToServer((CustomPacketPayload)new OctovariantControlPacket(a, b, c, d, e, f, g, h), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public LivingEntity getControllingPassenger() {
        if (this.isController && !this.getPassengers().isEmpty()) {
            return (LivingEntity)this.getPassengers().get(0);
        }
        return null;
    }
}

