/*
 * Decompiled with CFR 0.152.
 */
package g_mungus.zps.block.cableNetwork;

import g_mungus.zps.block.ModBlocks;
import g_mungus.zps.block.cableNetwork.core.CableNetworkComponent;
import g_mungus.zps.block.cableNetwork.core.Channels;
import g_mungus.zps.block.cableNetwork.core.NetworkNode;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DenseCableSeparatorBlock
extends Block
implements CableNetworkComponent {
    public static final DirectionProperty FACING = DirectionProperty.create((String)"facing");
    public static final IntegerProperty ROTATION = IntegerProperty.create((String)"rotation", (int)0, (int)3);
    public static final BooleanProperty NORTH = BooleanProperty.create((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.create((String)"south");
    public static final BooleanProperty EAST = BooleanProperty.create((String)"east");
    public static final BooleanProperty WEST = BooleanProperty.create((String)"west");
    public static final BooleanProperty UP = BooleanProperty.create((String)"up");
    public static final BooleanProperty DOWN = BooleanProperty.create((String)"down");

    public DenseCableSeparatorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)ROTATION, (Comparable)Integer.valueOf(0))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
        builder.add(new Property[]{ROTATION});
        builder.add(new Property[]{NORTH, SOUTH, EAST, WEST, UP, DOWN});
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult arg5) {
        if (player.isShiftKeyDown()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)ROTATION, (Comparable)Integer.valueOf(((Integer)state.getValue((Property)ROTATION) + 1) % 4)), 2);
            Block block = state.getBlock();
            if (block instanceof DenseCableSeparatorBlock) {
                ((DenseCableSeparatorBlock)block).updateNetwork(pos, level);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction facing = context.getNearestLookingDirection();
        if (context.getPlayer() != null && context.getPlayer().isShiftKeyDown()) {
            facing = facing.getOpposite();
        }
        return this.getNewBlockState((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing), context.getLevel(), context.getClickedPos());
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!level.isClientSide) {
            this.updateConnections(state, level, pos);
        }
    }

    private void updateConnections(BlockState state, Level level, BlockPos pos) {
        BlockState newState = this.getNewBlockState(state, level, pos);
        if (!state.equals(newState)) {
            level.setBlock(pos, newState, 3);
            this.updateNetwork(pos, level);
        }
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public int getTotalChannelCount() {
        return 4;
    }

    @Override
    public int getChannelCountForConnection(BlockPos self, BlockPos from, Level level) {
        BlockState state = level.getBlockState(self);
        if (state.hasProperty((Property)FACING)) {
            if (from.equals((Object)self.offset(((Direction)state.getValue((Property)FACING)).getNormal()))) {
                return 4;
            }
            if (from.equals((Object)self.offset(((Direction)state.getValue((Property)FACING)).getOpposite().getNormal()))) {
                return 0;
            }
            return 1;
        }
        return 0;
    }

    @Override
    public List<BlockPos> getConnectingNeighbors(NetworkNode self, Level level) {
        BlockState state = level.getBlockState(self.pos());
        return List.of(self.pos().offset(((Direction)state.getValue((Property)FACING)).getNormal()), this.getNeighborPosForChannel(self.channel(), self.pos(), state));
    }

    @Override
    public int getNewChannel(BlockPos self, NetworkNode input, Level level) {
        BlockState state = level.getBlockState(self);
        if (input.channel() == 0 || !DenseCableSeparatorBlock.isOnSameAxis(self, input.pos(), (Direction)state.getValue((Property)FACING))) {
            return this.getChannelForNeighborPos(self, input.pos(), state);
        }
        return Channels.toQuad(input.channel());
    }

    @NotNull
    public BlockState getNewBlockState(BlockState state, Level level, BlockPos pos) {
        boolean north = this.canConnect(pos, pos.offset(Direction.NORTH.getNormal()), level);
        boolean south = this.canConnect(pos, pos.offset(Direction.SOUTH.getNormal()), level);
        boolean east = this.canConnect(pos, pos.offset(Direction.EAST.getNormal()), level);
        boolean west = this.canConnect(pos, pos.offset(Direction.WEST.getNormal()), level);
        boolean up = this.canConnect(pos, pos.offset(Direction.UP.getNormal()), level);
        boolean down = this.canConnect(pos, pos.offset(Direction.DOWN.getNormal()), level);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)Boolean.valueOf(north))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(south))).setValue((Property)EAST, (Comparable)Boolean.valueOf(east))).setValue((Property)WEST, (Comparable)Boolean.valueOf(west))).setValue((Property)UP, (Comparable)Boolean.valueOf(up))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(down));
    }

    public BlockPos getNeighborPosForChannel(int channel, BlockPos self, BlockState state) {
        if (!state.is((Block)ModBlocks.DENSE_CABLE_SEPARATOR.get())) {
            return self;
        }
        Direction facing = (Direction)state.getValue((Property)FACING);
        int rotation = (Integer)state.getValue((Property)ROTATION);
        Vec3i c0 = !facing.getAxis().equals((Object)Direction.Axis.Y) ? Direction.UP.getNormal() : (facing.equals((Object)Direction.UP) ? Direction.SOUTH.getNormal() : Direction.NORTH.getNormal());
        int index = (8 + channel - rotation - 1) % 4;
        Vec3i selected = switch (index) {
            default -> c0;
            case 1 -> facing.getNormal().cross(c0).multiply(-1);
            case 2 -> c0.multiply(-1);
            case 3 -> facing.getNormal().cross(c0);
        };
        return self.offset(selected);
    }

    public int getChannelForNeighborPos(BlockPos self, BlockPos neighbor, BlockState state) {
        if (!state.is((Block)ModBlocks.DENSE_CABLE_SEPARATOR.get())) {
            return -1;
        }
        Direction facing = (Direction)state.getValue((Property)FACING);
        int rotation = (Integer)state.getValue((Property)ROTATION);
        Vec3i c0 = !facing.getAxis().equals((Object)Direction.Axis.Y) ? Direction.UP.getNormal() : (facing.equals((Object)Direction.UP) ? Direction.SOUTH.getNormal() : Direction.NORTH.getNormal());
        BlockPos offset = neighbor.subtract((Vec3i)self);
        if (offset.equals((Object)c0)) {
            return 1 + rotation % 4;
        }
        if (offset.equals((Object)facing.getNormal().cross(c0).multiply(-1))) {
            return 1 + (rotation + 1) % 4;
        }
        if (offset.equals((Object)c0.multiply(-1))) {
            return 1 + (rotation + 2) % 4;
        }
        if (offset.equals((Object)facing.getNormal().cross(c0))) {
            return 1 + (rotation + 3) % 4;
        }
        return -1;
    }

    private static boolean isOnSameAxis(BlockPos pos1, BlockPos pos2, Direction direction) {
        int dx = pos2.getX() - pos1.getX();
        int dy = pos2.getY() - pos1.getY();
        int dz = pos2.getZ() - pos1.getZ();
        return switch (direction.getAxis()) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> {
                if (dy == 0 && dz == 0 && dx != 0) {
                    yield true;
                }
                yield false;
            }
            case Direction.Axis.Y -> {
                if (dx == 0 && dz == 0 && dy != 0) {
                    yield true;
                }
                yield false;
            }
            case Direction.Axis.Z -> dx == 0 && dy == 0 && dz != 0;
        };
    }
}

