/*
 * Decompiled with CFR 0.152.
 */
package g_mungus.zps.block.cableNetwork;

import g_mungus.zps.block.cableNetwork.CableBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class TransformerBlock
extends CableBlock
implements EntityBlock {
    public static final DirectionProperty FACING = DirectionProperty.create((String)"facing");
    private static final VoxelShape NORTH_SHAPE = Block.box((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)4.0);
    private static final VoxelShape SOUTH_SHAPE = Block.box((double)1.0, (double)1.0, (double)12.0, (double)15.0, (double)15.0, (double)16.0);
    private static final VoxelShape EAST_SHAPE = Block.box((double)12.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0);
    private static final VoxelShape WEST_SHAPE = Block.box((double)0.0, (double)1.0, (double)1.0, (double)4.0, (double)15.0, (double)15.0);
    private static final VoxelShape UP_SHAPE = Block.box((double)1.0, (double)12.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private static final VoxelShape DOWN_SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)4.0, (double)15.0);
    private static final VoxelShape NORTH_SHAPE_SUPPORT = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    private static final VoxelShape SOUTH_SHAPE_SUPPORT = Block.box((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_SHAPE_SUPPORT = Block.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_SHAPE_SUPPORT = Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    private static final VoxelShape UP_SHAPE_SUPPORT = Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape DOWN_SHAPE_SUPPORT = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);

    public TransformerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.DOWN));
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape transformerShape = switch ((Direction)state.getValue((Property)FACING)) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> DOWN_SHAPE;
            case Direction.UP -> UP_SHAPE;
            case Direction.NORTH -> NORTH_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            case Direction.EAST -> EAST_SHAPE;
        };
        VoxelShape cableShape = super.getShape(state, level, pos, context);
        return Shapes.or((VoxelShape)transformerShape, (VoxelShape)cableShape);
    }

    public VoxelShape getBlockSupportShape(BlockState state, BlockGetter level, BlockPos pos) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> DOWN_SHAPE_SUPPORT;
            case Direction.UP -> UP_SHAPE_SUPPORT;
            case Direction.NORTH -> NORTH_SHAPE_SUPPORT;
            case Direction.SOUTH -> SOUTH_SHAPE_SUPPORT;
            case Direction.WEST -> WEST_SHAPE_SUPPORT;
            case Direction.EAST -> EAST_SHAPE_SUPPORT;
        };
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    @Override
    public int getChannelCountForConnection(BlockPos self, BlockPos from, Level level) {
        BlockState state = level.getBlockState(self);
        if (state.hasProperty((Property)FACING) && !from.equals((Object)self.offset(((Direction)state.getValue((Property)FACING)).getNormal()))) {
            return 1;
        }
        return 0;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction facing = context.getNearestLookingDirection().getOpposite();
        if (context.getPlayer() != null && context.getPlayer().isShiftKeyDown()) {
            facing = facing.getOpposite();
        }
        return this.getNewBlockState((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing), context.getLevel(), context.getClickedPos());
    }

    public static BlockPos getFacingPos(BlockPos pos, BlockState state) {
        return pos.offset(((Direction)state.getValue((Property)FACING)).getNormal());
    }

    @Override
    public boolean isTerminal() {
        return true;
    }
}

