/*
 * Decompiled with CFR 0.152.
 */
package g_mungus.zps.blockentity;

import g_mungus.zps.block.cableNetwork.core.NetworkNode;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class NetworkTerminal
extends BlockEntity {
    private final Map<Integer, List<NetworkNode>> terminals = new ConcurrentHashMap<Integer, List<NetworkNode>>();

    public NetworkTerminal(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void defineTerminals(List<NetworkNode> terminals, int channel) {
        this.terminals.put(channel, terminals.stream().map(node -> new NetworkNode(node.pos().subtract((Vec3i)this.worldPosition), node.channel(), node.terminal())).toList());
    }

    public List<NetworkNode> getTerminals(int channel) {
        List<NetworkNode> nodes = this.terminals.get(channel);
        if (nodes != null) {
            return nodes.stream().map(node -> new NetworkNode(node.pos().offset((Vec3i)this.worldPosition), node.channel(), node.terminal())).toList();
        }
        return List.of();
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.terminals.clear();
        if (tag.contains("Terminals", 9)) {
            ListTag terminalsList = tag.getList("Terminals", 10);
            for (int i = 0; i < terminalsList.size(); ++i) {
                CompoundTag terminalTag = terminalsList.getCompound(i);
                int channel = terminalTag.getInt("Channel");
                ListTag nodesList = terminalTag.getList("Nodes", 10);
                List<NetworkNode> nodes = nodesList.stream().map(nodeTag -> {
                    CompoundTag nodeCompound = (CompoundTag)nodeTag;
                    BlockPos pos = BlockPos.of((long)nodeCompound.getLong("Pos"));
                    int nodeChannel = nodeCompound.getInt("Channel");
                    boolean isTerminal = nodeCompound.getBoolean("IsTerminal");
                    return new NetworkNode(pos, nodeChannel, isTerminal);
                }).toList();
                this.terminals.put(channel, nodes);
            }
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        ListTag terminalsList = new ListTag();
        this.terminals.forEach((channel, nodes) -> {
            CompoundTag terminalTag = new CompoundTag();
            terminalTag.putInt("Channel", channel.intValue());
            ListTag nodesList = new ListTag();
            nodes.forEach(node -> {
                CompoundTag nodeTag = new CompoundTag();
                nodeTag.putLong("Pos", node.pos().asLong());
                nodeTag.putInt("Channel", node.channel());
                nodeTag.putBoolean("IsTerminal", node.terminal());
                nodesList.add((Object)nodeTag);
            });
            terminalTag.put("Nodes", (Tag)nodesList);
            terminalsList.add((Object)terminalTag);
        });
        tag.put("Terminals", (Tag)terminalsList);
    }
}

